/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarGeofence;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUser {
    private String mId;
    private String mUserId;
    private String mDescription;
    private RadarGeofence[] mGeofences;

    public RadarUser(String _id, String userId, String description, RadarGeofence[] geofences) {
        this.mId = _id;
        this.mUserId = userId;
        this.mDescription = description;
        this.mGeofences = geofences;
    }

    public RadarUser(JSONObject obj) throws JSONException {
        if (obj.has("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("userId")) {
            this.mUserId = obj.getString("userId");
        }
        if (obj.has("description")) {
            this.mDescription = obj.getString("description");
        }
        if (obj.has("geofences")) {
            JSONArray geofencesArray = obj.getJSONArray("geofences");
            int numGeofences = geofencesArray.length();
            this.mGeofences = new RadarGeofence[numGeofences];
            for (int i = 0; i < numGeofences; ++i) {
                RadarGeofence geofence;
                JSONObject geofenceObj = geofencesArray.getJSONObject(i);
                this.mGeofences[i] = geofence = new RadarGeofence(geofenceObj);
            }
        }
    }

    public String getId() {
        return this.mId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public RadarGeofence[] getGeofences() {
        return this.mGeofences;
    }
}

