/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarGeofence;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarEvent {
    private String mId;
    private Date mCreatedAt;
    private boolean mLive;
    private RadarEventType mType;
    private RadarGeofence mGeofence;
    private RadarEventConfidence mConfidence;
    private float mDuration;

    public static RadarEvent[] eventsFromJSONArray(JSONArray array) throws JSONException, ParseException {
        int numEvents = array.length();
        RadarEvent[] events = new RadarEvent[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            RadarEvent event;
            JSONObject eventObj = array.getJSONObject(i);
            events[i] = event = new RadarEvent(eventObj);
        }
        return events;
    }

    public RadarEvent(String _id, Date createdAt, boolean live, RadarEventType type, RadarGeofence geofence, RadarEventConfidence confidence, float duration) {
        this.mId = _id;
        this.mCreatedAt = createdAt;
        this.mLive = live;
        this.mType = type;
        this.mGeofence = geofence;
        this.mConfidence = confidence;
        this.mDuration = duration;
    }

    public RadarEvent(JSONObject obj) throws JSONException, ParseException {
        if (obj.has("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("createdAt")) {
            String eventCreatedAtStr = obj.getString("createdAt");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.mCreatedAt = dateFormat.parse(eventCreatedAtStr);
        }
        if (obj.has("live")) {
            this.mLive = obj.getBoolean("live");
        }
        if (obj.has("type")) {
            String typeStr = obj.getString("type");
            if (typeStr.equals("user.entered_geofence")) {
                this.mType = RadarEventType.USER_ENTERED_GEOFENCE;
            } else if (typeStr.equals("user.exited_geofence")) {
                this.mType = RadarEventType.USER_EXITED_GEOFENCE;
            }
        }
        if (obj.has("geofence")) {
            JSONObject geofenceObj = obj.getJSONObject("geofence");
            this.mGeofence = new RadarGeofence(geofenceObj);
        }
        if (obj.has("confidence")) {
            int confidenceInt = obj.getInt("confidence");
            this.mConfidence = confidenceInt == 3 ? RadarEventConfidence.HIGH : (confidenceInt == 2 ? RadarEventConfidence.MEDIUM : (confidenceInt == 1 ? RadarEventConfidence.LOW : RadarEventConfidence.NONE));
        }
        if (obj.has("duration")) {
            this.mDuration = (float)obj.getDouble("duration");
        }
    }

    public String getId() {
        return this.mId;
    }

    public Date getCreatedAt() {
        return this.mCreatedAt;
    }

    public boolean getLive() {
        return this.mLive;
    }

    public RadarEventType getType() {
        return this.mType;
    }

    public RadarGeofence getGeofence() {
        return this.mGeofence;
    }

    public RadarEventConfidence getConfidence() {
        return this.mConfidence;
    }

    public float getDuration() {
        return this.mDuration;
    }

    public static enum RadarEventConfidence {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RadarEventType {
        USER_ENTERED_GEOFENCE,
        USER_EXITED_GEOFENCE;

    }
}

