/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.location.Location;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.Volley;
import com.onradar.sdk.Radar;
import com.onradar.sdk._CustomJsonObjectRequest;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk._RadarUtils;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarClient {
    private static _RadarClient mInstance;
    private RequestQueue mRequestQueue;

    _RadarClient() {
    }

    static synchronized _RadarClient getSharedInstance() {
        if (mInstance == null) {
            mInstance = new _RadarClient();
        }
        return mInstance;
    }

    void updateLocation(final Context context, final Location location, final boolean foreground, final _RadarCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String publishableKey = _RadarSettings.getPublishableKey(context);
                if (publishableKey == null || publishableKey.length() == 0) {
                    callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
                    return;
                }
                String userId = _RadarSettings.getUserId(context);
                if (userId == null || userId.length() == 0) {
                    callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
                    return;
                }
                String description = _RadarSettings.getDescription(context);
                String longitude = Double.toString(location.getLongitude());
                String latitude = Double.toString(location.getLatitude());
                String accuracy = Float.toString(location.getAccuracy());
                String altitude = Double.toString(location.getAltitude());
                String speed = Float.toString(location.getSpeed());
                String course = Float.toString(location.getBearing());
                String adId = _RadarUtils.getAdId(context);
                String deviceMake = _RadarUtils.getDeviceMake();
                String deviceModel = _RadarUtils.getDeviceModel();
                String deviceOS = _RadarUtils.getDeviceOS();
                String sdkVersion = _RadarUtils.getSDKVersion();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("deviceType", "Android");
                params.put("longitude", longitude);
                params.put("latitude", latitude);
                params.put("accuracy", accuracy);
                params.put("foreground", foreground ? "true" : "false");
                params.put("altitude", altitude);
                params.put("speed", speed);
                params.put("course", course);
                params.put("deviceMake", deviceMake);
                params.put("deviceModel", deviceModel);
                params.put("deviceOS", deviceOS);
                params.put("sdkVersion", sdkVersion);
                if (description != null) {
                    params.put("description", description);
                }
                if (adId != null) {
                    params.put("adId", adId);
                }
                VolleyLog.DEBUG = _RadarSettings.isDebug(context);
                if (_RadarClient.this.mRequestQueue == null) {
                    _RadarClient.this.mRequestQueue = Volley.newRequestQueue((Context)context);
                }
                String host = _RadarSettings.getHost(context);
                String locationURL = host + "/api/v1/users/" + userId;
                _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        if (response != null) {
                            try {
                                JSONArray eventsArr = response.getJSONArray("events");
                                JSONObject userObj = response.getJSONObject("user");
                                RadarEvent[] events = RadarEvent.eventsFromJSONArray(eventsArr);
                                RadarUser user = new RadarUser(userObj);
                                callback.onCallback(Radar.RadarStatus.SUCCESS, response, events, user);
                            }
                            catch (ParseException | JSONException e) {
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                            }
                        }
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        if (error instanceof NetworkError || error instanceof TimeoutError) {
                            callback.onCallback(Radar.RadarStatus.ERROR_NETWORK, null, null, null);
                        } else if (error.networkResponse != null) {
                            if (error.networkResponse.statusCode == 400) {
                                callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
                            } else if (error.networkResponse.statusCode == 401) {
                                callback.onCallback(Radar.RadarStatus.ERROR_UNAUTHORIZED, null, null, null);
                            } else if (error.networkResponse.statusCode == 500) {
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                            }
                        } else {
                            callback.onCallback(Radar.RadarStatus.ERROR_UNKNOWN, null, null, null);
                        }
                    }
                });
                locationRequest.setHeader("Authorization", publishableKey);
                locationRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
                _RadarClient.this.mRequestQueue.add((Request)locationRequest);
            }
        }).start();
    }
}

