/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.Volley;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onradar.sdk.R;
import com.onradar.sdk.Radar;
import com.onradar.sdk.RadarCallback;
import com.onradar.sdk._CustomJsonObjectRequest;
import com.onradar.sdk._RadarLocationRequest;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class _Radar
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static final String TAG = "_Radar";
    private Context mContext;
    private String mPublishableKey;
    private List<_RadarLocationRequest> mLocationRequests;
    private GoogleApiClient mGoogleApiClient;
    private boolean mRestoreGeofencesPending;
    private boolean mCheckSignificantLocationChangePending;
    private boolean mRequestLocationOncePending;
    private boolean mRequestLocationMultiplePending;
    private boolean mStopTrackingPending;
    private Date mRequestedLocationEndsAt;
    private boolean mIgnoreRateLimit;

    _Radar() {
    }

    static _Radar getSharedInstance() {
        return _RadarHolder.INSTANCE;
    }

    void initialize(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        this.mContext = context;
        if (publishableKey == null) {
            if (this.mPublishableKey == null) {
                try {
                    this.mPublishableKey = this.mContext.getResources().getString(this.mContext.getResources().getIdentifier("radar_pk", "string", this.mContext.getPackageName()));
                }
                catch (Resources.NotFoundException e) {
                    this.mPublishableKey = this.getPublishableKey();
                    if (this.mPublishableKey == null) {
                        this.deliverError(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
                    }
                }
            }
        } else {
            this.setPublishableKey(publishableKey);
            this.mPublishableKey = publishableKey;
        }
        VolleyLog.DEBUG = this.isDebug();
        this.mLocationRequests = new ArrayList<_RadarLocationRequest>();
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
        }
    }

    void setUserId(String userId) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-userId", userId);
        editor.commit();
    }

    void setDescription(String description) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-description", description);
        editor.commit();
    }

    boolean checkSelfPermissions() {
        return this.mContext != null && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    void requestPermissions(Activity activity) {
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            int requestCode = 0;
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }
    }

    void trackOnce(RadarCallback callback) {
        if (this.mPublishableKey == null || this.mPublishableKey.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = this.getUserId();
        if (userId == null || userId.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PERMISSIONS, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarLocationRequest locationRequest = new _RadarLocationRequest(10000L, callback);
        this.mLocationRequests.add(locationRequest);
        this.requestLocationOnce();
    }

    void startTracking() {
        if (this.mPublishableKey == null || this.mPublishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = this.getUserId();
        if (userId == null || userId.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (!this.checkSelfPermissions()) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        this.setTracking(true);
        this.scheduleAlarm();
        this.requestLocationOnce();
    }

    void stopTracking() {
        if (this.mPublishableKey == null || this.mPublishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mStopTrackingPending = true;
            this.mGoogleApiClient.connect();
        }
        this.setTracking(false);
        JSONArray oldGeofences = this.getLastGeofences();
        int oldGeofencesLength = 0;
        if (oldGeofences != null) {
            oldGeofencesLength = oldGeofences.length();
        }
        this.clearLastGeofences();
        for (int i = 0; i < oldGeofencesLength; ++i) {
            try {
                JSONObject geofence = oldGeofences.getJSONObject(i);
                final String _id = geofence.getString("_id");
                try {
                    PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, Arrays.asList(_id));
                    result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                        public void onResult(Status status) {
                            if (status.isSuccess()) {
                                if (_Radar.getSharedInstance().isDebug()) {
                                    Log.v((String)_Radar.TAG, (String)("stopTracking() / removed geofence " + _id));
                                }
                                return;
                            }
                            if (_Radar.getSharedInstance().isDebug()) {
                                Log.v((String)_Radar.TAG, (String)("stopTracking() / error removing geofence " + _id + ": " + status.getStatusMessage()));
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {}
                continue;
            }
            catch (JSONException geofence) {
                // empty catch block
            }
        }
        Intent intent = new Intent("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
    }

    boolean isTracking() {
        return this.getTracking();
    }

    void didTimeout(_RadarLocationRequest locationRequest) {
        locationRequest.complete();
        RadarCallback callback = locationRequest.getCallback();
        if (callback != null) {
            callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
        }
        this.mLocationRequests.remove(locationRequest);
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnected(Bundle connectionHint) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnected()");
        }
        if (this.mRestoreGeofencesPending) {
            this.mRestoreGeofencesPending = false;
            this.restoreGeofences();
        }
        if (this.mCheckSignificantLocationChangePending) {
            this.mCheckSignificantLocationChangePending = false;
            this.checkSignificantLocationChange();
        }
        if (this.mRequestLocationOncePending) {
            this.mRequestLocationOncePending = false;
            this.requestLocationOnce();
        }
        if (this.mRequestLocationMultiplePending) {
            this.mRequestLocationMultiplePending = false;
            this.requestLocationMultiple();
        }
        if (this.mStopTrackingPending) {
            this.mStopTrackingPending = false;
            this.stopTracking();
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnectionFailed()");
        }
        this.deliverError(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnectionSuspended(int cause) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnectionSuspended()");
        }
        this.deliverError(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onLocationChanged(Location location) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged()");
            this.notify(0, "location changed");
        }
        if (this.mPublishableKey == null || this.mPublishableKey.length() == 0) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / publishable key is null");
            }
            this.deliverError(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        String userId = this.getUserId();
        if (userId == null || userId.length() == 0) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / user ID is null");
            }
            this.deliverError(Radar.RadarStatus.ERROR_USER_ID);
            return;
        }
        if (location == null) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / location is null, returning");
            }
            return;
        }
        Date now = new Date();
        Date sentAt = this.getSentAt();
        if (!this.mIgnoreRateLimit) {
            if (sentAt != null && now.getTime() - sentAt.getTime() < 50000L) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)"onLocationChanged() / background rate limit, returning");
                }
                return;
            }
        } else if (sentAt != null && now.getTime() - sentAt.getTime() < 1000L) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / foreground rate limit, returning");
            }
            return;
        }
        this.updateSentAt();
        this.mIgnoreRateLimit = false;
        String description = this.getDescription();
        String longitude = Double.toString(location.getLongitude());
        String latitude = Double.toString(location.getLatitude());
        String accuracy = Float.toString(location.getAccuracy());
        String foreground = this.mLocationRequests.size() > 0 ? "true" : "false";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceType", "Android");
        params.put("longitude", longitude);
        params.put("latitude", latitude);
        params.put("accuracy", accuracy);
        params.put("foreground", foreground);
        if (description != null) {
            params.put("description", description);
        }
        RequestQueue queue = Volley.newRequestQueue((Context)this.mContext);
        final Location lastLocation = location;
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged() / starting location request");
        }
        String locationURL = this.isLocal() ? "http://10.0.2.2:8081/api/v1/users/" + userId + "/location" : "https://www.onradar.com/api/v1/users/" + userId + "/location";
        _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)"onLocationChanged() / completed location request");
                    _Radar.getSharedInstance().notify(1, "sent updated location");
                }
                _Radar.getSharedInstance().deliverEvents(response, lastLocation);
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)("onLocationChanged() / error completing location request: " + error));
                    _Radar.getSharedInstance().notify(1, "error sending updated location");
                }
                if (error instanceof NetworkError || error instanceof NoConnectionError || error instanceof TimeoutError) {
                    _Radar.getSharedInstance().deliverError(Radar.RadarStatus.ERROR_NETWORK);
                } else if (error.networkResponse != null) {
                    if (error.networkResponse.statusCode == 401) {
                        _Radar.getSharedInstance().deliverError(Radar.RadarStatus.ERROR_UNAUTHORIZED);
                    } else if (error.networkResponse.statusCode == 500) {
                        _Radar.getSharedInstance().deliverError(Radar.RadarStatus.ERROR_SERVER);
                    }
                } else {
                    _Radar.getSharedInstance().deliverError(Radar.RadarStatus.ERROR_UNKNOWN);
                }
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        });
        locationRequest.setHeader("Authorization", this.mPublishableKey);
        locationRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        queue.add((Request)locationRequest);
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged() / starting geofences request");
        }
        String geofencesURL = this.isLocal() ? "http://10.0.2.2:8081/api/v1/users/" + userId + "/geofences?latitude=" + latitude + "&longitude=" + longitude : "https://www.onradar.com/api/v1/users/" + userId + "/geofences?latitude=" + latitude + "&longitude=" + longitude;
        _CustomJsonObjectRequest geofencesRequest = new _CustomJsonObjectRequest(0, geofencesURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)"onLocationChanged() / completed geofences request");
                }
                try {
                    JSONArray geofences = response.getJSONArray("geofences");
                    _Radar.getSharedInstance().setGeofences(geofences, false);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                _Radar.getSharedInstance().setLastLocation(lastLocation);
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)("onLocationChanged() / error completing geofences request: " + error));
                }
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        });
        geofencesRequest.setHeader("Authorization", this.mPublishableKey);
        geofencesRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        queue.add((Request)geofencesRequest);
    }

    void onHandleIntent(Intent intent) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onHandleIntent()");
        }
        if (intent == null) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / no intent");
            }
            return;
        }
        if (!this.getTracking()) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / not tracking");
            }
            return;
        }
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / android.intent.action.BOOT_COMPLETED");
            }
            this.restoreGeofences();
            this.scheduleAlarm();
            this.requestLocationMultiple();
        } else if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / android.net.conn.CONNECTIVITY_CHANGE");
            }
            this.checkSignificantLocationChange();
        } else if (intent.getAction().equals("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED")) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED");
            }
            this.checkSignificantLocationChange();
        } else if (intent.getAction().equals("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED")) {
            GeofencingEvent event;
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED");
            }
            if ((event = GeofencingEvent.fromIntent((Intent)intent)) == null || event.getGeofenceTransition() != 1 && event.getGeofenceTransition() != 2 && event.getGeofenceTransition() != 4) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)"onHandleIntent() / no geofencing event");
                }
                return;
            }
            if (event.hasError()) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)("onHandleIntent() / geofencing event error: " + event.getErrorCode()));
                }
                return;
            }
            if (this.isDebug()) {
                String transition;
                switch (event.getGeofenceTransition()) {
                    case 1: {
                        transition = "enter";
                        break;
                    }
                    case 2: {
                        transition = "exit";
                        break;
                    }
                    case 4: {
                        transition = "dwell";
                        break;
                    }
                    default: {
                        transition = "unknown";
                    }
                }
                List triggeringGeofences = event.getTriggeringGeofences();
                if (triggeringGeofences != null) {
                    for (Geofence geofence : triggeringGeofences) {
                        String _id = geofence.getRequestId();
                        Log.v((String)TAG, (String)("onHandleIntent() / " + transition + " transition for geofence " + _id));
                        this.notify(4, transition + " transition for geofence " + _id);
                    }
                }
            }
            this.requestLocationMultiple();
        }
    }

    void restoreGeofences() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRestoreGeofencesPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"restoreGeofences()");
            this.notify(5, "restoring geofences");
        }
        JSONArray geofences = this.getLastGeofences();
        this.setGeofences(geofences, true);
    }

    void scheduleAlarm() {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"scheduleAlarm()");
            this.notify(6, "scheduling alarm");
        }
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent("com.onradar.sdk._RadarReceiver.ALARM_TRIGGERED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        alarmManager.setInexactRepeating(2, 900000L, 900000L, pendingIntent);
    }

    private void checkSignificantLocationChange() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mCheckSignificantLocationChangePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"checkSignificantLocationChange()");
            this.notify(7, "checking significant location change");
        }
        try {
            Location currentLocation = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
            Location lastLocation = this.getLastLocation();
            if (currentLocation != null && lastLocation != null && lastLocation.distanceTo(currentLocation) >= 500.0f) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)"checkSignificantLocationChange() / significant location change");
                    this.notify(7, "significant location change");
                }
                this.sendLocation(currentLocation);
            } else if (this.isDebug()) {
                Log.v((String)TAG, (String)"checkSignificantLocationChange() / not significant location change");
                this.notify(7, "not significant location change");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void sendLocation(Location location) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"sendLocation()");
            this.notify(2, "sending location");
        }
        this.onLocationChanged(location);
    }

    private void requestLocationOnce() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"requestLocationOnce()");
            this.notify(2, "requesting single location update");
        }
        this.mIgnoreRateLimit = true;
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(5000L);
        locationRequest.setFastestInterval(1000L);
        locationRequest.setPriority(100);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, (LocationListener)this, Looper.getMainLooper());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void requestLocationMultiple() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationMultiplePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"requestLocationMultiple()");
            this.notify(2, "requesting multiple location updates");
        }
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(60000L);
        locationRequest.setFastestInterval(5000L);
        locationRequest.setPriority(102);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, (LocationListener)this, Looper.getMainLooper());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Date now = new Date();
        now.setTime(now.getTime() + 300000L);
        this.mRequestedLocationEndsAt = now;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, 330000L);
    }

    private void tryStopUpdatingLocation() {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"tryStopUpdatingLocation()");
        }
        Date now = new Date();
        if (this.mRequestedLocationEndsAt == null || now.getTime() - this.mRequestedLocationEndsAt.getTime() > 0L) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"tryStopUpdatingLocation() / stopping location updates");
                this.notify(3, "stopping location updates");
            }
            this.mRequestedLocationEndsAt = null;
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        }
    }

    private void sendErrorIntent(Radar.RadarStatus status) {
        if (this.mContext != null) {
            Intent intent = new Intent("com.onradar.sdk.RECEIVED");
            intent.putExtra("status", status.ordinal());
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"sendErrorIntent() / sending broadcast");
            }
            this.mContext.sendBroadcast(intent);
        }
    }

    private void deliverError(Radar.RadarStatus status) {
        if (this.mLocationRequests != null) {
            for (_RadarLocationRequest locationRequest : this.mLocationRequests) {
                locationRequest.complete();
                RadarCallback callback = locationRequest.getCallback();
                if (callback == null) continue;
                callback.onCallback(status, null, null, null);
            }
            this.mLocationRequests.clear();
        }
        this.sendErrorIntent(status);
    }

    private void deliverEvents(JSONObject responseObj, Location location) {
        RadarEvent[] events;
        RadarUser user;
        block5: {
            user = null;
            events = null;
            if (responseObj != null && location != null) {
                try {
                    JSONArray eventsArr = responseObj.getJSONArray("events");
                    int numEvents = eventsArr.length();
                    events = new RadarEvent[numEvents];
                    for (int i = 0; i < numEvents; ++i) {
                        RadarEvent event;
                        JSONObject eventObj = eventsArr.getJSONObject(i);
                        events[i] = event = new RadarEvent(eventObj);
                    }
                    JSONObject userObj = responseObj.getJSONObject("user");
                    user = new RadarUser(userObj);
                    if (this.isDebug()) {
                        Log.v((String)TAG, (String)("deliverEvents() / deserialized response: " + responseObj + " / " + user + " / " + events));
                    }
                }
                catch (ParseException | JSONException e) {
                    if (!this.isDebug()) break block5;
                    Log.v((String)TAG, (String)("deliverEvents() / error deserializing response: " + e));
                }
            }
        }
        this.handleLocationRequests(location, responseObj, events, user);
    }

    private void handleLocationRequests(Location location, JSONObject responseObj, RadarEvent[] events, RadarUser user) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"handleLocationRequests()");
        }
        String userId = this.getUserId();
        Radar.RadarStatus status = Radar.RadarStatus.SUCCESS;
        if (this.mPublishableKey == null || this.mPublishableKey.length() == 0) {
            status = Radar.RadarStatus.ERROR_PUBLISHABLE_KEY;
        } else if (userId == null || userId.length() == 0) {
            status = Radar.RadarStatus.ERROR_USER_ID;
        } else if (!this.checkSelfPermissions()) {
            status = Radar.RadarStatus.ERROR_PERMISSIONS;
        } else if (location == null || responseObj == null || user == null) {
            status = Radar.RadarStatus.ERROR_UNKNOWN;
        }
        for (_RadarLocationRequest locationRequest : this.mLocationRequests) {
            locationRequest.complete();
            RadarCallback callback = locationRequest.getCallback();
            if (callback == null) continue;
            if (status == Radar.RadarStatus.SUCCESS) {
                callback.onCallback(status, location, events, user);
                continue;
            }
            callback.onCallback(status, null, null, null);
        }
        this.mLocationRequests.clear();
        if (responseObj != null && this.mContext != null) {
            String json = responseObj.toString();
            Intent intent = new Intent("com.onradar.sdk.RECEIVED");
            if (status == Radar.RadarStatus.SUCCESS) {
                intent.putExtra("response", json);
            } else {
                intent.putExtra("status", status.ordinal());
            }
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"deliverEvents() / sending broadcast");
            }
            this.mContext.sendBroadcast(intent);
        }
    }

    private void setGeofences(JSONArray geofences, boolean force) {
        String _id;
        JSONObject geofence3;
        int i;
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"setGeofences()");
        }
        if (geofences == null) {
            return;
        }
        HashSet<String> newGeofenceIdsSet = new HashSet<String>();
        for (int i2 = 0; i2 < geofences.length(); ++i2) {
            try {
                JSONObject geofence2 = geofences.getJSONObject(i2);
                String _id2 = geofence2.getString("_id");
                newGeofenceIdsSet.add(_id2);
                continue;
            }
            catch (JSONException geofence2) {
                // empty catch block
            }
        }
        JSONArray oldGeofences = this.getLastGeofences();
        int oldGeofencesLength = 0;
        if (oldGeofences != null) {
            oldGeofencesLength = oldGeofences.length();
        }
        HashSet<String> oldGeofenceIdsSet = new HashSet<String>();
        if (!force) {
            for (i = 0; i < oldGeofencesLength; ++i) {
                try {
                    geofence3 = oldGeofences.getJSONObject(i);
                    _id = geofence3.getString("_id");
                    oldGeofenceIdsSet.add(_id);
                    if (newGeofenceIdsSet.contains(_id)) continue;
                    try {
                        PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, Arrays.asList(_id));
                        result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                            public void onResult(Status status) {
                                if (status.isSuccess()) {
                                    if (_Radar.getSharedInstance().isDebug()) {
                                        Log.v((String)_Radar.TAG, (String)("setGeofences() / removed geofence " + _id));
                                    }
                                    return;
                                }
                                if (_Radar.getSharedInstance().isDebug()) {
                                    Log.v((String)_Radar.TAG, (String)("setGeofences() / error removing geofence " + _id + ": " + status.getStatusMessage()));
                                }
                            }
                        });
                    }
                    catch (SecurityException result) {}
                    continue;
                }
                catch (JSONException geofence3) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < geofences.length(); ++i) {
            try {
                geofence3 = geofences.getJSONObject(i);
                _id = geofence3.getString("_id");
                if (oldGeofenceIdsSet.contains(_id)) continue;
                JSONObject geometryCenter = geofence3.getJSONObject("geometryCenter");
                JSONArray geometryCenterCoordinates = geometryCenter.getJSONArray("coordinates");
                double longitude = geometryCenterCoordinates.getDouble(0);
                double latitude = geometryCenterCoordinates.getDouble(1);
                float radius = (float)geofence3.getDouble("geometryRadius");
                if (radius <= 100.0f) {
                    radius = 100.0f;
                }
                Geofence newGeofence = new Geofence.Builder().setRequestId(_id).setTransitionTypes(7).setLoiteringDelay(600000).setCircularRegion(latitude, longitude, radius).setExpirationDuration(-1L).build();
                GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
                GeofencingRequest request = builder.addGeofence(newGeofence).setInitialTrigger(1).build();
                Intent intent = new Intent("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED");
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
                try {
                    PendingResult result = LocationServices.GeofencingApi.addGeofences(this.mGoogleApiClient, request, pendingIntent);
                    result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                        public void onResult(Status status) {
                            if (status.isSuccess()) {
                                if (_Radar.getSharedInstance().isDebug()) {
                                    Log.v((String)_Radar.TAG, (String)("setGeofences() / added geofence " + _id));
                                }
                                return;
                            }
                            if (_Radar.getSharedInstance().isDebug()) {
                                Log.v((String)_Radar.TAG, (String)("setGeofences() / error adding geofence " + _id + ": " + status.getStatusMessage()));
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {}
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.setLastGeofences(geofences);
    }

    private String getPublishableKey() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-publishableKey", null);
    }

    private void setPublishableKey(String publishableKey) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-publishableKey", publishableKey);
        editor.commit();
    }

    private String getUserId() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-userId", null);
    }

    private String getDescription() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-description", null);
    }

    private void setTracking(boolean tracking) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-tracking", tracking);
        editor.commit();
    }

    private boolean getTracking() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-tracking", false);
    }

    private void setLastLocation(Location location) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putFloat("radar-lastLocationLongitude", (float)location.getLongitude());
        editor.putFloat("radar-lastLocationLatitude", (float)location.getLatitude());
        editor.putFloat("radar-lastLocationAccuracy", location.getAccuracy());
        editor.putString("radar-lastLocationProvider", location.getProvider());
        editor.commit();
    }

    private Location getLastLocation() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        double longitude = preferences.getFloat("radar-lastLocationLongitude", 0.0f);
        double latitude = preferences.getFloat("radar-lastLocationLatitude", 0.0f);
        float accuracy = preferences.getFloat("radar-lastLocationAccuracy", 0.0f);
        String provider = preferences.getString("radar-lastLocationProvider", null);
        if (longitude == 0.0 || latitude == 0.0 || accuracy == 0.0f || provider == null) {
            return null;
        }
        Location location = new Location(provider);
        location.setLongitude(longitude);
        location.setLatitude(latitude);
        location.setAccuracy(accuracy);
        return location;
    }

    private void updateSentAt() {
        if (this.mContext == null) {
            return;
        }
        Date now = new Date();
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-sentAt", now.getTime());
        editor.commit();
    }

    private Date getSentAt() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        long milliseconds = preferences.getLong("radar-sentAt", 0L);
        return new Date(milliseconds);
    }

    private void clearLastGeofences() {
        if (this.mContext == null) {
            return;
        }
        String emptyGeofencesString = "[]";
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-lastGeofences", emptyGeofencesString);
        editor.commit();
    }

    private void setLastGeofences(JSONArray geofences) {
        if (this.mContext == null) {
            return;
        }
        String lastGeofencesString = geofences.toString();
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-lastGeofences", lastGeofencesString);
        editor.commit();
    }

    private JSONArray getLastGeofences() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        String lastGeofencesString = preferences.getString("radar-lastGeofences", "[]");
        try {
            return new JSONArray(lastGeofencesString);
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    private boolean isDebug() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-debug", false);
    }

    private boolean isLocal() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-local", false);
    }

    private void notify(int id, String text) {
        if (this.mContext == null) {
            return;
        }
        Notification notification = new Notification.Builder(this.mContext).setContentTitle((CharSequence)"DEBUG").setContentText((CharSequence)text).setSmallIcon(R.drawable.notification).build();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        notificationManager.cancel(TAG, id);
        notificationManager.notify(TAG, id, notification);
    }

    private static class _RadarHolder {
        static final _Radar INSTANCE = new _Radar();

        private _RadarHolder() {
        }
    }
}

