/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.onradar.sdk.Radar;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RadarReceiver
extends BroadcastReceiver {
    public static final String RECEIVED = "com.onradar.sdk.RECEIVED";

    public void onReceive(Context context, Intent intent) {
        if (intent != null && intent.getAction().equals(RECEIVED)) {
            String response = intent.getStringExtra("response");
            if (response != null) {
                try {
                    JSONObject responseObj = new JSONObject(response);
                    JSONArray eventsArr = responseObj.getJSONArray("events");
                    int numEvents = eventsArr.length();
                    RadarEvent[] events = new RadarEvent[numEvents];
                    for (int i = 0; i < numEvents; ++i) {
                        RadarEvent event;
                        JSONObject eventObj = eventsArr.getJSONObject(i);
                        events[i] = event = new RadarEvent(eventObj);
                    }
                    JSONObject userObj = responseObj.getJSONObject("user");
                    RadarUser user = new RadarUser(userObj);
                    if (events.length > 0) {
                        this.onEventsReceived(context, events, user);
                    }
                }
                catch (ParseException | JSONException e) {
                    this.onError(context, Radar.RadarStatus.ERROR_UNKNOWN);
                }
            } else {
                Radar.RadarStatus status = Radar.RadarStatus.fromOrdinal(intent.getIntExtra("status", -1));
                if (status != Radar.RadarStatus.SUCCESS && status != Radar.RadarStatus.UNKNOWN) {
                    this.onError(context, status);
                }
            }
        }
    }

    public abstract void onEventsReceived(Context var1, RadarEvent[] var2, RadarUser var3);

    public abstract void onError(Context var1, Radar.RadarStatus var2);
}

