package com.onradar.sdk;

import android.location.Location;

import com.onradar.sdk.Radar.RadarStatus;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;

public abstract class RadarCallback {

    /**
     * Called when a request succeeds, times out, or fails.
     *
     * @param status The request status.
     * @param location The current location.
     * @param events The events generated, if any.
     * @param user The current user.
     */
    public abstract void onCallback(RadarStatus status, Location location, RadarEvent[] events, RadarUser user);

}
