package com.onradar.sdk;

import android.app.Activity;
import android.content.Context;

public class Radar {

    public enum RadarStatus {
        SUCCESS,
        ERROR_PUBLISHABLE_KEY,
        ERROR_USER_ID,
        ERROR_PERMISSIONS,
        ERROR_LOCATION,
        ERROR_NETWORK,
        ERROR_UNAUTHORIZED,
        ERROR_SERVER,
        ERROR_UNKNOWN,
        UNKNOWN;

        public static RadarStatus fromOrdinal(int ordinal) {
            switch (ordinal) {
                case 0:
                    return RadarStatus.SUCCESS;
                case 1:
                    return RadarStatus.ERROR_PUBLISHABLE_KEY;
                case 2:
                    return RadarStatus.ERROR_USER_ID;
                case 3:
                    return RadarStatus.ERROR_PERMISSIONS;
                case 4:
                    return RadarStatus.ERROR_LOCATION;
                case 5:
                    return RadarStatus.ERROR_NETWORK;
                case 6:
                    return RadarStatus.ERROR_UNAUTHORIZED;
                case 7:
                    return RadarStatus.ERROR_SERVER;
                case 8:
                    return RadarStatus.ERROR_UNKNOWN;
                default:
                    return RadarStatus.UNKNOWN;
            }
        }
    }

    /**
     * Initializes the Radar SDK. You must call this method in the onCreate() method of your main activity. Before calling this method, your publishable API key must have been added as a string resource in your project.
     *
     * @param context The main activity.
     */
    public static void initialize(Context context) {
        _Radar.getSharedInstance().initialize(context, null);
    }

    /**
     * Initializes the Radar SDK. You must call this method in the onCreate() method of your main activity.
     *
     * @param context The main activity.
     */
    public static void initialize(Context context, String publishableKey) {
        _Radar.getSharedInstance().initialize(context, publishableKey);
    }

    /**
     * Identifies the user. You must call this method once before calling trackOnce() or startTracking().
     *
     * @param userId A stable unique ID for the user.
     */
    public static void setUserId(String userId) {
        _Radar.getSharedInstance().setUserId(userId);
    }

    /**
     * Identifies the user. You must call this method once before calling trackOnce() or startTracking().
     *
     * @param description An optional description for the user. If null, the previous description will be cleared.
     */
    public static void setDescription(String description) {
        _Radar.getSharedInstance().setDescription(description);
    }

    /**
     * Determines whether the user has granted location permissions for the app.
     *
     * @return A boolean indicating whether the user has granted location permissions for the app.
     */
    public static boolean checkSelfPermissions() {
        return _Radar.getSharedInstance().checkSelfPermissions();
    }

    /**
     * Requests permission to track the user's location.
     *
     * @param activity The activity from which to show the permissions prompt.
     */
    public static void requestPermissions(Activity activity) {
        _Radar.getSharedInstance().requestPermissions(activity);
    }

    /**
     * Tracks the user's location once in the foreground. Before calling this method, you must have called setUserId() once to identify the user, and the user must have granted location permissions for the app.
     *
     * @param callback An optional callback.
     */
    public static void trackOnce(RadarCallback callback) {
        _Radar.getSharedInstance().trackOnce(callback);
    }

    /**
     * Starts tracking the user's location in the background. Before calling this method, you must have called setUserId() once to identify the user, and the user must have granted location permissions for the app
     */
    public static void startTracking() {
        _Radar.getSharedInstance().startTracking();
    }

    /**
     * Stops tracking the user's location in the background.
     */
    public static void stopTracking() {
        _Radar.getSharedInstance().stopTracking();
    }

    /**
     * Returns a boolean indicating whether the user's location is being tracked in the background.
     *
     * @return A boolean indicating whether the user's location is being tracked in the background.
     */
    public static boolean isTracking() {
        return _Radar.getSharedInstance().isTracking();
    }

}
