/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarUserInsightsLocation;
import com.onradar.sdk.model.RadarUserInsightsState;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUserInsights {
    private RadarUserInsightsLocation mHomeLocation;
    private RadarUserInsightsLocation mOfficeLocation;
    private RadarUserInsightsState mState;

    public RadarUserInsights(RadarUserInsightsLocation homeLocation, RadarUserInsightsLocation officeLocation, RadarUserInsightsState state) {
        this.mHomeLocation = homeLocation;
        this.mOfficeLocation = officeLocation;
        this.mState = state;
    }

    public RadarUserInsights(JSONObject obj) throws JSONException, ParseException {
        if (obj == null) {
            return;
        }
        if (obj.has("locations")) {
            JSONArray locationsArray = obj.getJSONArray("locations");
            int numLocations = locationsArray.length();
            for (int i = 0; i < numLocations; ++i) {
                JSONObject locationObj = locationsArray.getJSONObject(i);
                RadarUserInsightsLocation location = new RadarUserInsightsLocation(locationObj);
                if (location.getType() == RadarUserInsightsLocation.RadarUserInsightsLocationType.HOME) {
                    this.mHomeLocation = location;
                    continue;
                }
                if (location.getType() != RadarUserInsightsLocation.RadarUserInsightsLocationType.OFFICE) continue;
                this.mOfficeLocation = location;
            }
        }
        if (obj.has("state")) {
            this.mState = new RadarUserInsightsState(obj.getJSONObject("state"));
        }
    }

    public RadarUserInsightsLocation getHomeLocation() {
        return this.mHomeLocation;
    }

    public RadarUserInsightsLocation getOfficeLocation() {
        return this.mOfficeLocation;
    }

    public RadarUserInsightsState getState() {
        return this.mState;
    }
}

