/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarUtils {
    _RadarUtils() {
    }

    static String getWifi(Context context) {
        try {
            JSONObject disabled = new JSONObject();
            disabled.put("enabled", false);
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return disabled.toString();
            }
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo == null || TextUtils.isEmpty((CharSequence)wifiInfo.getBSSID()) || wifiInfo.getSupplicantState() != SupplicantState.COMPLETED) {
                return disabled.toString();
            }
            JSONObject wifi = new JSONObject();
            wifi.put("bssid", (Object)wifiInfo.getBSSID());
            wifi.put("ssid", (Object)wifiInfo.getSSID());
            wifi.put("rssi", wifiInfo.getRssi());
            if (Build.VERSION.SDK_INT >= 21) {
                wifi.put("frequency", wifiInfo.getFrequency());
            }
            JSONObject enabled = new JSONObject();
            enabled.put("enabled", true);
            enabled.put("current_connection", (Object)wifi);
            return enabled.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    static boolean isWifiEnabled(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
            return false;
        }
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        return wifiManager != null && wifiManager.isWifiEnabled();
    }

    static String getDeviceMake() {
        return Build.MANUFACTURER;
    }

    static String getDeviceModel() {
        return Build.MODEL;
    }

    static String getDeviceOS() {
        return Build.VERSION.RELEASE;
    }

    static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    static String getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return String.valueOf(offset / 1000);
    }

    static String getSDKVersion() {
        return "1.1.14";
    }
}

