/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.Context;
import android.location.Location;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.onradar.sdk.Radar;
import com.onradar.sdk._CustomJsonObjectRequest;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarLogger;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk._RadarUtils;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarClient {
    private static _RadarClient sInstance;
    private RequestQueue mRequestQueue;
    private boolean mSending;

    _RadarClient() {
    }

    static synchronized _RadarClient getSharedInstance() {
        if (sInstance == null) {
            sInstance = new _RadarClient();
        }
        return sInstance;
    }

    void updateLocation(final Context context, Location location, final boolean foreground, final _RadarCallback callback) {
        _RadarClient client = this;
        if (this.mSending) {
            return;
        }
        this.mSending = true;
        final String publishableKey = _RadarSettings.getPublishableKey(context);
        if (publishableKey == null || publishableKey.length() == 0) {
            callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            this.mSending = false;
            return;
        }
        final String userId = _RadarSettings.getUserId(context);
        if (userId == null || userId.length() == 0) {
            callback.onCallback(Radar.RadarStatus.ERROR_USER_ID, null, null, null);
            this.mSending = false;
            return;
        }
        final String description = _RadarSettings.getDescription(context);
        final String longitude = Double.toString(location.getLongitude());
        final String latitude = Double.toString(location.getLatitude());
        final String accuracy = Float.toString(location.getAccuracy());
        final String altitude = Double.toString(location.getAltitude());
        final String speed = Float.toString(location.getSpeed());
        final String course = Float.toString(location.getBearing());
        final String adId = _RadarSettings.getAdId(context);
        final String deviceMake = _RadarUtils.getDeviceMake();
        final String deviceModel = _RadarUtils.getDeviceModel();
        final String deviceOS = _RadarUtils.getDeviceOS();
        final String country = _RadarUtils.getCountry();
        final String timeZoneOffset = _RadarUtils.getTimeZoneOffset();
        final String sdkVersion = _RadarUtils.getSDKVersion();
        String wifi = _RadarUtils.getWifi(context);
        _RadarLogger.log(context, "sending wifi: " + wifi);
        client.getFacebookPlacesForLocation(context, location, new _RadarFacebookPlacesCallback(){

            @Override
            void onCallback(String facebookPlaces) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("deviceType", "Android");
                params.put("longitude", longitude);
                params.put("latitude", latitude);
                params.put("accuracy", accuracy);
                params.put("foreground", foreground ? "true" : "false");
                params.put("altitude", altitude);
                params.put("speed", speed);
                params.put("course", course);
                params.put("deviceMake", deviceMake);
                params.put("deviceModel", deviceModel);
                params.put("deviceOS", deviceOS);
                params.put("country", country);
                params.put("timeZoneOffset", timeZoneOffset);
                params.put("sdkVersion", sdkVersion);
                if (description != null) {
                    params.put("description", description);
                }
                if (adId != null) {
                    params.put("adId", adId);
                }
                if (facebookPlaces != null) {
                    _RadarLogger.log(context, "sending facebookPlaces: " + facebookPlaces);
                    params.put("facebookPlaces", facebookPlaces);
                }
                VolleyLog.DEBUG = _RadarSettings.isDebug(context);
                if (_RadarClient.this.mRequestQueue == null) {
                    _RadarClient.this.mRequestQueue = Volley.newRequestQueue((Context)context);
                }
                String host = _RadarSettings.getHost(context);
                String locationURL = host + "/api/v1/users/" + userId;
                _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

                    public void onResponse(JSONObject response) {
                        if (response != null) {
                            try {
                                JSONArray eventsArr = response.getJSONArray("events");
                                JSONObject userObj = response.getJSONObject("user");
                                RadarEvent[] events = RadarEvent.eventsFromJSONArray(eventsArr);
                                RadarUser user = new RadarUser(userObj);
                                callback.onCallback(Radar.RadarStatus.SUCCESS, response, events, user);
                                _RadarClient.this.mSending = false;
                            }
                            catch (ParseException | JSONException e) {
                                _RadarLogger.log(context, "error deserializing response: " + e.getMessage());
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                                _RadarClient.this.mSending = false;
                            }
                        }
                    }
                }, new Response.ErrorListener(){

                    public void onErrorResponse(VolleyError error) {
                        if (error instanceof NetworkError || error instanceof TimeoutError) {
                            callback.onCallback(Radar.RadarStatus.ERROR_NETWORK, null, null, null);
                            _RadarClient.this.mSending = false;
                        } else if (error.networkResponse != null) {
                            if (error.networkResponse.statusCode == 400) {
                                callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
                                _RadarClient.this.mSending = false;
                            } else if (error.networkResponse.statusCode == 401) {
                                callback.onCallback(Radar.RadarStatus.ERROR_UNAUTHORIZED, null, null, null);
                                _RadarClient.this.mSending = false;
                            } else if (error.networkResponse.statusCode == 500) {
                                callback.onCallback(Radar.RadarStatus.ERROR_SERVER, null, null, null);
                                _RadarClient.this.mSending = false;
                            }
                        } else {
                            callback.onCallback(Radar.RadarStatus.ERROR_UNKNOWN, null, null, null);
                            _RadarClient.this.mSending = false;
                        }
                    }
                });
                locationRequest.setHeader("Authorization", publishableKey);
                locationRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
                _RadarClient.this.mRequestQueue.add((Request)locationRequest);
            }
        });
    }

    private void getFacebookPlacesForLocation(final Context context, Location location, final _RadarFacebookPlacesCallback callback) {
        VolleyLog.DEBUG = _RadarSettings.isDebug(context);
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)context);
        }
        String host = "https://graph.facebook.com";
        String facebookPlacesURL = host + "/v2.9/current_place/results?coordinates={\"latitude\":" + location.getLatitude() + ",\"longitude\":" + location.getLongitude() + ",\"accuracy\":" + location.getAccuracy() + "}&summary=tracking&limit=3&fields=confidence_level,category_list,website,name,single_line_address,location,checkins&access_token=1026503440803301|f9282d3366db9a2313dd82c3e06409d0";
        JsonObjectRequest facebookPlacesRequest = new JsonObjectRequest(0, facebookPlacesURL, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (response != null) {
                    String facebookPlaces = response.toString();
                    callback.onCallback(facebookPlaces);
                } else {
                    _RadarLogger.log(context, "error getting Facebook places: no response");
                    callback.onCallback(null);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                _RadarLogger.log(context, "error getting Facebook places: " + error.getMessage());
                callback.onCallback(null);
            }
        });
        facebookPlacesRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        this.mRequestQueue.add((Request)facebookPlacesRequest);
    }

    void verifyEvent(final Context context, String eventId, RadarEvent.RadarEventVerification verification) {
        String verificationParam;
        String publishableKey = _RadarSettings.getPublishableKey(context);
        if (publishableKey == null || publishableKey.length() == 0) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        switch (verification) {
            case ACCEPT: {
                verificationParam = "1";
                break;
            }
            case REJECT: {
                verificationParam = "-1";
                break;
            }
            default: {
                verificationParam = "0";
            }
        }
        params.put("verification", verificationParam);
        VolleyLog.DEBUG = _RadarSettings.isDebug(context);
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)context);
        }
        String host = _RadarSettings.getHost(context);
        String locationURL = host + "/api/v1/events/" + eventId + "/verification";
        _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                _RadarLogger.log(context, "error verifying event: " + error.getMessage());
            }
        });
        locationRequest.setHeader("Authorization", publishableKey);
        locationRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(5000, 0, 1.0f));
        this.mRequestQueue.add((Request)locationRequest);
    }

    abstract class _RadarFacebookPlacesCallback {
        _RadarFacebookPlacesCallback() {
        }

        abstract void onCallback(String var1);
    }
}

