package com.onradar.sdk.model;

import android.location.Location;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RadarUserInsightsLocation {

    private RadarUserInsightsLocationType mType;
    private Location mLocation;
    private RadarUserInsightsLocationConfidence mConfidence;
    private Date mUpdatedAt;

    public enum RadarUserInsightsLocationType {
        UNKNOWN, HOME, OFFICE
    }

    public enum RadarUserInsightsLocationConfidence {
        NONE, LOW, MEDIUM, HIGH
    }

    public RadarUserInsightsLocation(RadarUserInsightsLocationType type, Location location, RadarUserInsightsLocationConfidence confidence, Date updatedAt) {
        mType = type;
        mLocation = location;
        mConfidence = confidence;
        mUpdatedAt = updatedAt;
    }

    public RadarUserInsightsLocation(JSONObject obj) throws JSONException, ParseException {
        if (obj.has("type")) {
            String typeStr = obj.getString("type");
            if (typeStr.equals("home"))
                mType = RadarUserInsightsLocationType.HOME;
            else if (typeStr.equals("office"))
                mType = RadarUserInsightsLocationType.OFFICE;
            else
                mType = RadarUserInsightsLocationType.UNKNOWN;
        }

        if (obj.has("location")) {
            JSONObject locationObj = obj.getJSONObject("location");
            if (locationObj.has("coordinates")) {
                JSONArray coordinatesArr = locationObj.getJSONArray("coordinates");
                double longitude = coordinatesArr.getDouble(0);
                double latitude = coordinatesArr.getDouble(1);
                Location location = new Location("");
                location.setLongitude(longitude);
                location.setLatitude(latitude);
                mLocation = location;
            }
        }

        if (obj.has("confidence")) {
            int confidenceInt = obj.getInt("confidence");
            if (confidenceInt == 3)
                mConfidence = RadarUserInsightsLocationConfidence.HIGH;
            else if (confidenceInt == 2)
                mConfidence = RadarUserInsightsLocationConfidence.MEDIUM;
            else if (confidenceInt == 1)
                mConfidence = RadarUserInsightsLocationConfidence.LOW;
            else
                mConfidence = RadarUserInsightsLocationConfidence.NONE;
        }

        if (obj.has("updatedAt")) {
            String updatedAtStr = obj.getString("updatedAt");
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            mUpdatedAt = dateFormat.parse(updatedAtStr);
        }
    }

    /**
     * @return The type of the learned location.
     */
    public RadarUserInsightsLocationType getType() {
        return mType;
    }

    /**
     * @return The learned location.
     */
    public Location getLocation() {
        return mLocation;
    }

    /**
     * @return The confidence level of the learned location.
     */
    public RadarUserInsightsLocationConfidence getConfidence() {
        return mConfidence;
    }

    /**
     * @return The datetime when the learned location was updated.
     */
    public Date getUpdatedAt() {
        return mUpdatedAt;
    }

}
