/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onradar.sdk.R;
import com.onradar.sdk._CustomJsonObjectRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class _Radar
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static final String TAG = "_Radar";
    private Context mContext;
    private String mPublishableKey;
    private GoogleApiClient mGoogleApiClient;
    private boolean mRestoreGeofencesPending;
    private boolean mCheckSignificantLocationChangePending;
    private boolean mRequestLocationOncePending;
    private boolean mRequestLocationMultiplePending;
    private Date mRequestedLocationEndsAt;
    private boolean mIgnoreRateLimit;

    _Radar() {
    }

    static _Radar getSharedInstance() {
        return _RadarHolder.INSTANCE;
    }

    void init(Context context) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"init()");
        }
        if (context == null) {
            return;
        }
        this.mContext = context;
        if (this.mPublishableKey == null) {
            this.mPublishableKey = this.mContext.getResources().getString(this.mContext.getResources().getIdentifier("radar_pk", "string", this.mContext.getPackageName()));
        }
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
        }
    }

    void requestPermissions(Activity activity) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"requestPermissions()");
        }
        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            int requestCode = 0;
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }
    }

    void trackOnce(String userId, String description) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"trackOnce()");
        }
        if (this.mPublishableKey == null || userId == null || userId.length() == 0) {
            return;
        }
        this.setUserId(userId);
        this.setDescription(description);
        this.requestLocationOnce();
    }

    void startTracking(String userId, String description) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"startTracking()");
        }
        if (this.mPublishableKey == null || userId == null || userId.length() == 0) {
            return;
        }
        this.setTracking(true);
        this.setUserId(userId);
        this.setDescription(description);
        this.requestLocationOnce();
        this.scheduleAlarm();
    }

    void stopTracking() {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"stopTracking()");
        }
        this.setTracking(false);
    }

    boolean isTracking() {
        return this.getTracking();
    }

    public void onConnected(Bundle connectionHint) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnected()");
        }
        if (this.mRestoreGeofencesPending) {
            this.mRestoreGeofencesPending = false;
            this.restoreGeofences();
        }
        if (this.mCheckSignificantLocationChangePending) {
            this.mCheckSignificantLocationChangePending = false;
            this.checkSignificantLocationChange();
        }
        if (this.mRequestLocationOncePending) {
            this.mRequestLocationOncePending = false;
            this.requestLocationOnce();
        }
        if (this.mRequestLocationMultiplePending) {
            this.mRequestLocationMultiplePending = false;
            this.requestLocationMultiple();
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnectionFailed()");
        }
    }

    public void onConnectionSuspended(int cause) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onConnectionSuspended()");
        }
    }

    public void onLocationChanged(Location location) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged()");
            this.notify(0, "location changed");
        }
        if (location == null) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / location is null, returning");
            }
            return;
        }
        Date now = new Date();
        Date sentAt = this.getSentAt();
        if (!this.mIgnoreRateLimit && sentAt != null && now.getTime() - sentAt.getTime() < 30000L) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() / rate limit, returning");
            }
            return;
        }
        this.updateSentAt();
        this.mIgnoreRateLimit = false;
        String userId = this.getUserId();
        if (userId == null || userId.length() == 0) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onLocationChanged() /  userId is null, returning");
            }
            return;
        }
        String description = this.getDescription();
        String longitude = Double.toString(location.getLongitude());
        String latitude = Double.toString(location.getLatitude());
        String accuracy = Float.toString(location.getAccuracy());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceType", "Android");
        params.put("longitude", longitude);
        params.put("latitude", latitude);
        params.put("accuracy", accuracy);
        if (description != null) {
            params.put("description", description);
        }
        RequestQueue queue = Volley.newRequestQueue((Context)this.mContext);
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged() / starting location request");
        }
        String locationURL = this.isLocal() ? "http://10.0.2.2:8081/api/v1/users/" + userId + "/location" : "https://www.onradar.com/api/v1/users/" + userId + "/location";
        _CustomJsonObjectRequest locationRequest = new _CustomJsonObjectRequest(2, locationURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)"onLocationChanged() / completed location request");
                    _Radar.getSharedInstance().notify(1, "sent updated location");
                }
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)("onLocationChanged() / error completing location request: " + error));
                    _Radar.getSharedInstance().notify(1, "error sending updated location");
                }
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        });
        locationRequest.setHeader("Authorization", this.mPublishableKey);
        queue.add((Request)locationRequest);
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onLocationChanged() / starting geofences request");
        }
        final Location lastLocation = location;
        String geofencesURL = this.isLocal() ? "http://10.0.2.2:8081/api/v1/users/" + userId + "/geofences?latitude=" + latitude + "&longitude=" + longitude : "https://www.onradar.com/api/v1/users/" + userId + "/geofences?latitude=" + latitude + "&longitude=" + longitude;
        _CustomJsonObjectRequest geofencesRequest = new _CustomJsonObjectRequest(0, geofencesURL, new JSONObject(params), new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)"onLocationChanged() / completed geofences request");
                }
                try {
                    JSONArray geofences = response.getJSONArray("geofences");
                    _Radar.getSharedInstance().setGeofences(geofences, false);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                _Radar.getSharedInstance().setLastLocation(lastLocation);
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (_Radar.getSharedInstance().isDebug()) {
                    Log.v((String)_Radar.TAG, (String)("onLocationChanged() / error completing geofences request: " + error));
                }
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        });
        geofencesRequest.setHeader("Authorization", this.mPublishableKey);
        queue.add((Request)geofencesRequest);
    }

    void onHandleIntent(Intent intent) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"onHandleIntent()");
        }
        if (intent == null) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / no intent");
            }
            return;
        }
        if (!this.getTracking()) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / not tracking");
            }
            return;
        }
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / android.intent.action.BOOT_COMPLETED");
            }
            this.restoreGeofences();
            this.scheduleAlarm();
            this.requestLocationOnce();
        } else if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnected()) {
                this.checkSignificantLocationChange();
            }
        } else if (intent.getAction().equals("com.onradar.sdk.RadarReceiver.ALARM_TRIGGERED")) {
            ConnectivityManager cm;
            NetworkInfo activeNetwork;
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / com.onradar.sdk.RadarReceiver.ALARM_TRIGGERED");
            }
            if ((activeNetwork = (cm = (ConnectivityManager)this.mContext.getSystemService("connectivity")).getActiveNetworkInfo()) != null && activeNetwork.isConnected()) {
                this.checkSignificantLocationChange();
            }
        } else if (intent.getAction().equals("com.onradar.sdk.RadarReceiver.GEOFENCE_TRANSITIONED")) {
            GeofencingEvent event;
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"onHandleIntent() / com.onradar.sdk.RadarReceiver.GEOFENCE_TRANSITIONED");
            }
            if ((event = GeofencingEvent.fromIntent((Intent)intent)) == null || event.getGeofenceTransition() != 1 && event.getGeofenceTransition() != 2 && event.getGeofenceTransition() != 4) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)"onHandleIntent() / no geofencing event");
                }
                return;
            }
            if (event.hasError()) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)("onHandleIntent() / geofencing event error: " + event.getErrorCode()));
                }
                return;
            }
            if (this.isDebug()) {
                String transition;
                switch (event.getGeofenceTransition()) {
                    case 1: {
                        transition = "enter";
                        break;
                    }
                    case 2: {
                        transition = "exit";
                        break;
                    }
                    case 4: {
                        transition = "dwell";
                        break;
                    }
                    default: {
                        transition = "unknown";
                    }
                }
                List triggeringGeofences = event.getTriggeringGeofences();
                if (triggeringGeofences != null) {
                    for (Geofence geofence : triggeringGeofences) {
                        String _id = geofence.getRequestId();
                        Log.v((String)TAG, (String)("onHandleIntent() / " + transition + " transition for geofence " + _id));
                        this.notify(4, transition + " transition for geofence " + _id);
                    }
                }
            }
            if (event.getGeofenceTransition() == 1) {
                this.requestLocationMultiple();
            } else {
                Location triggeringLocation = event.getTriggeringLocation();
                if (triggeringLocation != null) {
                    this.sendLocation(triggeringLocation);
                } else {
                    this.requestLocationOnce();
                }
            }
        }
    }

    void restoreGeofences() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRestoreGeofencesPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"restoreGeofences()");
            this.notify(5, "restoring geofences");
        }
        JSONArray geofences = this.getLastGeofences();
        this.setGeofences(geofences, true);
    }

    void scheduleAlarm() {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"scheduleAlarm()");
            this.notify(6, "scheduling alarm");
        }
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent("com.onradar.sdk.RadarReceiver.ALARM_TRIGGERED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        alarmManager.setInexactRepeating(2, 900000L, 900000L, pendingIntent);
    }

    void checkSignificantLocationChange() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mCheckSignificantLocationChangePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"checkSignificantLocationChange()");
            this.notify(7, "checking significant location change");
        }
        try {
            Location currentLocation = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
            Location lastLocation = this.getLastLocation();
            if (currentLocation != null && lastLocation != null && lastLocation.distanceTo(currentLocation) >= 500.0f) {
                if (this.isDebug()) {
                    Log.v((String)TAG, (String)"checkSignificantLocationChange() / significant location change");
                    this.notify(7, "significant location change");
                }
                this.sendLocation(currentLocation);
            } else if (this.isDebug()) {
                Log.v((String)TAG, (String)"checkSignificantLocationChange() / not significant location change");
                this.notify(7, "not significant location change");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    void sendLocation(Location location) {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"sendLocation()");
            this.notify(2, "sending location");
        }
        this.onLocationChanged(location);
    }

    void requestLocationOnce() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationOncePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"requestLocationOnce()");
            this.notify(2, "requesting single location update");
        }
        this.mIgnoreRateLimit = true;
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(60000L);
        locationRequest.setFastestInterval(5000L);
        locationRequest.setPriority(100);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, (LocationListener)this, Looper.getMainLooper());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    void requestLocationMultiple() {
        if (!this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationMultiplePending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"requestLocationMultiple()");
            this.notify(2, "requesting multiple location updates");
        }
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(60000L);
        locationRequest.setFastestInterval(5000L);
        locationRequest.setPriority(102);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, (LocationListener)this, Looper.getMainLooper());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Date now = new Date();
        now.setTime(now.getTime() + 180000L);
        this.mRequestedLocationEndsAt = now;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                _Radar.getSharedInstance().tryStopUpdatingLocation();
            }
        }, 210000L);
    }

    void tryStopUpdatingLocation() {
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"tryStopUpdatingLocation()");
        }
        Date now = new Date();
        if (this.mRequestedLocationEndsAt == null || now.getTime() - this.mRequestedLocationEndsAt.getTime() > 0L) {
            if (this.isDebug()) {
                Log.v((String)TAG, (String)"tryStopUpdatingLocation() / stopping location updates");
                this.notify(3, "stopping location updates");
            }
            this.mRequestedLocationEndsAt = null;
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        }
    }

    void setGeofences(JSONArray geofences, boolean force) {
        String _id;
        JSONObject geofence3;
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        if (this.isDebug()) {
            Log.v((String)TAG, (String)"setGeofences()");
        }
        if (geofences == null) {
            return;
        }
        HashSet<String> newGeofenceIdsSet = new HashSet<String>();
        for (int i = 0; i < geofences.length(); ++i) {
            try {
                JSONObject geofence2 = geofences.getJSONObject(i);
                String _id2 = geofence2.getString("_id");
                newGeofenceIdsSet.add(_id2);
                continue;
            }
            catch (JSONException geofence2) {
                // empty catch block
            }
        }
        JSONArray oldGeofences = this.getLastGeofences();
        HashSet<String> oldGeofenceIdsSet = new HashSet<String>();
        if (!force) {
            for (int i = 0; i < oldGeofences.length(); ++i) {
                try {
                    geofence3 = oldGeofences.getJSONObject(i);
                    _id = geofence3.getString("_id");
                    oldGeofenceIdsSet.add(_id);
                    if (newGeofenceIdsSet.contains(_id)) continue;
                    try {
                        PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, Arrays.asList(_id));
                        result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                            public void onResult(Status status) {
                                if (status.isSuccess()) {
                                    if (_Radar.getSharedInstance().isDebug()) {
                                        Log.v((String)_Radar.TAG, (String)("setGeofences() / removed geofence " + _id));
                                    }
                                    return;
                                }
                                if (_Radar.getSharedInstance().isDebug()) {
                                    Log.v((String)_Radar.TAG, (String)("setGeofences() / error removing geofence " + _id + ": " + status.getStatusMessage()));
                                }
                            }
                        });
                    }
                    catch (SecurityException result) {}
                    continue;
                }
                catch (JSONException geofence3) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < geofences.length(); ++i) {
            try {
                geofence3 = geofences.getJSONObject(i);
                _id = geofence3.getString("_id");
                if (oldGeofenceIdsSet.contains(_id)) continue;
                JSONObject geometryCenter = geofence3.getJSONObject("geometryCenter");
                JSONArray geometryCenterCoordinates = geometryCenter.getJSONArray("coordinates");
                double longitude = geometryCenterCoordinates.getDouble(0);
                double latitude = geometryCenterCoordinates.getDouble(1);
                float radius = (float)geofence3.getDouble("geometryRadius");
                Geofence newGeofence = new Geofence.Builder().setRequestId(_id).setTransitionTypes(7).setLoiteringDelay(600000).setCircularRegion(latitude, longitude, radius).setExpirationDuration(-1L).build();
                GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
                GeofencingRequest request = builder.addGeofence(newGeofence).setInitialTrigger(1).build();
                Intent intent = new Intent("com.onradar.sdk.RadarReceiver.GEOFENCE_TRANSITIONED");
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
                try {
                    PendingResult result = LocationServices.GeofencingApi.addGeofences(this.mGoogleApiClient, request, pendingIntent);
                    result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                        public void onResult(Status status) {
                            if (status.isSuccess()) {
                                if (_Radar.getSharedInstance().isDebug()) {
                                    Log.v((String)_Radar.TAG, (String)("setGeofences() / added geofence " + _id));
                                }
                                return;
                            }
                            if (_Radar.getSharedInstance().isDebug()) {
                                Log.v((String)_Radar.TAG, (String)("setGeofences() / error adding geofence " + _id + ": " + status.getStatusMessage()));
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {}
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.setLastGeofences(geofences);
    }

    void setTracking(boolean tracking) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-tracking", tracking);
        editor.commit();
    }

    boolean getTracking() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-tracking", false);
    }

    void setUserId(String userId) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-userId", userId);
        editor.commit();
    }

    String getUserId() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-userId", null);
    }

    void setDescription(String userId) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-description", userId);
        editor.commit();
    }

    String getDescription() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getString("radar-description", null);
    }

    void setLastLocation(Location location) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putFloat("radar-lastLocationLongitude", (float)location.getLongitude());
        editor.putFloat("radar-lastLocationLatitude", (float)location.getLatitude());
        editor.putFloat("radar-lastLocationAccuracy", location.getAccuracy());
        editor.putString("radar-lastLocationProvider", location.getProvider());
        editor.commit();
    }

    Location getLastLocation() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        double longitude = preferences.getFloat("radar-lastLocationLongitude", 0.0f);
        double latitude = preferences.getFloat("radar-lastLocationLatitude", 0.0f);
        float accuracy = preferences.getFloat("radar-lastLocationAccuracy", 0.0f);
        String provider = preferences.getString("radar-lastLocationProvider", null);
        if (longitude == 0.0 || latitude == 0.0 || accuracy == 0.0f || provider == null) {
            return null;
        }
        Location location = new Location(provider);
        location.setLongitude(longitude);
        location.setLatitude(latitude);
        location.setAccuracy(accuracy);
        return location;
    }

    void updateSentAt() {
        if (this.mContext == null) {
            return;
        }
        Date now = new Date();
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("radar-sentAt", now.getTime());
        editor.commit();
    }

    Date getSentAt() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        long milliseconds = preferences.getLong("radar-sentAt", 0L);
        return new Date(milliseconds);
    }

    void setLastGeofences(JSONArray geofences) {
        if (this.mContext == null) {
            return;
        }
        String lastGeofencesString = geofences.toString();
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("radar-lastGeofences", lastGeofencesString);
        editor.commit();
    }

    JSONArray getLastGeofences() {
        if (this.mContext == null) {
            return null;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        String lastGeofencesString = preferences.getString("radar-lastGeofences", "[]");
        try {
            return new JSONArray(lastGeofencesString);
        }
        catch (JSONException jSONException) {
            return new JSONArray();
        }
    }

    void setDebug(boolean debug) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-debug", debug);
        editor.commit();
    }

    boolean isDebug() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-debug", false);
    }

    void setLocal(boolean local) {
        if (this.mContext == null) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("radar-local", local);
        editor.commit();
    }

    boolean isLocal() {
        if (this.mContext == null) {
            return false;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("RadarSDK", 0);
        return preferences.getBoolean("radar-local", false);
    }

    void notify(int id, String text) {
        if (this.mContext == null) {
            return;
        }
        Notification notification = new Notification.Builder(this.mContext).setContentTitle((CharSequence)"DEBUG").setContentText((CharSequence)text).setSmallIcon(R.drawable.notification).build();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        notificationManager.cancel(TAG, id);
        notificationManager.notify(TAG, id, notification);
    }

    private static class _RadarHolder {
        static final _Radar INSTANCE = new _Radar();

        private _RadarHolder() {
        }
    }
}

