package com.onradar.sdk;

import android.app.Activity;
import android.content.Context;

public class Radar {

    /**
     * Initializes the Radar SDK. You must call this method in the onCreate() method of your main activity.
     *
     * @param context Reference to context (required)
     */
    public static void init(Context context) {
        _Radar.getSharedInstance().init(context);
    }

    /**
     * Requests permission to track the user's location.
     *
     * @param activity Reference to activity (required)
     */
    public static void requestPermissions(Activity activity) {
        _Radar.getSharedInstance().requestPermissions(activity);
    }

    /**
     * Tracks the user's location once in the foreground. Before calling this method, the user must have granted location permissions.
     *
     * @param userId Unique ID for the user (required)
     * @param description Description for the user (optional)
     */
    public static void trackOnce(String userId, String description) {
        _Radar.getSharedInstance().trackOnce(userId, description);
    }

    /**
     * Starts tracking the user's location in the background. Before calling this method, the user must have granted location permissions.
     *
     * @param userId Unique ID for the user (required)
     * @param description Description for the user (optional)
     */
    public static void startTracking(String userId, String description) {
        _Radar.getSharedInstance().startTracking(userId, description);
    }

    /**
     * Stops tracking the user's location in the background.
     */
    public static void stopTracking() {
        _Radar.getSharedInstance().stopTracking();
    }

    /**
     * Returns a boolean indicating whether the user's location is being tracked in the background.
     *
     * @return A boolean indicating whether the user's location is being tracked in the background.
     */
    public static boolean isTracking() {
        return _Radar.getSharedInstance().isTracking();
    }

    private static void setDebugOn() {
        _Radar.getSharedInstance().setDebug(true);
    }

    private static void setDebugOff() {
        _Radar.getSharedInstance().setDebug(false);
    }

    private static void setLocalOn() {
        _Radar.getSharedInstance().setLocal(true);
    }

    private static void setLocalOff() {
        _Radar.getSharedInstance().setLocal(false);
    }

}
