﻿## Overview

This repository contains the list of file formats (electronic documents, forms, spreadsheets, presentations) supported by ONLYOFFICE editors and describes the properties of each file format type.

The repository is used in:
* [Document Server integration example](https://github.com/ONLYOFFICE/document-server-integration)
* [ONLYOFFICE app for Box](https://github.com/ONLYOFFICE/onlyoffice-box)
* [ONLYOFFICE app for Confluence Cloud](https://github.com/ONLYOFFICE/onlyoffice-confluence-cloud)
* [ONLYOFFICE app for Dropbox](https://github.com/ONLYOFFICE/onlyoffice-dropbox)
* [ONLYOFFICE app for Nextcloud](https://github.com/ONLYOFFICE/onlyoffice-nextcloud)
* [ONLYOFFICE app for ownCloud](https://github.com/ONLYOFFICE/onlyoffice-owncloud)
* [ONLYOFFICE bot for Telegram](https://github.com/ONLYOFFICE/onlyoffice-telegram)
* [ONLYOFFICE Docs Integration Java SDK](https://github.com/ONLYOFFICE/docs-integration-sdk-java)
* [ONLYOFFICE Docs Integration PHP SDK](https://github.com/ONLYOFFICE/docs-integration-sdk-php)
* [ONLYOFFICE extension for Directus](https://github.com/ONLYOFFICE/onlyoffice-directus)
* [ONLYOFFICE plugin for Redmine](https://github.com/ONLYOFFICE/onlyoffice-redmine)
* [ONLYOFFICE plugin for WordPress](https://github.com/ONLYOFFICE/onlyoffice-wordpress)

## Project info

ONLYOFFICE Docs (Document Server): [github.com/ONLYOFFICE/DocumentServer](https://github.com/ONLYOFFICE/DocumentServer)

Official website: [www.onlyoffice.com](https://www.onlyoffice.com/)

## Supported formats

**For viewing:**
* **WORD**: DOC, DOCM, DOCX, DOT, DOTM, DOTX, EPUB, FB2, FODT, HTM, HTML, HWP, HWPX, MD, MHT, MHTML, ODT, OTT, PAGES, RTF, STW, SXW, TXT, WPS, WPT, XML
* **CELL**: CSV, ET, ETT, FODS, NUMBERS, ODS, OTS, SXC, XLS, XLSM, XLSX, XLT, XLTM, XLTX
* **SLIDE**: DPS, DPT, FODP, KEY, ODG, ODP, OTP, POT, POTM, POTX, PPS, PPSM, PPSX, PPT, PPTM, PPTX, SXI
* **PDF**: DJVU, DOCXF, OFORM, OXPS, PDF, XPS
* **DIAGRAM**: VSDM, VSDX, VSSM, VSSX, VSTM, VSTX

**For editing:**

* **WORD**: DOCM, DOCX, DOTM, DOTX
* **CELL**: XLSB, XLSM, XLSX, XLTM, XLTX
* **SLIDE**: POTM, POTX, PPSM, PPSX, PPTM, PPTX
* **PDF**: PDF

**For editing with possible loss of information:**

* **WORD**: EPUB, FB2, HTML, ODT, OTT, RTF, TXT
* **CELL**: CSV, ODS, OTS
* **SLIDE**: ODP, OTP

**For filling:**

* **PDF**: PDF

**For converting to Office Open XML formats:**

* **WORD**: DOC, DOCM, DOCX, DOT, DOTM, DOTX, EPUB, FB2, FODT, HTM, HTML, HWP, HWPX, MD, MHT, MHT, MHTML, ODT, OTT, PAGES, RTF, STW, SXW, TXT, WPS, WPT, XML
* **CELL**: CSV, ET, ETT, FODS, NUMBERS, ODS, OTS, SXC, XLS, XLSB, XLSM, XLSX, XLT, XLTM, XLTX
* **SLIDE**: DPS, DPT, FODP, KEY, ODG, ODP, OTP, POT, POTM, POTX, PPS, PPSM, PPSX, PPT, PPTM, PPTX, SXI
* **PDF**: DOCXF, OXPS, PDF, XPS
