/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.documenteditor.config;

import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.User;
import com.onlyoffice.model.documenteditor.Config;
import com.onlyoffice.model.documenteditor.config.Document;
import com.onlyoffice.model.documenteditor.config.EditorConfig;
import com.onlyoffice.model.documenteditor.config.document.DocumentType;
import com.onlyoffice.model.documenteditor.config.document.Info;
import com.onlyoffice.model.documenteditor.config.document.Permissions;
import com.onlyoffice.model.documenteditor.config.document.ReferenceData;
import com.onlyoffice.model.documenteditor.config.document.Type;
import com.onlyoffice.model.documenteditor.config.editorconfig.CoEditing;
import com.onlyoffice.model.documenteditor.config.editorconfig.Customization;
import com.onlyoffice.model.documenteditor.config.editorconfig.Embedded;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import com.onlyoffice.model.documenteditor.config.editorconfig.Plugins;
import com.onlyoffice.model.documenteditor.config.editorconfig.Recent;
import com.onlyoffice.model.documenteditor.config.editorconfig.Template;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Goback;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Review;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.review.ReviewDisplay;
import com.onlyoffice.service.documenteditor.config.ConfigService;
import java.util.List;
import java.util.regex.Pattern;

public class DefaultConfigService
implements ConfigService {
    private DocumentManager documentManager;
    private UrlManager urlManager;
    private JwtManager jwtManager;
    private SettingsManager settingsManager;

    @Override
    public Config createConfig(String fileId, Mode mode, String userAgent) {
        return this.createConfig(fileId, mode, this.getType(userAgent));
    }

    @Override
    public Config createConfig(String fileId, Mode mode, Type type) {
        String documentName = this.documentManager.getDocumentName(fileId);
        DocumentType documentType = this.documentManager.getDocumentType(documentName);
        Document document = this.getDocument(fileId, type);
        EditorConfig editorConfig = this.getEditorConfig(fileId, mode, type);
        Config config = Config.builder().width("100%").height("100%").type(type).documentType(documentType).document(document).editorConfig(editorConfig).build();
        if (this.settingsManager.isSecurityEnabled().booleanValue()) {
            config.setToken(this.jwtManager.createToken(config));
        }
        return config;
    }

    @Override
    public Document getDocument(String fileId, Type type) {
        String documentName = this.documentManager.getDocumentName(fileId);
        Permissions permissions = this.getPermissions(fileId);
        return Document.builder().fileType(this.documentManager.getExtension(documentName)).key(this.documentManager.getDocumentKey(fileId, type.equals((Object)Type.EMBEDDED))).referenceData(this.getReferenceData(fileId)).title(documentName).url(this.urlManager.getFileUrl(fileId)).info(this.getInfo(fileId)).permissions(permissions).build();
    }

    @Override
    public EditorConfig getEditorConfig(String fileId, Mode mode, Type type) {
        Permissions permissions = this.getPermissions(fileId);
        EditorConfig editorConfig = EditorConfig.builder().coEditing(this.getCoEditing(fileId, mode, type)).createUrl(this.urlManager.getCreateUrl(fileId)).mode(mode).user(this.getUser()).recent(this.getRecent(null)).templates(this.getTemplates(fileId)).customization(this.getCustomization(fileId)).plugins(this.getPlugins(null)).build();
        if (permissions != null && permissions.getEdit().booleanValue() && mode.equals((Object)Mode.EDIT)) {
            editorConfig.setCallbackUrl(this.urlManager.getCallbackUrl(fileId));
        }
        if (type.equals((Object)Type.EMBEDDED)) {
            editorConfig.setEmbedded(this.getEmbedded(fileId));
        }
        return editorConfig;
    }

    @Override
    public ReferenceData getReferenceData(String fileId) {
        return null;
    }

    @Override
    public Info getInfo(String fileId) {
        return null;
    }

    @Override
    public Permissions getPermissions(String fileId) {
        return null;
    }

    @Override
    public CoEditing getCoEditing(String fileId, Mode mode, Type type) {
        return null;
    }

    @Override
    public List<Recent> getRecent(Object object) {
        return null;
    }

    @Override
    public List<Template> getTemplates(String fileId) {
        return null;
    }

    @Override
    public User getUser() {
        return null;
    }

    @Override
    public Customization getCustomization(String fileId) {
        Goback goback = Goback.builder().build();
        if (this.urlManager.getGobackUrl(fileId) != null) {
            goback.setUrl(this.urlManager.getGobackUrl(fileId));
        }
        Customization customization = Customization.builder().chat(this.settingsManager.getSettingBoolean("customization.chat", true)).compactHeader(this.settingsManager.getSettingBoolean("customization.compactHeader", false)).feedback(this.settingsManager.getSettingBoolean("customization.feedback", false)).forcesave(this.settingsManager.getSettingBoolean("customization.forcesave", false)).goback(goback).help(this.settingsManager.getSettingBoolean("customization.help", true)).toolbarNoTabs(this.settingsManager.getSettingBoolean("customization.toolbarNoTabs", false)).build();
        String reviewDisplay = this.settingsManager.getSetting("customization.review.reviewDisplay");
        if (reviewDisplay == null || reviewDisplay.isEmpty()) {
            reviewDisplay = ReviewDisplay.ORIGINAL.name();
        }
        if (!reviewDisplay.equals("ORIGINAL")) {
            Review review = Review.builder().reviewDisplay(ReviewDisplay.valueOf(reviewDisplay)).build();
            customization.setReview(review);
        }
        return customization;
    }

    @Override
    public Embedded getEmbedded(String fileId) {
        return null;
    }

    @Override
    public Plugins getPlugins(Object object) {
        return null;
    }

    @Override
    public Type getType(String userAgent) {
        Pattern pattern = Pattern.compile(this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getEditingService().getMobileUserAgent(), 10);
        if (userAgent != null && pattern.matcher(userAgent).find()) {
            return Type.MOBILE;
        }
        return Type.DESKTOP;
    }

    public DefaultConfigService(DocumentManager documentManager, UrlManager urlManager, JwtManager jwtManager, SettingsManager settingsManager) {
        this.documentManager = documentManager;
        this.urlManager = urlManager;
        this.jwtManager = jwtManager;
        this.settingsManager = settingsManager;
    }

    protected DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    protected void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    protected UrlManager getUrlManager() {
        return this.urlManager;
    }

    protected void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    protected JwtManager getJwtManager() {
        return this.jwtManager;
    }

    protected void setJwtManager(JwtManager jwtManager) {
        this.jwtManager = jwtManager;
    }

    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

