/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.display.impl;

import android.R;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.onesignal.common.AndroidUtils;
import com.onesignal.core.R;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.internal.channels.INotificationChannelManager;
import com.onesignal.notifications.internal.common.NotificationGenerationJob;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.display.INotificationDisplayBuilder;
import com.onesignal.notifications.internal.display.impl.IntentGeneratorForAttachingToNotifications;
import com.onesignal.notifications.receivers.NotificationDismissReceiver;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001UB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J,\u0010%\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J4\u0010&\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010-\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0014H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u00106\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0016J\u0014\u00109\u001a\u0004\u0018\u00010\u00102\b\u0010:\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\u00102\u0006\u0010<\u001a\u00020\u001aH\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\u00102\u0006\u0010>\u001a\u00020\u001aH\u0002J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u001aH\u0002J\b\u0010@\u001a\u00020\u0014H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010+\u001a\u00020\u0014H\u0016J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020CH\u0016J\u0012\u0010H\u001a\u00020\u00142\b\u0010I\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010J\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010M\u001a\u00020N2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010O\u001a\u00020\u001e2\b\u0010P\u001a\u0004\u0018\u00010*H\u0016J\u0014\u0010Q\u001a\u0004\u0018\u00010\u00102\b\u0010R\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010S\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010T\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006V"}, d2={"Lcom/onesignal/notifications/internal/display/impl/NotificationDisplayBuilder;", "Lcom/onesignal/notifications/internal/display/INotificationDisplayBuilder;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_notificationChannelManager", "Lcom/onesignal/notifications/internal/channels/INotificationChannelManager;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/channels/INotificationChannelManager;)V", "contextResources", "Landroid/content/res/Resources;", "getContextResources", "()Landroid/content/res/Resources;", "currentContext", "Landroid/content/Context;", "getCurrentContext", "()Landroid/content/Context;", "defaultLargeIcon", "Landroid/graphics/Bitmap;", "getDefaultLargeIcon", "()Landroid/graphics/Bitmap;", "defaultSmallIconId", "", "getDefaultSmallIconId", "()I", "notificationDismissedClass", "Ljava/lang/Class;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "addAlertButtons", "", "context", "fcmJson", "Lorg/json/JSONObject;", "buttonsLabels", "", "buttonsIds", "addCustomAlertButtons", "addNotificationActionButtons", "intentGenerator", "Lcom/onesignal/notifications/internal/display/impl/IntentGeneratorForAttachingToNotifications;", "mBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "notificationId", "groupSummary", "addXiaomiSettings", "oneSignalNotificationBuilder", "Lcom/onesignal/notifications/internal/display/impl/NotificationDisplayBuilder$OneSignalNotificationBuilder;", "notification", "Landroid/app/Notification;", "convertOSToAndroidPriority", "priority", "getAccentColor", "Ljava/math/BigInteger;", "getBaseOneSignalNotificationBuilder", "notificationJob", "Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;", "getBitmap", "name", "getBitmapFromAssetsOrResourceName", "bitmapStr", "getBitmapFromURL", "location", "getDrawableId", "getGroupAlertBehavior", "getLargeIcon", "getNewBaseDismissIntent", "Landroid/content/Intent;", "getNewDismissActionPendingIntent", "Landroid/app/PendingIntent;", "requestCode", "intent", "getResourceIcon", "iconName", "getSmallIconId", "getTitle", "", "isSoundEnabled", "", "removeNotifyOptions", "builder", "resizeBitmapForLargeIconArea", "bitmap", "setAlertnessOptions", "notifBuilder", "OneSignalNotificationBuilder", "com.onesignal.notifications"})
public final class NotificationDisplayBuilder
implements INotificationDisplayBuilder {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final INotificationChannelManager _notificationChannelManager;
    @NotNull
    private final Class<?> notificationDismissedClass;

    public NotificationDisplayBuilder(@NotNull IApplicationService _applicationService, @NotNull INotificationChannelManager _notificationChannelManager) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_notificationChannelManager, (String)"_notificationChannelManager");
        this._applicationService = _applicationService;
        this._notificationChannelManager = _notificationChannelManager;
        this.notificationDismissedClass = NotificationDismissReceiver.class;
    }

    private final Resources getContextResources() {
        return this._applicationService.getAppContext().getResources();
    }

    private final Context getCurrentContext() {
        return this._applicationService.getAppContext();
    }

    private final String getPackageName() {
        return this._applicationService.getAppContext().getPackageName();
    }

    @Override
    public int getGroupAlertBehavior() {
        return Build.VERSION.SDK_INT >= 24 ? 2 : 1;
    }

    @Override
    @NotNull
    public CharSequence getTitle(@NotNull JSONObject fcmJson) {
        Intrinsics.checkNotNullParameter((Object)fcmJson, (String)"fcmJson");
        CharSequence title = fcmJson.optString("title", null);
        CharSequence charSequence = title;
        if (charSequence == null) {
            Context context = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context);
            PackageManager packageManager = context.getPackageManager();
            Context context2 = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context2);
            CharSequence charSequence2 = packageManager.getApplicationLabel(context2.getApplicationInfo());
            charSequence = charSequence2;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"currentContext!!.package\u2026cationInfo,\n            )");
        }
        return charSequence;
    }

    @Override
    @NotNull
    public PendingIntent getNewDismissActionPendingIntent(int requestCode, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.getCurrentContext(), (int)requestCode, (Intent)intent, (int)0xC000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n          \u2026FLAG_IMMUTABLE,\n        )");
        return pendingIntent;
    }

    @Override
    @NotNull
    public Intent getNewBaseDismissIntent(int notificationId) {
        Intent intent = new Intent(this.getCurrentContext(), this.notificationDismissedClass).putExtra("androidNotificationId", notificationId).putExtra("dismissed", true);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(currentContext, n\u2026tExtra(\"dismissed\", true)");
        return intent;
    }

    @Override
    @NotNull
    public OneSignalNotificationBuilder getBaseOneSignalNotificationBuilder(@NotNull NotificationGenerationJob notificationJob) {
        Bitmap bigPictureIcon;
        String channelId;
        Intrinsics.checkNotNullParameter((Object)notificationJob, (String)"notificationJob");
        JSONObject jSONObject = notificationJob.getJsonPayload();
        Intrinsics.checkNotNull((Object)jSONObject);
        JSONObject fcmJson = jSONObject;
        OneSignalNotificationBuilder oneSignalNotificationBuilder = new OneSignalNotificationBuilder();
        String notificationBuilder = null;
        try {
            channelId = this._notificationChannelManager.createNotificationChannel(notificationJob);
            Context context = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context);
            channelId = new NotificationCompat.Builder(context, channelId);
        }
        catch (Throwable t) {
            Context context = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context);
            channelId = new NotificationCompat.Builder(context);
        }
        notificationBuilder = channelId;
        String message = fcmJson.optString("alert", null);
        notificationBuilder.setAutoCancel(true).setSmallIcon(this.getSmallIconId(fcmJson)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message)).setContentText((CharSequence)message).setTicker((CharSequence)message);
        if (Build.VERSION.SDK_INT < 24 || !Intrinsics.areEqual((Object)fcmJson.optString("title"), (Object)"")) {
            notificationBuilder.setContentTitle(this.getTitle(fcmJson));
        }
        try {
            BigInteger accentColor = this.getAccentColor(fcmJson);
            if (accentColor != null) {
                notificationBuilder.setColor(accentColor.intValue());
            }
        }
        catch (Throwable accentColor) {
            // empty catch block
        }
        try {
            int lockScreenVisibility = 1;
            if (fcmJson.has("vis")) {
                String string = fcmJson.optString("vis");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fcmJson.optString(\"vis\")");
                lockScreenVisibility = Integer.parseInt(string);
            }
            notificationBuilder.setVisibility(lockScreenVisibility);
        }
        catch (Throwable lockScreenVisibility) {
            // empty catch block
        }
        Bitmap largeIcon = this.getLargeIcon(fcmJson);
        if (largeIcon != null) {
            oneSignalNotificationBuilder.setHasLargeIcon(true);
            notificationBuilder.setLargeIcon(largeIcon);
        }
        if ((bigPictureIcon = this.getBitmap(fcmJson.optString("bicon", null))) != null) {
            notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureIcon).setSummaryText((CharSequence)message));
        }
        if (notificationJob.getShownTimeStamp() != null) {
            try {
                Long l = notificationJob.getShownTimeStamp();
                Intrinsics.checkNotNull((Object)l);
                notificationBuilder.setWhen(l * 1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setAlertnessOptions(fcmJson, (NotificationCompat.Builder)notificationBuilder);
        oneSignalNotificationBuilder.setCompatBuilder((NotificationCompat.Builder)notificationBuilder);
        return oneSignalNotificationBuilder;
    }

    private final void setAlertnessOptions(JSONObject fcmJson, NotificationCompat.Builder notifBuilder) {
        boolean lowDisplayPriority;
        int payloadPriority = fcmJson.optInt("pri", 6);
        int androidPriority = this.convertOSToAndroidPriority(payloadPriority);
        notifBuilder.setPriority(androidPriority);
        boolean bl = lowDisplayPriority = androidPriority < 0;
        if (lowDisplayPriority) {
            return;
        }
        int notificationDefaults = 0;
        if (fcmJson.has("ledc") && fcmJson.optInt("led", 1) == 1) {
            try {
                BigInteger ledColor = new BigInteger(fcmJson.optString("ledc"), 16);
                notifBuilder.setLights(ledColor.intValue(), 2000, 5000);
            }
            catch (Throwable t) {
                notificationDefaults |= 4;
            }
        } else {
            notificationDefaults |= 4;
        }
        if (fcmJson.optInt("vib", 1) == 1) {
            if (fcmJson.has("vib_pt")) {
                long[] vibrationPattern = NotificationHelper.INSTANCE.parseVibrationPattern(fcmJson);
                if (vibrationPattern != null) {
                    notifBuilder.setVibrate(vibrationPattern);
                }
            } else {
                notificationDefaults |= 2;
            }
        }
        if (this.isSoundEnabled(fcmJson)) {
            Context context = this.getCurrentContext();
            Intrinsics.checkNotNull((Object)context);
            Uri soundUri = NotificationHelper.INSTANCE.getSoundUri(context, fcmJson.optString("sound", null));
            if (soundUri != null) {
                notifBuilder.setSound(soundUri);
            } else {
                notificationDefaults |= 1;
            }
        }
        notifBuilder.setDefaults(notificationDefaults);
    }

    @Override
    public void removeNotifyOptions(@Nullable NotificationCompat.Builder builder) {
        NotificationCompat.Builder builder2 = builder;
        Intrinsics.checkNotNull((Object)builder2);
        builder2.setOnlyAlertOnce(true).setDefaults(0).setSound(null).setVibrate(null).setTicker(null);
    }

    @Override
    public void addXiaomiSettings(@Nullable OneSignalNotificationBuilder oneSignalNotificationBuilder, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        OneSignalNotificationBuilder oneSignalNotificationBuilder2 = oneSignalNotificationBuilder;
        Intrinsics.checkNotNull((Object)oneSignalNotificationBuilder2);
        if (!oneSignalNotificationBuilder2.getHasLargeIcon()) {
            return;
        }
        try {
            Object miuiNotification = Class.forName("android.app.MiuiNotification").newInstance();
            Field customizedIconField = miuiNotification.getClass().getDeclaredField("customizedIcon");
            customizedIconField.setAccessible(true);
            customizedIconField.set(miuiNotification, true);
            Field extraNotificationField = notification.getClass().getField("extraNotification");
            extraNotificationField.setAccessible(true);
            extraNotificationField.set(notification, miuiNotification);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final Bitmap getLargeIcon(JSONObject fcmJson) {
        Bitmap bitmap = this.getBitmap(fcmJson.optString("licon"));
        if (bitmap == null) {
            bitmap = this.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        }
        return bitmap == null ? (Bitmap)null : this.resizeBitmapForLargeIconArea(bitmap);
    }

    @Override
    @Nullable
    public Bitmap getDefaultLargeIcon() {
        Bitmap bitmap = this.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        return this.resizeBitmapForLargeIconArea(bitmap);
    }

    private final Bitmap resizeBitmapForLargeIconArea(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        try {
            Resources resources = this.getContextResources();
            Intrinsics.checkNotNull((Object)resources);
            int systemLargeIconHeight = (int)resources.getDimension(R.dimen.notification_large_icon_height);
            Resources resources2 = this.getContextResources();
            Intrinsics.checkNotNull((Object)resources2);
            int systemLargeIconWidth = (int)resources2.getDimension(R.dimen.notification_large_icon_width);
            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();
            if (bitmapWidth > systemLargeIconWidth || bitmapHeight > systemLargeIconHeight) {
                int newWidth = systemLargeIconWidth;
                int newHeight = systemLargeIconHeight;
                if (bitmapHeight > bitmapWidth) {
                    float ratio = (float)bitmapWidth / (float)bitmapHeight;
                    newWidth = (int)((float)newHeight * ratio);
                } else if (bitmapWidth > bitmapHeight) {
                    float ratio = (float)bitmapHeight / (float)bitmapWidth;
                    newHeight = (int)((float)newWidth * ratio);
                }
                return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bitmap;
    }

    private final Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                Context context = this.getCurrentContext();
                Intrinsics.checkNotNull((Object)context);
                bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(bitmapStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Bitmap bitmap2 = bitmap;
            if (bitmap2 != null) {
                return bitmap2;
            }
            String[] stringArray = new String[]{".png", ".webp", ".jpg", ".gif", ".bmp"};
            List<String> imageExtensions = Arrays.asList(stringArray);
            for (String extension : imageExtensions) {
                try {
                    Context context = this.getCurrentContext();
                    Intrinsics.checkNotNull((Object)context);
                    bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Bitmap bitmap3 = bitmap;
                if (bitmap3 == null) continue;
                return bitmap3;
            }
            int bitmapId = this.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)this.getContextResources(), (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private final Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable t) {
            Logging.warn((String)"Could not download image!", (Throwable)t);
            return null;
        }
    }

    private final Bitmap getBitmap(String name) {
        String trimmedName;
        if (name == null) {
            return null;
        }
        String $this$trim$iv = name;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringsKt.startsWith$default((String)(trimmedName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)trimmedName, (String)"https://", (boolean)false, (int)2, null) ? this.getBitmapFromURL(trimmedName) : this.getBitmapFromAssetsOrResourceName(name);
    }

    private final int getResourceIcon(String iconName) {
        String trimmedIconName;
        if (iconName == null) {
            return 0;
        }
        String $this$trim$iv = iconName;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!AndroidUtils.INSTANCE.isValidResourceName(trimmedIconName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) {
            return 0;
        }
        int notificationIcon = this.getDrawableId(trimmedIconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private final int getSmallIconId(JSONObject fcmJson) {
        int notificationIcon = this.getResourceIcon(fcmJson.optString("sicon", null));
        return notificationIcon != 0 ? notificationIcon : this.getDefaultSmallIconId();
    }

    @Override
    public int getDefaultSmallIconId() {
        int notificationIcon = this.getDrawableId("ic_stat_onesignal_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = this.getDrawableId("corona_statusbar_icon_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = this.getDrawableId("ic_os_notification_fallback_white_24dp");
        return notificationIcon != 0 ? notificationIcon : 17301598;
    }

    private final int getDrawableId(String name) {
        Resources resources = this.getContextResources();
        Intrinsics.checkNotNull((Object)resources);
        return resources.getIdentifier(name, "drawable", this.getPackageName());
    }

    private final boolean isSoundEnabled(JSONObject fcmJson) {
        String sound = fcmJson.optString("sound", null);
        return !Intrinsics.areEqual((Object)"null", (Object)sound) && !Intrinsics.areEqual((Object)"nil", (Object)sound);
    }

    private final BigInteger getAccentColor(JSONObject fcmJson) {
        String defaultColor2;
        try {
            if (fcmJson.has("bgac")) {
                return new BigInteger(fcmJson.optString("bgac", null), 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            defaultColor2 = AndroidUtils.INSTANCE.getResourceString(this._applicationService.getAppContext(), "onesignal_notification_accent_color", null);
            if (defaultColor2 != null) {
                return new BigInteger(defaultColor2, 16);
            }
        }
        catch (Throwable defaultColor2) {
            // empty catch block
        }
        try {
            defaultColor2 = AndroidUtils.INSTANCE.getManifestMeta(this._applicationService.getAppContext(), "com.onesignal.NotificationAccentColor.DEFAULT");
            if (defaultColor2 != null) {
                return new BigInteger(defaultColor2, 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void addNotificationActionButtons(@NotNull JSONObject fcmJson, @NotNull IntentGeneratorForAttachingToNotifications intentGenerator, @Nullable NotificationCompat.Builder mBuilder, int notificationId, @Nullable String groupSummary) {
        Intrinsics.checkNotNullParameter((Object)fcmJson, (String)"fcmJson");
        Intrinsics.checkNotNullParameter((Object)intentGenerator, (String)"intentGenerator");
        try {
            JSONObject customJson = new JSONObject(fcmJson.optString("custom"));
            if (!customJson.has("a")) {
                return;
            }
            JSONObject additionalDataJSON = customJson.getJSONObject("a");
            if (!additionalDataJSON.has("actionButtons")) {
                return;
            }
            JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
            int n = buttons.length();
            for (int i = 0; i < n; ++i) {
                JSONObject button = buttons.optJSONObject(i);
                JSONObject bundle = new JSONObject(fcmJson.toString());
                Intent buttonIntent = intentGenerator.getNewBaseIntent(notificationId);
                buttonIntent.setAction("" + i);
                buttonIntent.putExtra("action_button", true);
                bundle.put("actionId", (Object)button.optString("id"));
                buttonIntent.putExtra("onesignalData", bundle.toString());
                if (groupSummary != null) {
                    buttonIntent.putExtra("summary", groupSummary);
                } else if (fcmJson.has("grp")) {
                    buttonIntent.putExtra("grp", fcmJson.optString("grp"));
                }
                PendingIntent buttonPIntent = intentGenerator.getNewActionPendingIntent(notificationId, buttonIntent);
                int buttonIcon = 0;
                if (button.has("icon")) {
                    buttonIcon = this.getResourceIcon(button.optString("icon"));
                }
                NotificationCompat.Builder builder = mBuilder;
                Intrinsics.checkNotNull((Object)builder);
                builder.addAction(buttonIcon, (CharSequence)button.optString("text"), buttonPIntent);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void addAlertButtons(Context context, JSONObject fcmJson, List<String> buttonsLabels, List<String> buttonsIds) {
        try {
            this.addCustomAlertButtons(fcmJson, buttonsLabels, buttonsIds);
        }
        catch (Throwable t) {
            Logging.error((String)"Failed to parse JSON for custom buttons for alert dialog.", (Throwable)t);
        }
        if (buttonsLabels.size() == 0 || buttonsLabels.size() < 3) {
            String string = AndroidUtils.INSTANCE.getResourceString(context, "onesignal_in_app_alert_ok_button_text", "Ok");
            Intrinsics.checkNotNull((Object)string);
            buttonsLabels.add(string);
            buttonsIds.add("__DEFAULT__");
        }
    }

    private final void addCustomAlertButtons(JSONObject fcmJson, List<String> buttonsLabels, List<String> buttonsIds) throws JSONException {
        JSONObject customJson = new JSONObject(fcmJson.optString("custom"));
        if (!customJson.has("a")) {
            return;
        }
        JSONObject additionalDataJSON = customJson.getJSONObject("a");
        if (!additionalDataJSON.has("actionButtons")) {
            return;
        }
        JSONArray buttons = additionalDataJSON.optJSONArray("actionButtons");
        int n = buttons.length();
        for (int i = 0; i < n; ++i) {
            JSONObject button = buttons.getJSONObject(i);
            String string = button.optString("text");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"button.optString(\"text\")");
            buttonsLabels.add(string);
            String string2 = button.optString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"button.optString(\"id\")");
            buttonsIds.add(string2);
        }
    }

    private final int convertOSToAndroidPriority(int priority) {
        if (priority > 9) {
            return 2;
        }
        if (priority > 7) {
            return 1;
        }
        if (priority > 4) {
            return 0;
        }
        return priority > 2 ? -1 : -2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/onesignal/notifications/internal/display/impl/NotificationDisplayBuilder$OneSignalNotificationBuilder;", "", "()V", "compatBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "getCompatBuilder", "()Landroidx/core/app/NotificationCompat$Builder;", "setCompatBuilder", "(Landroidx/core/app/NotificationCompat$Builder;)V", "hasLargeIcon", "", "getHasLargeIcon", "()Z", "setHasLargeIcon", "(Z)V", "com.onesignal.notifications"})
    public static final class OneSignalNotificationBuilder {
        @Nullable
        private NotificationCompat.Builder compatBuilder;
        private boolean hasLargeIcon;

        @Nullable
        public final NotificationCompat.Builder getCompatBuilder() {
            return this.compatBuilder;
        }

        public final void setCompatBuilder(@Nullable NotificationCompat.Builder builder) {
            this.compatBuilder = builder;
        }

        public final boolean getHasLargeIcon() {
            return this.hasLargeIcon;
        }

        public final void setHasLargeIcon(boolean bl) {
            this.hasLargeIcon = bl;
        }
    }
}

