/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.badges.impl;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import androidx.annotation.RequiresApi;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.database.ICursor;
import com.onesignal.core.internal.database.IDatabase;
import com.onesignal.core.internal.database.IDatabaseProvider;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.internal.badges.IBadgeCountUpdater;
import com.onesignal.notifications.internal.badges.impl.shortcutbadger.ShortcutBadgeException;
import com.onesignal.notifications.internal.badges.impl.shortcutbadger.ShortcutBadger;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.data.INotificationQueryHelper;
import com.onesignal.notifications.internal.limiting.INotificationLimitManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/notifications/internal/badges/impl/BadgeCountUpdater;", "Lcom/onesignal/notifications/internal/badges/IBadgeCountUpdater;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_queryHelper", "Lcom/onesignal/notifications/internal/data/INotificationQueryHelper;", "_databaseProvider", "Lcom/onesignal/core/internal/database/IDatabaseProvider;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/data/INotificationQueryHelper;Lcom/onesignal/core/internal/database/IDatabaseProvider;)V", "badgesEnabled", "", "areBadgeSettingsEnabled", "", "areBadgesEnabled", "update", "", "updateCount", "count", "updateFallback", "updateStandard", "com.onesignal.notifications"})
public final class BadgeCountUpdater
implements IBadgeCountUpdater {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final INotificationQueryHelper _queryHelper;
    @NotNull
    private final IDatabaseProvider _databaseProvider;
    private int badgesEnabled;

    public BadgeCountUpdater(@NotNull IApplicationService _applicationService, @NotNull INotificationQueryHelper _queryHelper, @NotNull IDatabaseProvider _databaseProvider) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_queryHelper, (String)"_queryHelper");
        Intrinsics.checkNotNullParameter((Object)_databaseProvider, (String)"_databaseProvider");
        this._applicationService = _applicationService;
        this._queryHelper = _queryHelper;
        this._databaseProvider = _databaseProvider;
        this.badgesEnabled = -1;
    }

    private final boolean areBadgeSettingsEnabled() {
        if (this.badgesEnabled != -1) {
            return this.badgesEnabled == 1;
        }
        try {
            String defaultStr;
            ApplicationInfo applicationInfo = this._applicationService.getAppContext().getPackageManager().getApplicationInfo(this._applicationService.getAppContext().getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"_applicationService.appC\u2026_META_DATA,\n            )");
            ApplicationInfo ai = applicationInfo;
            Bundle bundle = ai.metaData;
            this.badgesEnabled = bundle != null ? (Intrinsics.areEqual((Object)"DISABLE", (Object)(defaultStr = bundle.getString("com.onesignal.BadgeCount"))) ? 0 : 1) : 1;
        }
        catch (PackageManager.NameNotFoundException e) {
            this.badgesEnabled = 0;
            Logging.error((String)"Error reading meta-data tag 'com.onesignal.BadgeCount'. Disabling badge setting.", (Throwable)e);
        }
        return this.badgesEnabled == 1;
    }

    private final boolean areBadgesEnabled() {
        return this.areBadgeSettingsEnabled() && NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._applicationService.getAppContext(), null, 2, null);
    }

    @Override
    public void update() {
        if (!this.areBadgesEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.updateStandard();
        } else {
            this.updateFallback();
        }
    }

    @RequiresApi(api=23)
    private final void updateStandard() {
        StatusBarNotification[] activeNotifs = NotificationHelper.INSTANCE.getActiveNotifications(this._applicationService.getAppContext());
        int runningCount = 0;
        for (StatusBarNotification activeNotif : activeNotifs) {
            if (NotificationHelper.INSTANCE.isGroupSummary(activeNotif)) continue;
            ++runningCount;
        }
        this.updateCount(runningCount);
    }

    private final void updateFallback() {
        Ref.IntRef notificationCount = new Ref.IntRef();
        IDatabase.DefaultImpls.query$default((IDatabase)this._databaseProvider.getOs(), (String)"notification", null, (String)this._queryHelper.recentUninteractedWithNotificationsWhere().toString(), null, null, null, null, (String)String.valueOf(INotificationLimitManager.Constants.INSTANCE.getMaxNumberOfNotifications()), (Function1)((Function1)new Function1<ICursor, Unit>(notificationCount){
            final /* synthetic */ Ref.IntRef $notificationCount;
            {
                this.$notificationCount = $notificationCount;
                super(1);
            }

            public final void invoke(@NotNull ICursor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$notificationCount.element = it.getCount();
            }
        }), (int)122, null);
        this.updateCount(notificationCount.element);
    }

    @Override
    public void updateCount(int count) {
        if (!this.areBadgeSettingsEnabled()) {
            return;
        }
        try {
            ShortcutBadger.applyCountOrThrow(this._applicationService.getAppContext(), count);
        }
        catch (ShortcutBadgeException shortcutBadgeException) {
            // empty catch block
        }
    }
}

