/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.data;

import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OSTime;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.influence.OSInfluenceConstants;
import com.onesignal.influence.data.OSChannelTracker;
import com.onesignal.influence.data.OSInAppMessageTracker;
import com.onesignal.influence.data.OSInfluenceDataRepository;
import com.onesignal.influence.data.OSNotificationTracker;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nJ\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\"\u001a\u00020#J\u0006\u0010%\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/onesignal/influence/data/OSTrackerFactory;", "", "preferences", "Lcom/onesignal/OSSharedPreferences;", "logger", "Lcom/onesignal/OSLogger;", "timeProvider", "Lcom/onesignal/OSTime;", "(Lcom/onesignal/OSSharedPreferences;Lcom/onesignal/OSLogger;Lcom/onesignal/OSTime;)V", "channels", "", "Lcom/onesignal/influence/data/OSChannelTracker;", "getChannels", "()Ljava/util/List;", "dataRepository", "Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "iAMChannelTracker", "getIAMChannelTracker", "()Lcom/onesignal/influence/data/OSChannelTracker;", "influences", "Lcom/onesignal/influence/domain/OSInfluence;", "getInfluences", "notificationChannelTracker", "getNotificationChannelTracker", "sessionInfluences", "getSessionInfluences", "trackers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addSessionData", "", "jsonObject", "Lorg/json/JSONObject;", "getChannelByEntryAction", "entryAction", "Lcom/onesignal/OneSignal$AppEntryAction;", "getChannelsToResetByEntryAction", "initFromCache", "saveInfluenceParams", "influenceParams", "Lcom/onesignal/OneSignalRemoteParams$InfluenceParams;", "onesignal_release"})
public final class OSTrackerFactory {
    @NotNull
    private final ConcurrentHashMap<String, OSChannelTracker> trackers;
    @NotNull
    private final OSInfluenceDataRepository dataRepository;

    public OSTrackerFactory(@NotNull OSSharedPreferences preferences, @NotNull OSLogger logger, @NotNull OSTime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.trackers = new ConcurrentHashMap();
        this.dataRepository = new OSInfluenceDataRepository(preferences);
        Map map = this.trackers;
        String string2 = OSInfluenceConstants.INSTANCE.getIAM_TAG();
        OSChannelTracker oSChannelTracker = new OSInAppMessageTracker(this.dataRepository, logger, timeProvider);
        boolean bl = false;
        map.put(string2, oSChannelTracker);
        map = this.trackers;
        string2 = OSInfluenceConstants.INSTANCE.getNOTIFICATION_TAG();
        oSChannelTracker = new OSNotificationTracker(this.dataRepository, logger, timeProvider);
        bl = false;
        map.put(string2, oSChannelTracker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OSInfluence> getInfluences() {
        void $this$mapTo$iv$iv;
        Collection<OSChannelTracker> collection = this.trackers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OSChannelTracker oSChannelTracker = (OSChannelTracker)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            OSInfluence oSInfluence = it.getCurrentSessionInfluence();
            collection2.add(oSInfluence);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OSInfluence> getSessionInfluences() {
        void $this$mapTo$iv$iv;
        OSChannelTracker it;
        Iterable $this$filterTo$iv$iv;
        Collection<OSChannelTracker> collection = this.trackers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OSChannelTracker)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getIdTag(), (Object)OSInfluenceConstants.INSTANCE.getIAM_TAG()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (OSChannelTracker)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            OSInfluence oSInfluence = it.getCurrentSessionInfluence();
            collection2.add(oSInfluence);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final OSChannelTracker getIAMChannelTracker() {
        OSChannelTracker oSChannelTracker = this.trackers.get(OSInfluenceConstants.INSTANCE.getIAM_TAG());
        Intrinsics.checkNotNull((Object)oSChannelTracker);
        OSChannelTracker oSChannelTracker2 = oSChannelTracker;
        Intrinsics.checkNotNullExpressionValue((Object)oSChannelTracker2, (String)"trackers[OSInfluenceConstants.IAM_TAG]!!");
        return oSChannelTracker2;
    }

    @NotNull
    public final OSChannelTracker getNotificationChannelTracker() {
        OSChannelTracker oSChannelTracker = this.trackers.get(OSInfluenceConstants.INSTANCE.getNOTIFICATION_TAG());
        Intrinsics.checkNotNull((Object)oSChannelTracker);
        OSChannelTracker oSChannelTracker2 = oSChannelTracker;
        Intrinsics.checkNotNullExpressionValue((Object)oSChannelTracker2, (String)"trackers[OSInfluenceConstants.NOTIFICATION_TAG]!!");
        return oSChannelTracker2;
    }

    @NotNull
    public final List<OSChannelTracker> getChannels() {
        boolean bl = false;
        List channels = new ArrayList();
        OSChannelTracker oSChannelTracker = this.getNotificationChannelTracker();
        boolean bl2 = false;
        boolean bl3 = false;
        OSChannelTracker it = oSChannelTracker;
        boolean bl4 = false;
        channels.add(it);
        oSChannelTracker = this.getIAMChannelTracker();
        bl2 = false;
        bl3 = false;
        it = oSChannelTracker;
        boolean bl5 = false;
        channels.add(it);
        return channels;
    }

    public final void initFromCache() {
        Collection<OSChannelTracker> collection = this.trackers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OSChannelTracker it = (OSChannelTracker)element$iv;
            boolean bl = false;
            it.initInfluencedTypeFromCache();
        }
    }

    public final void saveInfluenceParams(@NotNull OneSignalRemoteParams.InfluenceParams influenceParams) {
        Intrinsics.checkNotNullParameter((Object)influenceParams, (String)"influenceParams");
        this.dataRepository.saveInfluenceParams(influenceParams);
    }

    public final void addSessionData(@NotNull JSONObject jsonObject, @NotNull List<OSInfluence> influences) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter(influences, (String)"influences");
        Iterable $this$forEach$iv = influences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OSInfluence it = (OSInfluence)element$iv;
            boolean bl = false;
            OSInfluenceChannel oSInfluenceChannel = it.getInfluenceChannel();
            int n = WhenMappings.$EnumSwitchMapping$0[oSInfluenceChannel.ordinal()];
            switch (n) {
                case 1: {
                    this.getNotificationChannelTracker().addSessionData(jsonObject, it);
                }
            }
        }
    }

    @Nullable
    public final OSChannelTracker getChannelByEntryAction(@NotNull OneSignal.AppEntryAction entryAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)entryAction), (String)"entryAction");
        return entryAction.isNotificationClick() ? this.getNotificationChannelTracker() : null;
    }

    @NotNull
    public final List<OSChannelTracker> getChannelsToResetByEntryAction(@NotNull OneSignal.AppEntryAction entryAction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)entryAction), (String)"entryAction");
        List channels = new ArrayList();
        if (entryAction.isAppClose()) {
            return channels;
        }
        OSChannelTracker notificationChannel = entryAction.isAppOpen() ? this.getNotificationChannelTracker() : null;
        OSChannelTracker oSChannelTracker = notificationChannel;
        if (oSChannelTracker != null) {
            OSChannelTracker oSChannelTracker2 = oSChannelTracker;
            bl = false;
            boolean bl2 = false;
            OSChannelTracker it = oSChannelTracker2;
            boolean bl3 = false;
            channels.add(it);
        }
        oSChannelTracker = this.getIAMChannelTracker();
        boolean bl4 = false;
        bl = false;
        OSChannelTracker it = oSChannelTracker;
        boolean bl5 = false;
        channels.add(it);
        return channels;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OSInfluenceChannel.values().length];
            nArray[OSInfluenceChannel.NOTIFICATION.ordinal()] = 1;
            nArray[OSInfluenceChannel.IAM.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

