/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import org.json.JSONException;
import org.json.JSONObject;

class OSReceiveReceiptRepository {
    private static final String APP_ID = "app_id";
    private static final String PLAYER_ID = "player_id";
    private static final String DEVICE_TYPE = "device_type";

    OSReceiveReceiptRepository() {
    }

    void sendReceiveReceipt(@NonNull String appId, @NonNull String playerId, @Nullable Integer deviceType, @NonNull String notificationId, @NonNull OneSignalRestClient.ResponseHandler responseHandler) {
        try {
            JSONObject jsonBody = new JSONObject().put(APP_ID, (Object)appId).put(PLAYER_ID, (Object)playerId);
            if (deviceType != null) {
                jsonBody.put(DEVICE_TYPE, (Object)deviceType);
            }
            OneSignalRestClient.put("notifications/" + notificationId + "/report_received", jsonBody, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating direct receive receipt:JSON Failed.", e);
        }
    }
}

