/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes.data;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalDb;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import com.onesignal.outcomes.domain.OSCachedUniqueOutcome;
import com.onesignal.outcomes.domain.OSOutcomeEventParams;
import com.onesignal.outcomes.domain.OSOutcomeSource;
import com.onesignal.outcomes.domain.OSOutcomeSourceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0007J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0007J4\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010&H\u0002J$\u0010-\u001a\b\u0012\u0004\u0012\u00020.0$2\u0006\u0010/\u001a\u00020\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0$H\u0007J*\u00101\u001a\u0004\u0018\u00010&2\u0006\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u000eH\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007J\u0018\u00106\u001a\u00020\u00122\u0010\u00107\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rJ\u0010\u00108\u001a\u00020\u00122\u0006\u00105\u001a\u00020\"H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00069"}, d2={"Lcom/onesignal/outcomes/data/OSOutcomeEventsCache;", "", "logger", "Lcom/onesignal/OSLogger;", "dbHelper", "Lcom/onesignal/OneSignalDb;", "preferences", "Lcom/onesignal/OSSharedPreferences;", "(Lcom/onesignal/OSLogger;Lcom/onesignal/OneSignalDb;Lcom/onesignal/OSSharedPreferences;)V", "isOutcomesV2ServiceEnabled", "", "()Z", "unattributedUniqueOutcomeEventsSentByChannel", "", "", "getUnattributedUniqueOutcomeEventsSentByChannel", "()Ljava/util/Set;", "addIdToListFromChannel", "", "cachedUniqueOutcomes", "", "Lcom/onesignal/outcomes/domain/OSCachedUniqueOutcome;", "channelIds", "Lorg/json/JSONArray;", "channel", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "addIdsToListFromSource", "sourceBody", "Lcom/onesignal/outcomes/domain/OSOutcomeSourceBody;", "cleanCachedUniqueOutcomeEventNotifications", "notificationTableName", "notificationIdColumnName", "deleteOldOutcomeEvent", "event", "Lcom/onesignal/outcomes/domain/OSOutcomeEventParams;", "getAllEventsToSend", "", "getIAMInfluenceSource", "Lcom/onesignal/outcomes/domain/OSOutcomeSource;", "iamInfluenceType", "Lcom/onesignal/influence/domain/OSInfluenceType;", "directSourceBody", "indirectSourceBody", "iamIds", "source", "getNotCachedUniqueInfluencesForOutcome", "Lcom/onesignal/influence/domain/OSInfluence;", "name", "influences", "getNotificationInfluenceSource", "notificationInfluenceType", "notificationIds", "saveOutcomeEvent", "eventParams", "saveUnattributedUniqueOutcomeEventsSentByChannel", "unattributedUniqueOutcomeEvents", "saveUniqueOutcomeEventParams", "onesignal_release"})
public final class OSOutcomeEventsCache {
    @NotNull
    private final OSLogger logger;
    @NotNull
    private final OneSignalDb dbHelper;
    @NotNull
    private final OSSharedPreferences preferences;

    public OSOutcomeEventsCache(@NotNull OSLogger logger, @NotNull OneSignalDb dbHelper, @NotNull OSSharedPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbHelper, (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.logger = logger;
        this.dbHelper = dbHelper;
        this.preferences = preferences;
    }

    public final boolean isOutcomesV2ServiceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), this.preferences.getOutcomesV2KeyName(), false);
    }

    @Nullable
    public final Set<String> getUnattributedUniqueOutcomeEventsSentByChannel() {
        return this.preferences.getStringSet(this.preferences.getPreferencesName(), "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", null);
    }

    public final void saveUnattributedUniqueOutcomeEventsSentByChannel(@Nullable Set<String> unattributedUniqueOutcomeEvents) {
        String string2 = this.preferences.getPreferencesName();
        Set<String> set = unattributedUniqueOutcomeEvents;
        Intrinsics.checkNotNull(set);
        this.preferences.saveStringSet(string2, "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", set);
    }

    @WorkerThread
    public final synchronized void deleteOldOutcomeEvent(@NotNull OSOutcomeEventParams event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray = new String[]{String.valueOf(event.getTimestamp())};
        this.dbHelper.delete("outcome", "timestamp = ?", stringArray);
    }

    @WorkerThread
    public final synchronized void saveOutcomeEvent(@NotNull OSOutcomeEventParams eventParams) {
        JSONArray it;
        boolean bl;
        boolean bl2;
        JSONArray jSONArray;
        JSONArray jSONArray2;
        boolean bl3;
        boolean bl4;
        OSOutcomeSourceBody oSOutcomeSourceBody;
        OSOutcomeSourceBody oSOutcomeSourceBody2;
        Intrinsics.checkNotNullParameter((Object)eventParams, (String)"eventParams");
        JSONArray notificationIds = null;
        notificationIds = new JSONArray();
        JSONArray iamIds = null;
        iamIds = new JSONArray();
        OSInfluenceType notificationInfluenceType = null;
        notificationInfluenceType = OSInfluenceType.UNATTRIBUTED;
        OSInfluenceType iamInfluenceType = null;
        iamInfluenceType = OSInfluenceType.UNATTRIBUTED;
        OSOutcomeSource oSOutcomeSource = eventParams.getOutcomeSource();
        if (oSOutcomeSource != null && (oSOutcomeSourceBody2 = oSOutcomeSource.getDirectBody()) != null) {
            oSOutcomeSourceBody = oSOutcomeSourceBody2;
            bl4 = false;
            bl3 = false;
            OSOutcomeSourceBody directBody = oSOutcomeSourceBody;
            boolean bl5 = false;
            jSONArray2 = directBody.getNotificationIds();
            if (jSONArray2 != null) {
                jSONArray = jSONArray2;
                bl2 = false;
                bl = false;
                it = jSONArray;
                boolean bl6 = false;
                if (it.length() > 0) {
                    notificationInfluenceType = OSInfluenceType.DIRECT;
                    notificationIds = it;
                }
            }
            jSONArray2 = directBody.getInAppMessagesIds();
            if (jSONArray2 != null) {
                jSONArray = jSONArray2;
                bl2 = false;
                bl = false;
                it = jSONArray;
                boolean bl7 = false;
                if (it.length() > 0) {
                    iamInfluenceType = OSInfluenceType.DIRECT;
                    iamIds = it;
                }
            }
        }
        if ((oSOutcomeSource = eventParams.getOutcomeSource()) != null && (oSOutcomeSourceBody2 = oSOutcomeSource.getIndirectBody()) != null) {
            oSOutcomeSourceBody = oSOutcomeSourceBody2;
            bl4 = false;
            bl3 = false;
            OSOutcomeSourceBody indirectBody = oSOutcomeSourceBody;
            boolean bl8 = false;
            jSONArray2 = indirectBody.getNotificationIds();
            if (jSONArray2 != null) {
                jSONArray = jSONArray2;
                bl2 = false;
                bl = false;
                it = jSONArray;
                boolean bl9 = false;
                if (it.length() > 0) {
                    notificationInfluenceType = OSInfluenceType.INDIRECT;
                    notificationIds = it;
                }
            }
            jSONArray2 = indirectBody.getInAppMessagesIds();
            if (jSONArray2 != null) {
                jSONArray = jSONArray2;
                bl2 = false;
                bl = false;
                it = jSONArray;
                boolean bl10 = false;
                if (it.length() > 0) {
                    iamInfluenceType = OSInfluenceType.INDIRECT;
                    iamIds = it;
                }
            }
        }
        oSOutcomeSource = new ContentValues();
        boolean bl11 = false;
        boolean bl12 = false;
        OSOutcomeSource $this$saveOutcomeEvent_u24lambda_u2d6 = oSOutcomeSource;
        boolean bl13 = false;
        $this$saveOutcomeEvent_u24lambda_u2d6.put("notification_ids", notificationIds.toString());
        $this$saveOutcomeEvent_u24lambda_u2d6.put("iam_ids", iamIds.toString());
        String string2 = notificationInfluenceType.toString();
        boolean bl14 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        $this$saveOutcomeEvent_u24lambda_u2d6.put("notification_influence_type", string4);
        string2 = iamInfluenceType.toString();
        bl14 = false;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        $this$saveOutcomeEvent_u24lambda_u2d6.put("iam_influence_type", string6);
        $this$saveOutcomeEvent_u24lambda_u2d6.put("name", eventParams.getOutcomeId());
        $this$saveOutcomeEvent_u24lambda_u2d6.put("weight", Float.valueOf(eventParams.getWeight()));
        $this$saveOutcomeEvent_u24lambda_u2d6.put("timestamp", eventParams.getTimestamp());
        bl11 = false;
        bl12 = false;
        OSOutcomeSource values = oSOutcomeSource;
        boolean bl15 = false;
        this.dbHelper.insert("outcome", null, (ContentValues)values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final synchronized List<OSOutcomeEventParams> getAllEventsToSend() {
        List events = new ArrayList();
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.query("outcome", null, null, null, null, null, null);
            boolean bl = false;
            boolean bl2 = false;
            Cursor $this$getAllEventsToSend_u24lambda_u2d10 = cursor;
            boolean bl3 = false;
            if ($this$getAllEventsToSend_u24lambda_u2d10.moveToFirst()) {
                do {
                    String notificationInfluenceTypeString = $this$getAllEventsToSend_u24lambda_u2d10.getString($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("notification_influence_type"));
                    OSInfluenceType notificationInfluenceType = OSInfluenceType.Companion.fromString(notificationInfluenceTypeString);
                    String iamInfluenceTypeString = $this$getAllEventsToSend_u24lambda_u2d10.getString($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("iam_influence_type"));
                    OSInfluenceType iamInfluenceType = OSInfluenceType.Companion.fromString(iamInfluenceTypeString);
                    String string2 = $this$getAllEventsToSend_u24lambda_u2d10.getString($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("notification_ids"));
                    String notificationIds = string2 == null ? "[]" : string2;
                    String string3 = $this$getAllEventsToSend_u24lambda_u2d10.getString($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("iam_ids"));
                    String iamIds = string3 == null ? "[]" : string3;
                    String name = $this$getAllEventsToSend_u24lambda_u2d10.getString($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("name"));
                    float weight = $this$getAllEventsToSend_u24lambda_u2d10.getFloat($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("weight"));
                    long timestamp = $this$getAllEventsToSend_u24lambda_u2d10.getLong($this$getAllEventsToSend_u24lambda_u2d10.getColumnIndex("timestamp"));
                    try {
                        OSOutcomeSourceBody directSourceBody = new OSOutcomeSourceBody(null, null, 3, null);
                        OSOutcomeSourceBody indirectSourceBody = new OSOutcomeSourceBody(null, null, 3, null);
                        OSOutcomeSource oSOutcomeSource = this.getNotificationInfluenceSource(notificationInfluenceType, directSourceBody, indirectSourceBody, notificationIds);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        OSOutcomeSource it = oSOutcomeSource;
                        boolean bl6 = false;
                        this.getIAMInfluenceSource(iamInfluenceType, directSourceBody, indirectSourceBody, iamIds, it);
                        Object object = oSOutcomeSource;
                        OSOutcomeSource source = object == null ? new OSOutcomeSource(null, null) : object;
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        object = new OSOutcomeEventParams(name, source, weight, timestamp);
                        boolean bl7 = false;
                        bl4 = false;
                        Object it2 = object;
                        boolean bl8 = false;
                        events.add(it2);
                    }
                    catch (JSONException e) {
                        this.logger.error("Generating JSONArray from notifications ids outcome:JSON Failed.", e);
                    }
                } while ($this$getAllEventsToSend_u24lambda_u2d10.moveToNext());
            }
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                Cursor cursor3 = cursor2;
                boolean bl = false;
                boolean bl9 = false;
                Cursor it = cursor3;
                boolean bl10 = false;
                if (!it.isClosed()) {
                    it.close();
                }
            }
        }
        return events;
    }

    private final OSOutcomeSource getNotificationInfluenceSource(OSInfluenceType notificationInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String notificationIds) {
        OSOutcomeSource oSOutcomeSource;
        OSInfluenceType oSInfluenceType = notificationInfluenceType;
        int n = WhenMappings.$EnumSwitchMapping$0[oSInfluenceType.ordinal()];
        switch (n) {
            case 1: {
                directSourceBody.setNotificationIds(new JSONArray(notificationIds));
                oSOutcomeSource = new OSOutcomeSource(directSourceBody, null);
                break;
            }
            case 2: {
                indirectSourceBody.setNotificationIds(new JSONArray(notificationIds));
                oSOutcomeSource = new OSOutcomeSource(null, indirectSourceBody);
                break;
            }
            default: {
                oSOutcomeSource = null;
            }
        }
        return oSOutcomeSource;
    }

    private final OSOutcomeSource getIAMInfluenceSource(OSInfluenceType iamInfluenceType, OSOutcomeSourceBody directSourceBody, OSOutcomeSourceBody indirectSourceBody, String iamIds, OSOutcomeSource source) {
        OSOutcomeSource oSOutcomeSource;
        OSInfluenceType oSInfluenceType = iamInfluenceType;
        int n = WhenMappings.$EnumSwitchMapping$0[oSInfluenceType.ordinal()];
        switch (n) {
            case 1: {
                OSOutcomeSource oSOutcomeSource2;
                directSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                OSOutcomeSource oSOutcomeSource3 = source;
                OSOutcomeSource oSOutcomeSource4 = oSOutcomeSource2 = oSOutcomeSource3 == null ? null : oSOutcomeSource3.setDirectBody(directSourceBody);
                if (oSOutcomeSource2 == null) {
                    oSOutcomeSource = new OSOutcomeSource(directSourceBody, null);
                    break;
                }
                oSOutcomeSource = oSOutcomeSource2;
                break;
            }
            case 2: {
                OSOutcomeSource oSOutcomeSource5;
                indirectSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                OSOutcomeSource oSOutcomeSource6 = source;
                OSOutcomeSource oSOutcomeSource7 = oSOutcomeSource5 = oSOutcomeSource6 == null ? null : oSOutcomeSource6.setIndirectBody(indirectSourceBody);
                if (oSOutcomeSource5 == null) {
                    oSOutcomeSource = new OSOutcomeSource(null, indirectSourceBody);
                    break;
                }
                oSOutcomeSource = oSOutcomeSource5;
                break;
            }
            default: {
                oSOutcomeSource = source;
            }
        }
        return oSOutcomeSource;
    }

    private final void addIdToListFromChannel(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, JSONArray channelIds, OSInfluenceChannel channel) {
        JSONArray jSONArray = channelIds;
        if (jSONArray != null) {
            JSONArray jSONArray2 = jSONArray;
            boolean bl = false;
            boolean bl2 = false;
            JSONArray it = jSONArray2;
            boolean bl3 = false;
            int n = 0;
            int n2 = it.length();
            if (n < n2) {
                do {
                    int i = n++;
                    try {
                        String influenceId = it.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)influenceId, (String)"influenceId");
                        cachedUniqueOutcomes.add(new OSCachedUniqueOutcome(influenceId, channel));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (n < n2);
            }
        }
    }

    private final void addIdsToListFromSource(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, OSOutcomeSourceBody sourceBody) {
        OSOutcomeSourceBody oSOutcomeSourceBody = sourceBody;
        if (oSOutcomeSourceBody != null) {
            OSOutcomeSourceBody oSOutcomeSourceBody2 = oSOutcomeSourceBody;
            boolean bl = false;
            boolean bl2 = false;
            OSOutcomeSourceBody it = oSOutcomeSourceBody2;
            boolean bl3 = false;
            JSONArray iamIds = it.getInAppMessagesIds();
            JSONArray notificationIds = it.getNotificationIds();
            this.addIdToListFromChannel(cachedUniqueOutcomes, iamIds, OSInfluenceChannel.IAM);
            this.addIdToListFromChannel(cachedUniqueOutcomes, notificationIds, OSInfluenceChannel.NOTIFICATION);
        }
    }

    @WorkerThread
    public final synchronized void saveUniqueOutcomeEventParams(@NotNull OSOutcomeEventParams eventParams) {
        Intrinsics.checkNotNullParameter((Object)eventParams, (String)"eventParams");
        this.logger.debug(Intrinsics.stringPlus((String)"OneSignal saveUniqueOutcomeEventParams: ", (Object)eventParams));
        String outcomeName = eventParams.getOutcomeId();
        List cachedUniqueOutcomes = new ArrayList();
        OSOutcomeSource oSOutcomeSource = eventParams.getOutcomeSource();
        OSOutcomeSourceBody directBody = oSOutcomeSource == null ? null : oSOutcomeSource.getDirectBody();
        OSOutcomeSource oSOutcomeSource2 = eventParams.getOutcomeSource();
        OSOutcomeSourceBody indirectBody = oSOutcomeSource2 == null ? null : oSOutcomeSource2.getIndirectBody();
        this.addIdsToListFromSource(cachedUniqueOutcomes, directBody);
        this.addIdsToListFromSource(cachedUniqueOutcomes, indirectBody);
        for (OSCachedUniqueOutcome uniqueOutcome : cachedUniqueOutcomes) {
            ContentValues contentValues = new ContentValues();
            boolean bl = false;
            boolean bl2 = false;
            ContentValues $this$saveUniqueOutcomeEventParams_u24lambda_u2d14 = contentValues;
            boolean bl3 = false;
            $this$saveUniqueOutcomeEventParams_u24lambda_u2d14.put("channel_influence_id", uniqueOutcome.getInfluenceId());
            $this$saveUniqueOutcomeEventParams_u24lambda_u2d14.put("channel_type", uniqueOutcome.getChannel().toString());
            $this$saveUniqueOutcomeEventParams_u24lambda_u2d14.put("name", outcomeName);
            bl = false;
            bl2 = false;
            ContentValues values = contentValues;
            boolean bl4 = false;
            this.dbHelper.insert("cached_unique_outcome", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final synchronized List<OSInfluence> getNotCachedUniqueInfluencesForOutcome(@NotNull String name, @NotNull List<OSInfluence> influences) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(influences, (String)"influences");
        List uniqueInfluences = new ArrayList();
        Cursor cursor = null;
        try {
            for (OSInfluence influence : influences) {
                int i;
                JSONArray availableInfluenceIds = new JSONArray();
                JSONArray jSONArray = influence.getIds();
                if (jSONArray == null) continue;
                int n = 0;
                JSONArray influenceIds = jSONArray;
                int n2 = influenceIds.length();
                if (n < n2) {
                    do {
                        i = n++;
                        String channelInfluenceId = influenceIds.getString(i);
                        OSInfluenceChannel channel = influence.getInfluenceChannel();
                        String[] columns = new String[]{};
                        String where = "channel_influence_id = ? AND channel_type = ? AND name = ?";
                        String[] stringArray = new String[]{channelInfluenceId, channel.toString(), name};
                        String[] args = stringArray;
                        cursor = this.dbHelper.query("cached_unique_outcome", columns, where, args, null, null, null, "1");
                        if (cursor.getCount() != 0) continue;
                        availableInfluenceIds.put((Object)channelInfluenceId);
                    } while (n < n2);
                }
                if (availableInfluenceIds.length() <= 0) continue;
                OSInfluence oSInfluence = influence.copy();
                n2 = 0;
                i = 0;
                OSInfluence $this$getNotCachedUniqueInfluencesForOutcome_u24lambda_u2d16 = oSInfluence;
                boolean bl = false;
                $this$getNotCachedUniqueInfluencesForOutcome_u24lambda_u2d16.setIds(availableInfluenceIds);
                n2 = 0;
                i = 0;
                OSInfluence newInfluence = oSInfluence;
                boolean bl2 = false;
                uniqueInfluences.add(newInfluence);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                Cursor cursor3 = cursor2;
                boolean bl = false;
                boolean bl3 = false;
                Cursor it = cursor3;
                boolean bl4 = false;
                if (!it.isClosed()) {
                    it.close();
                }
            }
        }
        return uniqueInfluences;
    }

    @WorkerThread
    public final synchronized void cleanCachedUniqueOutcomeEventNotifications(@NotNull String notificationTableName, @NotNull String notificationIdColumnName) {
        Intrinsics.checkNotNullParameter((Object)notificationTableName, (String)"notificationTableName");
        Intrinsics.checkNotNullParameter((Object)notificationIdColumnName, (String)"notificationIdColumnName");
        StringBuilder stringBuilder = new StringBuilder().append("NOT EXISTS(SELECT NULL FROM ").append(notificationTableName).append(" n WHERE n.").append(notificationIdColumnName).append(" = channel_influence_id AND channel_type = \"");
        String string2 = OSInfluenceChannel.NOTIFICATION.toString();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        String whereStr = stringBuilder.append(string5).append("\")").toString();
        this.dbHelper.delete("cached_unique_outcome", whereStr, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OSInfluenceType.values().length];
            nArray[OSInfluenceType.DIRECT.ordinal()] = 1;
            nArray[OSInfluenceType.INDIRECT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

