/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.net.Uri;
import com.onesignal.OSNotification;
import com.onesignal.OneSignal;
import java.security.SecureRandom;
import org.json.JSONObject;

public class OSNotificationGenerationJob {
    private OSNotification notification;
    private Context context;
    private JSONObject jsonPayload;
    private boolean restoring;
    private Long shownTimeStamp;
    private CharSequence overriddenBodyFromExtender;
    private CharSequence overriddenTitleFromExtender;
    private Uri overriddenSound;
    private Integer overriddenFlags;
    private Integer orgFlags;
    private Uri orgSound;

    OSNotificationGenerationJob(Context context) {
        this.context = context;
    }

    OSNotificationGenerationJob(Context context, JSONObject jsonPayload) {
        this(context, new OSNotification(jsonPayload), jsonPayload);
    }

    OSNotificationGenerationJob(Context context, OSNotification notification, JSONObject jsonPayload) {
        this.context = context;
        this.jsonPayload = jsonPayload;
        this.notification = notification;
    }

    CharSequence getTitle() {
        if (this.overriddenTitleFromExtender != null) {
            return this.overriddenTitleFromExtender;
        }
        return this.notification.getTitle();
    }

    CharSequence getBody() {
        if (this.overriddenBodyFromExtender != null) {
            return this.overriddenBodyFromExtender;
        }
        return this.notification.getBody();
    }

    JSONObject getAdditionalData() {
        return this.notification.getAdditionalData() != null ? this.notification.getAdditionalData() : new JSONObject();
    }

    boolean isNotificationToDisplay() {
        return this.getAndroidIdWithoutCreate() != -1;
    }

    boolean hasExtender() {
        return this.notification.getNotificationExtender() != null;
    }

    String getApiNotificationId() {
        return OneSignal.getNotificationIdFromFCMJson(this.jsonPayload);
    }

    int getAndroidIdWithoutCreate() {
        if (!this.notification.hasNotificationId()) {
            return -1;
        }
        return this.notification.getAndroidNotificationId();
    }

    Integer getAndroidId() {
        if (!this.notification.hasNotificationId()) {
            this.notification.setAndroidNotificationId(new SecureRandom().nextInt());
        }
        return this.notification.getAndroidNotificationId();
    }

    void setAndroidIdWithoutOverriding(Integer id2) {
        if (id2 == null) {
            return;
        }
        if (this.notification.hasNotificationId()) {
            return;
        }
        this.notification.setAndroidNotificationId(id2);
    }

    public OSNotification getNotification() {
        return this.notification;
    }

    public void setNotification(OSNotification notification) {
        this.notification = notification;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public JSONObject getJsonPayload() {
        return this.jsonPayload;
    }

    public void setJsonPayload(JSONObject jsonPayload) {
        this.jsonPayload = jsonPayload;
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public void setRestoring(boolean restoring) {
        this.restoring = restoring;
    }

    public Long getShownTimeStamp() {
        return this.shownTimeStamp;
    }

    public void setShownTimeStamp(Long shownTimeStamp) {
        this.shownTimeStamp = shownTimeStamp;
    }

    public CharSequence getOverriddenBodyFromExtender() {
        return this.overriddenBodyFromExtender;
    }

    public void setOverriddenBodyFromExtender(CharSequence overriddenBodyFromExtender) {
        this.overriddenBodyFromExtender = overriddenBodyFromExtender;
    }

    public CharSequence getOverriddenTitleFromExtender() {
        return this.overriddenTitleFromExtender;
    }

    public void setOverriddenTitleFromExtender(CharSequence overriddenTitleFromExtender) {
        this.overriddenTitleFromExtender = overriddenTitleFromExtender;
    }

    public Uri getOverriddenSound() {
        return this.overriddenSound;
    }

    public void setOverriddenSound(Uri overriddenSound) {
        this.overriddenSound = overriddenSound;
    }

    public Integer getOverriddenFlags() {
        return this.overriddenFlags;
    }

    public void setOverriddenFlags(Integer overriddenFlags) {
        this.overriddenFlags = overriddenFlags;
    }

    public Integer getOrgFlags() {
        return this.orgFlags;
    }

    public void setOrgFlags(Integer orgFlags) {
        this.orgFlags = orgFlags;
    }

    public Uri getOrgSound() {
        return this.orgSound;
    }

    public void setOrgSound(Uri orgSound) {
        this.orgSound = orgSound;
    }

    public String toString() {
        return "OSNotificationGenerationJob{jsonPayload=" + this.jsonPayload + ", isRestoring=" + this.restoring + ", shownTimeStamp=" + this.shownTimeStamp + ", overriddenBodyFromExtender=" + this.overriddenBodyFromExtender + ", overriddenTitleFromExtender=" + this.overriddenTitleFromExtender + ", overriddenSound=" + this.overriddenSound + ", overriddenFlags=" + this.overriddenFlags + ", orgFlags=" + this.orgFlags + ", orgSound=" + this.orgSound + ", notification=" + this.notification + '}';
    }
}

