/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.onesignal.NotificationLimitManager;
import com.onesignal.OneSignalDbHelper;
import java.util.ArrayList;

public class OneSignalNotificationManager {
    private static final String GROUPLESS_SUMMARY_KEY = "os_group_undefined";
    private static final int GROUPLESS_SUMMARY_ID = -718463522;

    static String getGrouplessSummaryKey() {
        return GROUPLESS_SUMMARY_KEY;
    }

    static int getGrouplessSummaryId() {
        return -718463522;
    }

    static NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    @RequiresApi(api=23)
    static Integer getGrouplessNotifsCount(Context context) {
        StatusBarNotification[] statusBarNotifications = OneSignalNotificationManager.getActiveNotifications(context);
        int groupCount = 0;
        for (StatusBarNotification statusBarNotification : statusBarNotifications) {
            if (NotificationCompat.isGroupSummary((Notification)statusBarNotification.getNotification()) || !GROUPLESS_SUMMARY_KEY.equals(statusBarNotification.getNotification().getGroup())) continue;
            ++groupCount;
        }
        return groupCount;
    }

    @RequiresApi(api=23)
    static StatusBarNotification[] getActiveNotifications(Context context) {
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[]{};
        try {
            statusBarNotifications = OneSignalNotificationManager.getNotificationManager(context).getActiveNotifications();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return statusBarNotifications;
    }

    @RequiresApi(api=23)
    static ArrayList<StatusBarNotification> getActiveGrouplessNotifications(Context context) {
        StatusBarNotification[] statusBarNotifications;
        ArrayList<StatusBarNotification> grouplessStatusBarNotifications = new ArrayList<StatusBarNotification>();
        for (StatusBarNotification statusBarNotification : statusBarNotifications = OneSignalNotificationManager.getActiveNotifications(context)) {
            boolean isGroupless;
            Notification notification = statusBarNotification.getNotification();
            boolean isGroupSummary = NotificationLimitManager.isGroupSummary(statusBarNotification);
            boolean bl = isGroupless = notification.getGroup() == null || notification.getGroup().equals(OneSignalNotificationManager.getGrouplessSummaryKey());
            if (isGroupSummary || !isGroupless) continue;
            grouplessStatusBarNotifications.add(statusBarNotification);
        }
        return grouplessStatusBarNotifications;
    }

    @RequiresApi(api=23)
    static void assignGrouplessNotifications(Context context, ArrayList<StatusBarNotification> grouplessNotifs) {
        for (StatusBarNotification grouplessNotif : grouplessNotifs) {
            Notification.Builder grouplessNotifBuilder = Build.VERSION.SDK_INT >= 24 ? Notification.Builder.recoverBuilder((Context)context, (Notification)grouplessNotif.getNotification()) : new Notification.Builder(context);
            Notification notif = grouplessNotifBuilder.setGroup(GROUPLESS_SUMMARY_KEY).build();
            NotificationManagerCompat.from((Context)context).notify(grouplessNotif.getId(), notif);
        }
    }

    static Integer getMostRecentNotifIdFromGroup(OneSignalDbHelper db, String group, boolean isGroupless) {
        String[] stringArray;
        String whereStr = isGroupless ? "group_id IS NULL" : "group_id = ?";
        whereStr = whereStr + " AND dismissed = 0 AND opened = 0 AND is_summary = 0";
        if (isGroupless) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = group;
        }
        String[] whereArgs = stringArray;
        Cursor cursor = db.query("notification", null, whereStr, whereArgs, null, null, "created_time DESC", "1");
        boolean hasRecord = cursor.moveToFirst();
        if (!hasRecord) {
            cursor.close();
            return null;
        }
        Integer recentId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
        cursor.close();
        return recentId;
    }

    @Nullable
    public static boolean areNotificationsEnabled(Context context, String channelId) {
        boolean notificationsEnabled = NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
        if (!notificationsEnabled) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = OneSignalNotificationManager.getNotificationManager(context).getNotificationChannel(channelId);
            return channel == null || channel.getImportance() != 0;
        }
        return true;
    }
}

