/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationManagerCompat;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSInAppMessagePreviewHandler;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationIntentExtras;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationOpenedProcessor {
    private static final String TAG = NotificationOpenedProcessor.class.getCanonicalName();

    NotificationOpenedProcessor() {
    }

    static void processFromContext(Context context, Intent intent) {
        if (!NotificationOpenedProcessor.isOneSignalIntent(intent)) {
            return;
        }
        if (context != null) {
            OneSignal.initWithContext(context.getApplicationContext());
        }
        NotificationOpenedProcessor.handleDismissFromActionButtonPress(context, intent);
        NotificationOpenedProcessor.processIntent(context, intent);
    }

    private static boolean isOneSignalIntent(Intent intent) {
        return intent.hasExtra("onesignalData") || intent.hasExtra("summary") || intent.hasExtra("androidNotificationId");
    }

    private static void handleDismissFromActionButtonPress(Context context, Intent intent) {
        if (intent.getBooleanExtra("action_button", false)) {
            NotificationManagerCompat.from((Context)context).cancel(intent.getIntExtra("androidNotificationId", 0));
            context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
    }

    static void processIntent(Context context, Intent intent) {
        String group;
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        String summaryGroup = intent.getStringExtra("summary");
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        OSNotificationIntentExtras intentExtras = null;
        if (!dismissed && (intentExtras = NotificationOpenedProcessor.processToOpenIntent(context, intent, dbHelper, summaryGroup)) == null) {
            return;
        }
        NotificationOpenedProcessor.markNotificationsConsumed(context, intent, dbHelper, dismissed);
        if (summaryGroup == null && (group = intent.getStringExtra("grp")) != null) {
            NotificationSummaryManager.updateSummaryNotificationAfterChildRemoved(context, dbHelper, group, dismissed);
        }
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "processIntent from context: " + context + " and intent: " + intent);
        if (intent.getExtras() != null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "processIntent intent extras: " + intent.getExtras().toString());
        }
        if (!dismissed) {
            if (!(context instanceof Activity)) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "NotificationOpenedProcessor processIntent from an non Activity context: " + context);
            } else {
                OneSignal.handleNotificationOpen((Activity)context, intentExtras.getDataArray(), intent.getBooleanExtra("from_alert", false), OSNotificationFormatHelper.getOSNotificationIdFromJson(intentExtras.getJsonData()));
            }
        }
    }

    static OSNotificationIntentExtras processToOpenIntent(Context context, Intent intent, OneSignalDbHelper dbHelper, String summaryGroup) {
        JSONArray dataArray = null;
        JSONObject jsonData = null;
        try {
            jsonData = new JSONObject(intent.getStringExtra("onesignalData"));
            if (!(context instanceof Activity)) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "NotificationOpenedProcessor processIntent from an non Activity context: " + context);
            } else if (NotificationOpenedProcessor.handleIAMPreviewOpen((Activity)context, jsonData)) {
                return null;
            }
            jsonData.put("androidNotificationId", intent.getIntExtra("androidNotificationId", 0));
            intent.putExtra("onesignalData", jsonData.toString());
            dataArray = NotificationBundleProcessor.newJsonArray(new JSONObject(intent.getStringExtra("onesignalData")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (summaryGroup != null) {
            NotificationOpenedProcessor.addChildNotifications(dataArray, summaryGroup, dbHelper);
        }
        return new OSNotificationIntentExtras(dataArray, jsonData);
    }

    static boolean handleIAMPreviewOpen(@NonNull Activity context, @NonNull JSONObject jsonData) {
        String previewUUID = OSInAppMessagePreviewHandler.inAppPreviewPushUUID(jsonData);
        if (previewUUID == null) {
            return false;
        }
        OneSignal.startOrResumeApp(context);
        OneSignal.getInAppMessageController().displayPreviewMessage(previewUUID);
        return true;
    }

    private static void addChildNotifications(JSONArray dataArray, String summaryGroup, OneSignalDbHelper writableDb) {
        String[] retColumn = new String[]{"full_data"};
        String[] whereArgs = new String[]{summaryGroup};
        Cursor cursor = writableDb.query("notification", retColumn, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", whereArgs, null, null, null);
        if (cursor.getCount() > 1) {
            cursor.moveToFirst();
            do {
                try {
                    String jsonStr = cursor.getString(cursor.getColumnIndex("full_data"));
                    dataArray.put((Object)new JSONObject(jsonStr));
                }
                catch (JSONException e) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not parse JSON of sub notification in group: " + summaryGroup);
                }
            } while (cursor.moveToNext());
        }
        cursor.close();
    }

    private static void markNotificationsConsumed(Context context, Intent intent, OneSignalDbHelper writableDb, boolean dismissed) {
        String whereStr;
        String summaryGroup = intent.getStringExtra("summary");
        String[] whereArgs = null;
        if (summaryGroup != null) {
            boolean shouldDismissAll;
            boolean isGroupless = summaryGroup.equals(OneSignalNotificationManager.getGrouplessSummaryKey());
            if (isGroupless) {
                whereStr = "group_id IS NULL";
            } else {
                whereStr = "group_id = ?";
                whereArgs = new String[]{summaryGroup};
            }
            if (!dismissed && !(shouldDismissAll = OneSignal.getClearGroupSummaryClick())) {
                String[] stringArray;
                String mostRecentId = String.valueOf(OneSignalNotificationManager.getMostRecentNotifIdFromGroup(writableDb, summaryGroup, isGroupless));
                whereStr = whereStr + " AND android_notification_id = ?";
                if (isGroupless) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = mostRecentId;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = summaryGroup;
                    stringArray = stringArray3;
                    stringArray3[1] = mostRecentId;
                }
                whereArgs = stringArray;
            }
        } else {
            whereStr = "android_notification_id = " + intent.getIntExtra("androidNotificationId", 0);
        }
        NotificationOpenedProcessor.clearStatusBarNotifications(context, writableDb, summaryGroup);
        writableDb.update("notification", NotificationOpenedProcessor.newContentValuesWithConsumed(intent), whereStr, whereArgs);
        BadgeCountUpdater.update(writableDb, context);
    }

    private static void clearStatusBarNotifications(Context context, OneSignalDbHelper writableDb, String summaryGroup) {
        int grouplessCount;
        if (summaryGroup != null) {
            NotificationSummaryManager.clearNotificationOnSummaryClick(context, writableDb, summaryGroup);
        } else if (Build.VERSION.SDK_INT >= 23 && (grouplessCount = OneSignalNotificationManager.getGrouplessNotifsCount(context).intValue()) < 1) {
            int groupId = OneSignalNotificationManager.getGrouplessSummaryId();
            NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(context);
            notificationManager.cancel(groupId);
        }
    }

    private static ContentValues newContentValuesWithConsumed(Intent intent) {
        ContentValues values = new ContentValues();
        boolean dismissed = intent.getBooleanExtra("dismissed", false);
        if (dismissed) {
            values.put("dismissed", Integer.valueOf(1));
        } else {
            values.put("opened", Integer.valueOf(1));
        }
        return values;
    }
}

