/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkerParameters;
import com.google.common.util.concurrent.ListenableFuture;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationController;
import com.onesignal.OSNotificationReceivedEvent;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class OSNotificationWorkManager {
    private static final String OS_NOTIFICATION_ID = "os_bnotification_id";
    private static final String ANDROID_NOTIF_ID_WORKER_DATA_PARAM = "android_notif_id";
    private static final String JSON_PAYLOAD_WORKER_DATA_PARAM = "json_payload";
    private static final String TIMESTAMP_WORKER_DATA_PARAM = "timestamp";
    private static final String IS_RESTORING_WORKER_DATA_PARAM = "is_restoring";
    private static Set<String> notificationIds = OSUtils.newConcurrentSet();

    OSNotificationWorkManager() {
    }

    static boolean addNotificationIdProcessed(String osNotificationId) {
        if (OSUtils.isStringNotEmpty(osNotificationId)) {
            if (notificationIds.contains(osNotificationId)) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationWorkManager notification with notificationId: " + osNotificationId + " already queued");
                return false;
            }
            notificationIds.add(osNotificationId);
        }
        return true;
    }

    static void removeNotificationIdProcessed(String osNotificationId) {
        if (OSUtils.isStringNotEmpty(osNotificationId)) {
            notificationIds.remove(osNotificationId);
        }
    }

    static void beginEnqueueingWork(Context context, String osNotificationId, int androidNotificationId, String jsonPayload, long timestamp, boolean isRestoring, boolean isHighPriority, boolean needsWorkerThread) {
        if (!needsWorkerThread) {
            try {
                JSONObject jsonPayloadObject = new JSONObject(jsonPayload);
                OSNotificationWorkManager.processNotificationData(context, androidNotificationId, jsonPayloadObject, isRestoring, timestamp);
            }
            catch (JSONException e) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error occurred parsing jsonPayload to JSONObject in beginEnqueueingWork e: " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
        Data inputData = new Data.Builder().putString(OS_NOTIFICATION_ID, osNotificationId).putInt(ANDROID_NOTIF_ID_WORKER_DATA_PARAM, androidNotificationId).putString(JSON_PAYLOAD_WORKER_DATA_PARAM, jsonPayload).putLong(TIMESTAMP_WORKER_DATA_PARAM, timestamp).putBoolean(IS_RESTORING_WORKER_DATA_PARAM, isRestoring).build();
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(NotificationWorker.class).setInputData(inputData)).build();
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationWorkManager enqueueing notification work with notificationId: " + osNotificationId + " and jsonPayload: " + jsonPayload);
        WorkManager.getInstance((Context)context).enqueueUniqueWork(osNotificationId, ExistingWorkPolicy.KEEP, workRequest);
    }

    static void processNotificationData(Context context, int androidNotificationId, JSONObject jsonPayload, boolean isRestoring, Long timestamp) {
        OSNotificationWorkManager.processNotificationData(null, context, androidNotificationId, jsonPayload, isRestoring, timestamp);
    }

    static void processNotificationData(CallbackToFutureAdapter.Completer<ListenableWorker.Result> completer, Context context, int androidNotificationId, JSONObject jsonPayload, boolean isRestoring, Long timestamp) {
        OSNotification notification = new OSNotification(null, jsonPayload, androidNotificationId);
        OSNotificationController controller = new OSNotificationController(completer, context, jsonPayload, isRestoring, true, timestamp);
        OSNotificationReceivedEvent notificationReceived = new OSNotificationReceivedEvent(controller, notification);
        if (OneSignal.remoteNotificationReceivedHandler != null) {
            try {
                OneSignal.remoteNotificationReceivedHandler.remoteNotificationReceived(context, notificationReceived);
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "remoteNotificationReceived throw an exception. Displaying normal OneSignal notification.", t);
                notificationReceived.complete(notification);
                throw t;
            }
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "remoteNotificationReceivedHandler not setup, displaying normal OneSignal notification");
            notificationReceived.complete(notification);
        }
    }

    public static class NotificationWorker
    extends ListenableWorker {
        public NotificationWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
            super(context, workerParams);
        }

        @NonNull
        public ListenableFuture<ListenableWorker.Result> startWork() {
            return CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<ListenableWorker.Result>(){

                @Nullable
                public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<ListenableWorker.Result> completer) throws Exception {
                    String notificationId = NotificationWorker.this.doWork((CallbackToFutureAdapter.Completer<ListenableWorker.Result>)completer);
                    return "NotificationWorkerFutureCallback_" + notificationId;
                }
            });
        }

        private String doWork(@NonNull CallbackToFutureAdapter.Completer<ListenableWorker.Result> completer) {
            Data inputData = this.getInputData();
            try {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "NotificationWorker running doWork with data: " + inputData);
                int androidNotificationId = inputData.getInt(OSNotificationWorkManager.ANDROID_NOTIF_ID_WORKER_DATA_PARAM, 0);
                JSONObject jsonPayload = new JSONObject(inputData.getString(OSNotificationWorkManager.JSON_PAYLOAD_WORKER_DATA_PARAM));
                long timestamp = inputData.getLong(OSNotificationWorkManager.TIMESTAMP_WORKER_DATA_PARAM, System.currentTimeMillis() / 1000L);
                boolean isRestoring = inputData.getBoolean(OSNotificationWorkManager.IS_RESTORING_WORKER_DATA_PARAM, false);
                OSNotificationWorkManager.processNotificationData(completer, this.getApplicationContext(), androidNotificationId, jsonPayload, isRestoring, timestamp);
            }
            catch (JSONException e) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error occurred doing work for job with id: " + this.getId().toString());
                e.printStackTrace();
                completer.setException((Throwable)e);
            }
            return inputData.getString(OSNotificationWorkManager.OS_NOTIFICATION_ID);
        }
    }
}

