/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSInAppMessageRedisplayStats;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class OSInAppMessageRepository {
    static final long IAM_CACHE_DATA_LIFETIME = 15552000L;
    private final OneSignalDbHelper dbHelper;

    OSInAppMessageRepository(OneSignalDbHelper dbHelper) {
        this.dbHelper = dbHelper;
    }

    @WorkerThread
    synchronized void saveInAppMessage(OSInAppMessage inAppMessage) {
        ContentValues values = new ContentValues();
        values.put("message_id", inAppMessage.messageId);
        values.put("display_quantity", Integer.valueOf(inAppMessage.getRedisplayStats().getDisplayQuantity()));
        values.put("last_display", Long.valueOf(inAppMessage.getRedisplayStats().getLastDisplayTime()));
        values.put("click_ids", inAppMessage.getClickedClickIds().toString());
        values.put("displayed_in_session", Boolean.valueOf(inAppMessage.isDisplayedInSession()));
        int rowsUpdated = this.dbHelper.update("in_app_message", values, "message_id = ?", new String[]{inAppMessage.messageId});
        if (rowsUpdated == 0) {
            this.dbHelper.insert("in_app_message", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSInAppMessage> getCachedInAppMessages() {
        ArrayList<OSInAppMessage> inAppMessages = new ArrayList<OSInAppMessage>();
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.query("in_app_message", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String clickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    int displayQuantity = cursor.getInt(cursor.getColumnIndex("display_quantity"));
                    long lastDisplay = cursor.getLong(cursor.getColumnIndex("last_display"));
                    boolean displayed = cursor.getInt(cursor.getColumnIndex("displayed_in_session")) == 1;
                    Set<String> clickIdsSet = OSUtils.newStringSetFromJSONArray(new JSONArray(clickIds));
                    OSInAppMessage inAppMessage = new OSInAppMessage(messageId, clickIdsSet, displayed, new OSInAppMessageRedisplayStats(displayQuantity, lastDisplay));
                    inAppMessages.add(inAppMessage);
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from iam click ids:JSON Failed.", e);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return inAppMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized void cleanCachedInAppMessages() {
        String[] retColumns = new String[]{"message_id", "click_ids"};
        String whereStr = "last_display < ?";
        String sixMonthsAgoInSeconds = String.valueOf(System.currentTimeMillis() / 1000L - 15552000L);
        String[] whereArgs = new String[]{sixMonthsAgoInSeconds};
        Set<String> oldMessageIds = OSUtils.newConcurrentSet();
        Set<String> oldClickedClickIds = OSUtils.newConcurrentSet();
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.query("in_app_message", retColumns, whereStr, whereArgs, null, null, null);
            if (cursor == null || cursor.getCount() == 0) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Attempted to clean 6 month old IAM data, but none exists!");
                return;
            }
            if (cursor.moveToFirst()) {
                do {
                    String oldMessageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String oldClickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    oldMessageIds.add(oldMessageId);
                    oldClickedClickIds.addAll(OSUtils.newStringSetFromJSONArray(new JSONArray(oldClickIds)));
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        this.dbHelper.delete("in_app_message", whereStr, whereArgs);
        this.cleanInAppMessageIds(oldMessageIds);
        this.cleanInAppMessageClickedClickIds(oldClickedClickIds);
    }

    private void cleanInAppMessageIds(Set<String> oldMessageIds) {
        if (oldMessageIds != null && oldMessageIds.size() > 0) {
            Set<String> dismissedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", null);
            Set<String> impressionedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", null);
            if (dismissedMessages != null && dismissedMessages.size() > 0) {
                dismissedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", dismissedMessages);
            }
            if (impressionedMessages != null && impressionedMessages.size() > 0) {
                impressionedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", impressionedMessages);
            }
        }
    }

    private void cleanInAppMessageClickedClickIds(Set<String> oldClickedClickIds) {
        Set<String> clickedClickIds;
        if (oldClickedClickIds != null && oldClickedClickIds.size() > 0 && (clickedClickIds = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", null)) != null && clickedClickIds.size() > 0) {
            clickedClickIds.removeAll(oldClickedClickIds);
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", clickedClickIds);
        }
    }
}

