/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.NotificationSummaryManager;
import com.onesignal.OSLogger;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSNotificationWorkManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

class OSNotificationDataController {
    private static final long NOTIFICATION_CACHE_DATA_LIFETIME = 604800L;
    private static final String OS_NOTIFICATIONS_THREAD = "OS_NOTIFICATIONS_THREAD";
    private final OneSignalDbHelper dbHelper;
    private final OSLogger logger;

    public OSNotificationDataController(OneSignalDbHelper dbHelper, OSLogger logger) {
        this.dbHelper = dbHelper;
        this.logger = logger;
    }

    void cleanOldCachedData() {
        this.cleanNotificationCache();
    }

    private void cleanNotificationCache() {
        BackgroundRunnable notificationCacheCleaner = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                String whereStr = "created_time < ?";
                String sevenDaysAgoInSeconds = String.valueOf(OneSignal.getTime().getCurrentTimeMillis() / 1000L - 604800L);
                String[] whereArgs = new String[]{sevenDaysAgoInSeconds};
                OSNotificationDataController.this.dbHelper.delete("notification", whereStr, whereArgs);
            }
        };
        this.runRunnableOnThread(notificationCacheCleaner);
    }

    void clearOneSignalNotifications(final WeakReference<Context> weakReference) {
        BackgroundRunnable runClearOneSignalNotifications = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                Context appContext = (Context)weakReference.get();
                if (appContext == null) {
                    return;
                }
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                String[] retColumn = new String[]{"android_notification_id"};
                Cursor cursor = OSNotificationDataController.this.dbHelper.query("notification", retColumn, "dismissed = 0 AND opened = 0", null, null, null, null);
                if (cursor.moveToFirst()) {
                    do {
                        int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                        notificationManager.cancel(existingId);
                    } while (cursor.moveToNext());
                }
                String whereStr = "opened = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                OSNotificationDataController.this.dbHelper.update("notification", values, whereStr, null);
                BadgeCountUpdater.updateCount(0, appContext);
                cursor.close();
            }
        };
        this.runRunnableOnThread(runClearOneSignalNotifications);
    }

    void removeGroupedNotifications(final String group, final WeakReference<Context> weakReference) {
        BackgroundRunnable runCancelGroupedNotifications = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                Context appContext = (Context)weakReference.get();
                if (appContext == null) {
                    return;
                }
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                String[] retColumn = new String[]{"android_notification_id"};
                String[] whereArgs = new String[]{group};
                String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0";
                Cursor cursor = OSNotificationDataController.this.dbHelper.query("notification", retColumn, whereStr, whereArgs, null, null, null);
                while (cursor.moveToNext()) {
                    int notificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                    if (notificationId == -1) continue;
                    notificationManager.cancel(notificationId);
                }
                cursor.close();
                whereStr = "group_id = ? AND opened = 0 AND dismissed = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                OSNotificationDataController.this.dbHelper.update("notification", values, whereStr, whereArgs);
                BadgeCountUpdater.update(OSNotificationDataController.this.dbHelper, appContext);
            }
        };
        this.runRunnableOnThread(runCancelGroupedNotifications);
    }

    void removeNotification(final int id2, final WeakReference<Context> weakReference) {
        BackgroundRunnable runCancelNotification = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                Context appContext = (Context)weakReference.get();
                if (appContext == null) {
                    return;
                }
                String whereStr = "android_notification_id = " + id2 + " AND " + "opened" + " = 0 AND " + "dismissed" + " = 0";
                ContentValues values = new ContentValues();
                values.put("dismissed", Integer.valueOf(1));
                int records = OSNotificationDataController.this.dbHelper.update("notification", values, whereStr, null);
                if (records > 0) {
                    NotificationSummaryManager.updatePossibleDependentSummaryOnDismiss(appContext, OSNotificationDataController.this.dbHelper, id2);
                }
                BadgeCountUpdater.update(OSNotificationDataController.this.dbHelper, appContext);
                NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(appContext);
                notificationManager.cancel(id2);
            }
        };
        this.runRunnableOnThread(runCancelNotification);
    }

    void notValidOrDuplicated(JSONObject jsonPayload, InvalidOrDuplicateNotificationCallback callback) {
        String id2 = OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonPayload);
        if (id2 == null) {
            this.logger.debug("Notification notValidOrDuplicated with id null");
            callback.onResult(true);
            return;
        }
        this.isDuplicateNotification(id2, callback);
    }

    private void isDuplicateNotification(final String id2, final InvalidOrDuplicateNotificationCallback callback) {
        if (id2 == null || "".equals(id2)) {
            callback.onResult(false);
            return;
        }
        if (!OSNotificationWorkManager.addNotificationIdProcessed(id2)) {
            this.logger.debug("Notification notValidOrDuplicated with id duplicated");
            callback.onResult(true);
            return;
        }
        BackgroundRunnable runCancelNotification = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                boolean result = false;
                String[] retColumn = new String[]{"notification_id"};
                String[] whereArgs = new String[]{id2};
                Cursor cursor = OSNotificationDataController.this.dbHelper.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
                boolean exists = cursor.moveToFirst();
                cursor.close();
                if (exists) {
                    OSNotificationDataController.this.logger.debug("Notification notValidOrDuplicated with id duplicated, duplicate FCM message received, skip processing of " + id2);
                    result = true;
                }
                callback.onResult(result);
            }
        };
        this.runRunnableOnThread(runCancelNotification);
    }

    private void runRunnableOnThread(Runnable runnable) {
        if (OSUtils.isRunningOnMainThread()) {
            new Thread(runnable, OS_NOTIFICATIONS_THREAD).start();
        } else {
            runnable.run();
        }
    }

    static interface InvalidOrDuplicateNotificationCallback {
        public void onResult(boolean var1);
    }

    private static class BackgroundRunnable
    implements Runnable {
        private BackgroundRunnable() {
        }

        @Override
        public void run() {
            Thread.currentThread().setPriority(10);
        }
    }
}

