/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.OSInAppMessageLocationPrompt;
import com.onesignal.OSInAppMessageOutcome;
import com.onesignal.OSInAppMessagePrompt;
import com.onesignal.OSInAppMessageTag;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OSInAppMessageAction {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String URL_TARGET = "url_target";
    private static final String CLOSE = "close";
    private static final String CLICK_NAME = "click_name";
    private static final String CLICK_URL = "click_url";
    private static final String FIRST_CLICK = "first_click";
    private static final String CLOSES_MESSAGE = "closes_message";
    private static final String OUTCOMES = "outcomes";
    private static final String TAGS = "tags";
    private static final String PROMPTS = "prompts";
    @NonNull
    private String clickId;
    @Nullable
    private String clickName;
    @Nullable
    private OSInAppMessageActionUrlType urlTarget;
    @Nullable
    private String clickUrl;
    @NonNull
    private List<OSInAppMessageOutcome> outcomes = new ArrayList<OSInAppMessageOutcome>();
    @NonNull
    private List<OSInAppMessagePrompt> prompts = new ArrayList<OSInAppMessagePrompt>();
    private OSInAppMessageTag tags;
    private boolean firstClick;
    private boolean closesMessage;

    OSInAppMessageAction(@NonNull JSONObject json) throws JSONException {
        this.clickId = json.optString(ID, null);
        this.clickName = json.optString(NAME, null);
        this.clickUrl = json.optString(URL, null);
        this.urlTarget = OSInAppMessageActionUrlType.fromString(json.optString(URL_TARGET, null));
        if (this.urlTarget == null) {
            this.urlTarget = OSInAppMessageActionUrlType.IN_APP_WEBVIEW;
        }
        this.closesMessage = json.optBoolean(CLOSE, true);
        if (json.has(OUTCOMES)) {
            this.parseOutcomes(json);
        }
        if (json.has(TAGS)) {
            this.tags = new OSInAppMessageTag(json.getJSONObject(TAGS));
        }
        if (json.has(PROMPTS)) {
            this.parsePrompts(json);
        }
    }

    private void parseOutcomes(JSONObject json) throws JSONException {
        JSONArray outcomesJsonArray = json.getJSONArray(OUTCOMES);
        for (int i = 0; i < outcomesJsonArray.length(); ++i) {
            this.outcomes.add(new OSInAppMessageOutcome((JSONObject)outcomesJsonArray.get(i)));
        }
    }

    private void parsePrompts(JSONObject json) throws JSONException {
        JSONArray promptsJsonArray = json.getJSONArray(PROMPTS);
        for (int i = 0; i < promptsJsonArray.length(); ++i) {
            if (!promptsJsonArray.get(i).equals("location")) continue;
            this.prompts.add(new OSInAppMessageLocationPrompt());
        }
    }

    @NonNull
    String getClickId() {
        return this.clickId;
    }

    @Nullable
    public String getClickName() {
        return this.clickName;
    }

    @Nullable
    public OSInAppMessageActionUrlType getUrlTarget() {
        return this.urlTarget;
    }

    @Nullable
    public String getClickUrl() {
        return this.clickUrl;
    }

    @NonNull
    public List<OSInAppMessageOutcome> getOutcomes() {
        return this.outcomes;
    }

    @NonNull
    public List<OSInAppMessagePrompt> getPrompts() {
        return this.prompts;
    }

    public OSInAppMessageTag getTags() {
        return this.tags;
    }

    public boolean isFirstClick() {
        return this.firstClick;
    }

    void setFirstClick(boolean firstClick) {
        this.firstClick = firstClick;
    }

    public boolean doesCloseMessage() {
        return this.closesMessage;
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put(CLICK_NAME, (Object)this.clickName);
            mainObj.put(CLICK_URL, (Object)this.clickUrl);
            mainObj.put(FIRST_CLICK, this.firstClick);
            mainObj.put(CLOSES_MESSAGE, this.closesMessage);
            JSONArray outcomesJson = new JSONArray();
            for (OSInAppMessageOutcome outcome : this.outcomes) {
                outcomesJson.put((Object)outcome.toJSONObject());
            }
            mainObj.put(OUTCOMES, (Object)outcomesJson);
            if (this.tags != null) {
                mainObj.put(TAGS, (Object)this.tags.toJSONObject());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public static enum OSInAppMessageActionUrlType {
        IN_APP_WEBVIEW("webview"),
        BROWSER("browser"),
        REPLACE_CONTENT("replacement");

        private String text;

        private OSInAppMessageActionUrlType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static OSInAppMessageActionUrlType fromString(String text) {
            for (OSInAppMessageActionUrlType type : OSInAppMessageActionUrlType.values()) {
                if (!type.text.equalsIgnoreCase(text)) continue;
                return type;
            }
            return null;
        }

        public JSONObject toJSONObject() {
            JSONObject mainObj = new JSONObject();
            try {
                mainObj.put("url_type", (Object)this.text);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return mainObj;
        }
    }
}

