/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.R;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.NotificationChannelManager;
import com.onesignal.NotificationDismissReceiver;
import com.onesignal.NotificationLimitManager;
import com.onesignal.NotificationOpenedReceiver;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSThrowable;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import com.onesignal.R;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GenerateNotification {
    public static final String OS_SHOW_NOTIFICATION_THREAD = "OS_SHOW_NOTIFICATION_THREAD";
    public static final String BUNDLE_KEY_ANDROID_NOTIFICATION_ID = "androidNotificationId";
    public static final String BUNDLE_KEY_ACTION_ID = "actionId";
    public static final String BUNDLE_KEY_ONESIGNAL_DATA = "onesignalData";
    private static Class<?> notificationOpenedClass = NotificationOpenedReceiver.class;
    private static Class<?> notificationDismissedClass = NotificationDismissReceiver.class;
    private static Resources contextResources = null;
    private static Context currentContext = null;
    private static String packageName = null;

    GenerateNotification() {
    }

    private static void setStatics(Context inContext) {
        currentContext = inContext;
        packageName = currentContext.getPackageName();
        contextResources = currentContext.getResources();
    }

    @WorkerThread
    static void fromJsonPayload(OSNotificationGenerationJob notificationJob) {
        GenerateNotification.setStatics(notificationJob.getContext());
        GenerateNotification.isRunningOnMainThreadCheck();
        GenerateNotification.showNotification(notificationJob);
    }

    static void isRunningOnMainThreadCheck() {
        if (OSUtils.isRunningOnMainThread()) {
            throw new OSThrowable.OSMainThreadException("Process for showing a notification should never been done on Main Thread!");
        }
    }

    private static CharSequence getTitle(JSONObject fcmJson) {
        String title = fcmJson.optString("title", null);
        if (title != null) {
            return title;
        }
        return currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo());
    }

    private static PendingIntent getNewActionPendingIntent(int requestCode, Intent intent) {
        return PendingIntent.getActivity((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private static PendingIntent getNewDismissActionPendingIntent(int requestCode, Intent intent) {
        return PendingIntent.getBroadcast((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private static Intent getNewBaseIntent(int notificationId) {
        return new Intent(currentContext, notificationOpenedClass).putExtra(BUNDLE_KEY_ANDROID_NOTIFICATION_ID, notificationId).addFlags(0x24000000);
    }

    private static Intent getNewBaseDismissIntent(int notificationId) {
        return new Intent(currentContext, notificationDismissedClass).putExtra(BUNDLE_KEY_ANDROID_NOTIFICATION_ID, notificationId).putExtra("dismissed", true);
    }

    private static OneSignalNotificationBuilder getBaseOneSignalNotificationBuilder(OSNotificationGenerationJob notificationJob) {
        Bitmap bigPictureIcon;
        NotificationCompat.Builder notificationBuilder;
        JSONObject fcmJson = notificationJob.getJsonPayload();
        OneSignalNotificationBuilder oneSignalNotificationBuilder = new OneSignalNotificationBuilder();
        try {
            String channelId = NotificationChannelManager.createNotificationChannel(notificationJob);
            notificationBuilder = new NotificationCompat.Builder(currentContext, channelId);
        }
        catch (Throwable t) {
            notificationBuilder = new NotificationCompat.Builder(currentContext);
        }
        String message = fcmJson.optString("alert", null);
        notificationBuilder.setAutoCancel(true).setSmallIcon(GenerateNotification.getSmallIconId(fcmJson)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message)).setContentText((CharSequence)message).setTicker((CharSequence)message);
        if (Build.VERSION.SDK_INT < 24 || !fcmJson.optString("title").equals("")) {
            notificationBuilder.setContentTitle(GenerateNotification.getTitle(fcmJson));
        }
        try {
            BigInteger accentColor = GenerateNotification.getAccentColor(fcmJson);
            if (accentColor != null) {
                notificationBuilder.setColor(accentColor.intValue());
            }
        }
        catch (Throwable accentColor) {
            // empty catch block
        }
        try {
            int lockScreenVisibility = 1;
            if (fcmJson.has("vis")) {
                lockScreenVisibility = Integer.parseInt(fcmJson.optString("vis"));
            }
            notificationBuilder.setVisibility(lockScreenVisibility);
        }
        catch (Throwable lockScreenVisibility) {
            // empty catch block
        }
        Bitmap largeIcon = GenerateNotification.getLargeIcon(fcmJson);
        if (largeIcon != null) {
            oneSignalNotificationBuilder.hasLargeIcon = true;
            notificationBuilder.setLargeIcon(largeIcon);
        }
        if ((bigPictureIcon = GenerateNotification.getBitmap(fcmJson.optString("bicon", null))) != null) {
            notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureIcon).setSummaryText((CharSequence)message));
        }
        if (notificationJob.getShownTimeStamp() != null) {
            try {
                notificationBuilder.setWhen(notificationJob.getShownTimeStamp() * 1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GenerateNotification.setAlertnessOptions(fcmJson, notificationBuilder);
        oneSignalNotificationBuilder.compatBuilder = notificationBuilder;
        return oneSignalNotificationBuilder;
    }

    private static void setAlertnessOptions(JSONObject fcmJson, NotificationCompat.Builder notifBuilder) {
        boolean lowDisplayPriority;
        int payloadPriority = fcmJson.optInt("pri", 6);
        int androidPriority = GenerateNotification.convertOSToAndroidPriority(payloadPriority);
        notifBuilder.setPriority(androidPriority);
        boolean bl = lowDisplayPriority = androidPriority < 0;
        if (lowDisplayPriority) {
            return;
        }
        int notificationDefaults = 0;
        if (fcmJson.has("ledc") && fcmJson.optInt("led", 1) == 1) {
            try {
                BigInteger ledColor = new BigInteger(fcmJson.optString("ledc"), 16);
                notifBuilder.setLights(ledColor.intValue(), 2000, 5000);
            }
            catch (Throwable t) {
                notificationDefaults |= 4;
            }
        } else {
            notificationDefaults |= 4;
        }
        if (fcmJson.optInt("vib", 1) == 1) {
            if (fcmJson.has("vib_pt")) {
                long[] vibrationPattern = OSUtils.parseVibrationPattern(fcmJson);
                if (vibrationPattern != null) {
                    notifBuilder.setVibrate(vibrationPattern);
                }
            } else {
                notificationDefaults |= 2;
            }
        }
        if (GenerateNotification.isSoundEnabled(fcmJson)) {
            Uri soundUri = OSUtils.getSoundUri(currentContext, fcmJson.optString("sound", null));
            if (soundUri != null) {
                notifBuilder.setSound(soundUri);
            } else {
                notificationDefaults |= 1;
            }
        }
        notifBuilder.setDefaults(notificationDefaults);
    }

    private static void removeNotifyOptions(NotificationCompat.Builder builder) {
        builder.setOnlyAlertOnce(true).setDefaults(0).setSound(null).setVibrate(null).setTicker(null);
    }

    private static void showNotification(OSNotificationGenerationJob notificationJob) {
        Notification notification;
        int notificationId = notificationJob.getAndroidId();
        JSONObject fcmJson = notificationJob.getJsonPayload();
        String group = fcmJson.optString("grp", null);
        ArrayList<Object> grouplessNotifs = new ArrayList();
        if (Build.VERSION.SDK_INT >= 24) {
            grouplessNotifs = OneSignalNotificationManager.getActiveGrouplessNotifications(currentContext);
            if (group == null && grouplessNotifs.size() >= 3) {
                group = OneSignalNotificationManager.getGrouplessSummaryKey();
                OneSignalNotificationManager.assignGrouplessNotifications(currentContext, grouplessNotifs);
            }
        }
        OneSignalNotificationBuilder oneSignalNotificationBuilder = GenerateNotification.getBaseOneSignalNotificationBuilder(notificationJob);
        NotificationCompat.Builder notifBuilder = oneSignalNotificationBuilder.compatBuilder;
        GenerateNotification.addNotificationActionButtons(fcmJson, notifBuilder, notificationId, null);
        try {
            GenerateNotification.addBackgroundImage(fcmJson, notifBuilder);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not set background notification image!", t);
        }
        GenerateNotification.applyNotificationExtender(notificationJob, notifBuilder);
        if (notificationJob.isRestoring()) {
            GenerateNotification.removeNotifyOptions(notifBuilder);
        }
        int makeRoomFor = 1;
        if (group != null) {
            makeRoomFor = 2;
        }
        NotificationLimitManager.clearOldestOverLimit(currentContext, makeRoomFor);
        if (group != null) {
            GenerateNotification.createGenericPendingIntentsForGroup(notifBuilder, fcmJson, group, notificationId);
            notification = GenerateNotification.createSingleNotificationBeforeSummaryBuilder(notificationJob, notifBuilder);
            if (Build.VERSION.SDK_INT >= 24 && group.equals(OneSignalNotificationManager.getGrouplessSummaryKey())) {
                GenerateNotification.createGrouplessSummaryNotification(notificationJob, grouplessNotifs.size() + 1);
            } else {
                GenerateNotification.createSummaryNotification(notificationJob, oneSignalNotificationBuilder);
            }
        } else {
            notification = GenerateNotification.createGenericPendingIntentsForNotif(notifBuilder, fcmJson, notificationId);
        }
        if (group == null || Build.VERSION.SDK_INT > 17) {
            GenerateNotification.addXiaomiSettings(oneSignalNotificationBuilder, notification);
            NotificationManagerCompat.from((Context)currentContext).notify(notificationId, notification);
        }
    }

    private static Notification createGenericPendingIntentsForNotif(NotificationCompat.Builder notifBuilder, JSONObject gcmBundle, int notificationId) {
        SecureRandom random = new SecureRandom();
        PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra(BUNDLE_KEY_ONESIGNAL_DATA, gcmBundle.toString()));
        notifBuilder.setContentIntent(contentIntent);
        PendingIntent deleteIntent = GenerateNotification.getNewDismissActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDismissIntent(notificationId));
        notifBuilder.setDeleteIntent(deleteIntent);
        return notifBuilder.build();
    }

    private static void createGenericPendingIntentsForGroup(NotificationCompat.Builder notifBuilder, JSONObject gcmBundle, String group, int notificationId) {
        SecureRandom random = new SecureRandom();
        PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra(BUNDLE_KEY_ONESIGNAL_DATA, gcmBundle.toString()).putExtra("grp", group));
        notifBuilder.setContentIntent(contentIntent);
        PendingIntent deleteIntent = GenerateNotification.getNewDismissActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDismissIntent(notificationId).putExtra("grp", group));
        notifBuilder.setDeleteIntent(deleteIntent);
        notifBuilder.setGroup(group);
        try {
            notifBuilder.setGroupAlertBehavior(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void applyNotificationExtender(OSNotificationGenerationJob notificationJob, NotificationCompat.Builder notificationBuilder) {
        if (!notificationJob.hasExtender()) {
            return;
        }
        try {
            Field mNotificationField = NotificationCompat.Builder.class.getDeclaredField("mNotification");
            mNotificationField.setAccessible(true);
            Notification mNotification = (Notification)mNotificationField.get(notificationBuilder);
            notificationJob.setOrgFlags(mNotification.flags);
            notificationJob.setOrgSound(mNotification.sound);
            notificationBuilder.extend(notificationJob.getNotification().getNotificationExtender());
            mNotification = (Notification)mNotificationField.get(notificationBuilder);
            Field mContentTextField = NotificationCompat.Builder.class.getDeclaredField("mContentText");
            mContentTextField.setAccessible(true);
            CharSequence mContentText = (CharSequence)mContentTextField.get(notificationBuilder);
            Field mContentTitleField = NotificationCompat.Builder.class.getDeclaredField("mContentTitle");
            mContentTitleField.setAccessible(true);
            CharSequence mContentTitle = (CharSequence)mContentTitleField.get(notificationBuilder);
            notificationJob.setOverriddenBodyFromExtender(mContentText);
            notificationJob.setOverriddenTitleFromExtender(mContentTitle);
            if (!notificationJob.isRestoring()) {
                notificationJob.setOverriddenFlags(mNotification.flags);
                notificationJob.setOverriddenSound(mNotification.sound);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static Notification createSingleNotificationBeforeSummaryBuilder(OSNotificationGenerationJob notificationJob, NotificationCompat.Builder notifBuilder) {
        boolean singleNotifWorkArounds;
        boolean bl = singleNotifWorkArounds = Build.VERSION.SDK_INT > 17 && Build.VERSION.SDK_INT < 24 && !notificationJob.isRestoring();
        if (singleNotifWorkArounds && notificationJob.getOverriddenSound() != null && !notificationJob.getOverriddenSound().equals((Object)notificationJob.getOrgSound())) {
            notifBuilder.setSound(null);
        }
        Notification notification = notifBuilder.build();
        if (singleNotifWorkArounds) {
            notifBuilder.setSound(notificationJob.getOverriddenSound());
        }
        return notification;
    }

    private static void addXiaomiSettings(OneSignalNotificationBuilder oneSignalNotificationBuilder, Notification notification) {
        if (!oneSignalNotificationBuilder.hasLargeIcon) {
            return;
        }
        try {
            Object miuiNotification = Class.forName("android.app.MiuiNotification").newInstance();
            Field customizedIconField = miuiNotification.getClass().getDeclaredField("customizedIcon");
            customizedIconField.setAccessible(true);
            customizedIconField.set(miuiNotification, true);
            Field extraNotificationField = notification.getClass().getField("extraNotification");
            extraNotificationField.setAccessible(true);
            extraNotificationField.set(notification, miuiNotification);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void updateSummaryNotification(OSNotificationGenerationJob notificationJob) {
        GenerateNotification.setStatics(notificationJob.getContext());
        GenerateNotification.createSummaryNotification(notificationJob, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSummaryNotification(OSNotificationGenerationJob notificationJob, OneSignalNotificationBuilder notifBuilder) {
        Notification summaryNotification;
        boolean updateSummary = notificationJob.isRestoring();
        JSONObject fcmJson = notificationJob.getJsonPayload();
        String group = fcmJson.optString("grp", null);
        SecureRandom random = new SecureRandom();
        PendingIntent summaryDeleteIntent = GenerateNotification.getNewDismissActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDismissIntent(0).putExtra("summary", group));
        Integer summaryNotificationId = null;
        String firstFullData = null;
        ArrayList<SpannableString> summaryList = null;
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(currentContext);
        Cursor cursor = null;
        try {
            String[] retColumn = new String[]{"android_notification_id", "full_data", "is_summary", "title", "message"};
            String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0";
            String[] whereArgs = new String[]{group};
            if (!updateSummary && notificationJob.getAndroidId() != -1) {
                whereStr = whereStr + " AND android_notification_id <> " + notificationJob.getAndroidId();
            }
            if ((cursor = dbHelper.query("notification", retColumn, whereStr, whereArgs, null, null, "_id DESC")).moveToFirst()) {
                summaryList = new ArrayList<SpannableString>();
                do {
                    if (cursor.getInt(cursor.getColumnIndex("is_summary")) == 1) {
                        summaryNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                        continue;
                    }
                    String title = cursor.getString(cursor.getColumnIndex("title"));
                    title = title == null ? "" : title + " ";
                    String msg = cursor.getString(cursor.getColumnIndex("message"));
                    SpannableString spannableString = new SpannableString((CharSequence)(title + msg));
                    if (title.length() > 0) {
                        spannableString.setSpan((Object)new StyleSpan(1), 0, title.length(), 0);
                    }
                    summaryList.add(spannableString);
                    if (firstFullData != null) continue;
                    firstFullData = cursor.getString(cursor.getColumnIndex("full_data"));
                } while (cursor.moveToNext());
                if (updateSummary && firstFullData != null) {
                    try {
                        fcmJson = new JSONObject(firstFullData);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        if (summaryNotificationId == null) {
            summaryNotificationId = random.nextInt();
            GenerateNotification.createSummaryIdDatabaseEntry(dbHelper, group, summaryNotificationId);
        }
        PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.createBaseSummaryIntent(summaryNotificationId, fcmJson, group));
        if (summaryList != null && (updateSummary && summaryList.size() > 1 || !updateSummary && summaryList.size() > 0)) {
            int notificationCount = summaryList.size() + (updateSummary ? 0 : 1);
            String summaryMessage = fcmJson.optString("grp_msg", null);
            summaryMessage = summaryMessage == null ? notificationCount + " new messages" : summaryMessage.replace("$[notif_count]", "" + notificationCount);
            NotificationCompat.Builder summaryBuilder = GenerateNotification.getBaseOneSignalNotificationBuilder((OSNotificationGenerationJob)notificationJob).compatBuilder;
            if (updateSummary) {
                GenerateNotification.removeNotifyOptions(summaryBuilder);
            } else {
                if (notificationJob.getOverriddenSound() != null) {
                    summaryBuilder.setSound(notificationJob.getOverriddenSound());
                }
                if (notificationJob.getOverriddenFlags() != null) {
                    summaryBuilder.setDefaults(notificationJob.getOverriddenFlags().intValue());
                }
            }
            summaryBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setContentTitle(currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo())).setContentText((CharSequence)summaryMessage).setNumber(notificationCount).setSmallIcon(GenerateNotification.getDefaultSmallIconId()).setLargeIcon(GenerateNotification.getDefaultLargeIcon()).setOnlyAlertOnce(updateSummary).setAutoCancel(false).setGroup(group).setGroupSummary(true);
            try {
                summaryBuilder.setGroupAlertBehavior(1);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (!updateSummary) {
                summaryBuilder.setTicker((CharSequence)summaryMessage);
            }
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            if (!updateSummary) {
                String line1Title = null;
                if (notificationJob.getTitle() != null) {
                    line1Title = notificationJob.getTitle().toString();
                }
                line1Title = line1Title == null ? "" : line1Title + " ";
                String message = notificationJob.getBody().toString();
                SpannableString spannableString = new SpannableString((CharSequence)(line1Title + message));
                if (line1Title.length() > 0) {
                    spannableString.setSpan((Object)new StyleSpan(1), 0, line1Title.length(), 0);
                }
                inboxStyle.addLine((CharSequence)spannableString);
            }
            for (SpannableString line : summaryList) {
                inboxStyle.addLine((CharSequence)line);
            }
            inboxStyle.setBigContentTitle((CharSequence)summaryMessage);
            summaryBuilder.setStyle((NotificationCompat.Style)inboxStyle);
            summaryNotification = summaryBuilder.build();
        } else {
            NotificationCompat.Builder summaryBuilder = notifBuilder.compatBuilder;
            summaryBuilder.mActions.clear();
            GenerateNotification.addNotificationActionButtons(fcmJson, summaryBuilder, summaryNotificationId, group);
            summaryBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setOnlyAlertOnce(updateSummary).setAutoCancel(false).setGroup(group).setGroupSummary(true);
            try {
                summaryBuilder.setGroupAlertBehavior(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            summaryNotification = summaryBuilder.build();
            GenerateNotification.addXiaomiSettings(notifBuilder, summaryNotification);
        }
        NotificationManagerCompat.from((Context)currentContext).notify(summaryNotificationId.intValue(), summaryNotification);
    }

    @RequiresApi(api=23)
    private static void createGrouplessSummaryNotification(OSNotificationGenerationJob notificationJob, int grouplessNotifCount) {
        JSONObject fcmJson = notificationJob.getJsonPayload();
        SecureRandom random = new SecureRandom();
        String group = OneSignalNotificationManager.getGrouplessSummaryKey();
        String summaryMessage = grouplessNotifCount + " new messages";
        int summaryNotificationId = OneSignalNotificationManager.getGrouplessSummaryId();
        PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.createBaseSummaryIntent(summaryNotificationId, fcmJson, group));
        PendingIntent summaryDeleteIntent = GenerateNotification.getNewDismissActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDismissIntent(0).putExtra("summary", group));
        NotificationCompat.Builder summaryBuilder = GenerateNotification.getBaseOneSignalNotificationBuilder((OSNotificationGenerationJob)notificationJob).compatBuilder;
        if (notificationJob.getOverriddenSound() != null) {
            summaryBuilder.setSound(notificationJob.getOverriddenSound());
        }
        if (notificationJob.getOverriddenFlags() != null) {
            summaryBuilder.setDefaults(notificationJob.getOverriddenFlags().intValue());
        }
        summaryBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setContentTitle(currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo())).setContentText((CharSequence)summaryMessage).setNumber(grouplessNotifCount).setSmallIcon(GenerateNotification.getDefaultSmallIconId()).setLargeIcon(GenerateNotification.getDefaultLargeIcon()).setOnlyAlertOnce(true).setAutoCancel(false).setGroup(group).setGroupSummary(true);
        try {
            summaryBuilder.setGroupAlertBehavior(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)summaryMessage);
        summaryBuilder.setStyle((NotificationCompat.Style)inboxStyle);
        Notification summaryNotification = summaryBuilder.build();
        NotificationManagerCompat.from((Context)currentContext).notify(summaryNotificationId, summaryNotification);
    }

    private static Intent createBaseSummaryIntent(int summaryNotificationId, JSONObject fcmJson, String group) {
        return GenerateNotification.getNewBaseIntent(summaryNotificationId).putExtra(BUNDLE_KEY_ONESIGNAL_DATA, fcmJson.toString()).putExtra("summary", group);
    }

    private static void createSummaryIdDatabaseEntry(OneSignalDbHelper dbHelper, String group, int id2) {
        ContentValues values = new ContentValues();
        values.put("android_notification_id", Integer.valueOf(id2));
        values.put("group_id", group);
        values.put("is_summary", Integer.valueOf(1));
        dbHelper.insertOrThrow("notification", null, values);
    }

    private static void addBackgroundImage(JSONObject fcmJson, NotificationCompat.Builder notifBuilder) throws Throwable {
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        Bitmap bg_image = null;
        JSONObject jsonBgImage = null;
        String jsonStrBgImage = fcmJson.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            jsonBgImage = new JSONObject(jsonStrBgImage);
            bg_image = GenerateNotification.getBitmap(jsonBgImage.optString("img", null));
        }
        if (bg_image == null) {
            bg_image = GenerateNotification.getBitmapFromAssetsOrResourceName("onesignal_bgimage_default_image");
        }
        if (bg_image != null) {
            RemoteViews customView = new RemoteViews(currentContext.getPackageName(), R.layout.onesignal_bgimage_notif_layout);
            customView.setTextViewText(R.id.os_bgimage_notif_title, GenerateNotification.getTitle(fcmJson));
            customView.setTextViewText(R.id.os_bgimage_notif_body, (CharSequence)fcmJson.optString("alert"));
            GenerateNotification.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_title, "tc", "onesignal_bgimage_notif_title_color");
            GenerateNotification.setTextColor(customView, jsonBgImage, R.id.os_bgimage_notif_body, "bc", "onesignal_bgimage_notif_body_color");
            String alignSetting = null;
            if (jsonBgImage != null && jsonBgImage.has("img_align")) {
                alignSetting = jsonBgImage.getString("img_align");
            } else {
                int iAlignSetting = contextResources.getIdentifier("onesignal_bgimage_notif_image_align", "string", packageName);
                if (iAlignSetting != 0) {
                    alignSetting = contextResources.getString(iAlignSetting);
                }
            }
            if ("right".equals(alignSetting)) {
                customView.setViewPadding(R.id.os_bgimage_notif_bgimage_align_layout, -5000, 0, 0, 0);
                customView.setImageViewBitmap(R.id.os_bgimage_notif_bgimage_right_aligned, bg_image);
                customView.setViewVisibility(R.id.os_bgimage_notif_bgimage_right_aligned, 0);
                customView.setViewVisibility(R.id.os_bgimage_notif_bgimage, 2);
            } else {
                customView.setImageViewBitmap(R.id.os_bgimage_notif_bgimage, bg_image);
            }
            notifBuilder.setContent(customView);
            notifBuilder.setStyle(null);
        }
    }

    private static void setTextColor(RemoteViews customView, JSONObject fcmJson, int viewId, String colorPayloadKey, String colorDefaultResource) {
        Integer color = GenerateNotification.safeGetColorFromHex(fcmJson, colorPayloadKey);
        if (color != null) {
            customView.setTextColor(viewId, color.intValue());
        } else {
            int colorId = contextResources.getIdentifier(colorDefaultResource, "color", packageName);
            if (colorId != 0) {
                customView.setTextColor(viewId, AndroidSupportV4Compat.ContextCompat.getColor(currentContext, colorId));
            }
        }
    }

    private static Integer safeGetColorFromHex(JSONObject fcmJson, String colorKey) {
        try {
            if (fcmJson != null && fcmJson.has(colorKey)) {
                return new BigInteger(fcmJson.optString(colorKey), 16).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Bitmap getLargeIcon(JSONObject fcmJson) {
        Bitmap bitmap = GenerateNotification.getBitmap(fcmJson.optString("licon"));
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        }
        if (bitmap == null) {
            return null;
        }
        return GenerateNotification.resizeBitmapForLargeIconArea(bitmap);
    }

    private static Bitmap getDefaultLargeIcon() {
        Bitmap bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        return GenerateNotification.resizeBitmapForLargeIconArea(bitmap);
    }

    private static Bitmap resizeBitmapForLargeIconArea(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        try {
            int systemLargeIconHeight = (int)contextResources.getDimension(17104902);
            int systemLargeIconWidth = (int)contextResources.getDimension(0x1050005);
            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();
            if (bitmapWidth > systemLargeIconWidth || bitmapHeight > systemLargeIconHeight) {
                int newWidth = systemLargeIconWidth;
                int newHeight = systemLargeIconHeight;
                if (bitmapHeight > bitmapWidth) {
                    float ratio = (float)bitmapWidth / (float)bitmapHeight;
                    newWidth = (int)((float)newHeight * ratio);
                } else if (bitmapWidth > bitmapHeight) {
                    float ratio = (float)bitmapHeight / (float)bitmapWidth;
                    newHeight = (int)((float)newWidth * ratio);
                }
                return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bitmap;
    }

    private static Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bitmap != null) {
                return bitmap;
            }
            List<String> image_extensions = Arrays.asList(".png", ".webp", ".jpg", ".gif", ".bmp");
            for (String extension : image_extensions) {
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bitmap == null) continue;
                return bitmap;
            }
            int bitmapId = GenerateNotification.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)contextResources, (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Could not download image!", t);
            return null;
        }
    }

    private static Bitmap getBitmap(String name) {
        if (name == null) {
            return null;
        }
        String trimmedName = name.trim();
        if (trimmedName.startsWith("http://") || trimmedName.startsWith("https://")) {
            return GenerateNotification.getBitmapFromURL(trimmedName);
        }
        return GenerateNotification.getBitmapFromAssetsOrResourceName(name);
    }

    private static int getResourceIcon(String iconName) {
        if (iconName == null) {
            return 0;
        }
        String trimmedIconName = iconName.trim();
        if (!OSUtils.isValidResourceName(trimmedIconName)) {
            return 0;
        }
        int notificationIcon = GenerateNotification.getDrawableId(trimmedIconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static int getSmallIconId(JSONObject fcmJson) {
        int notificationIcon = GenerateNotification.getResourceIcon(fcmJson.optString("sicon", null));
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return GenerateNotification.getDefaultSmallIconId();
    }

    private static int getDefaultSmallIconId() {
        int notificationIcon = GenerateNotification.getDrawableId("ic_stat_onesignal_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("corona_statusbar_icon_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_os_notification_fallback_white_24dp");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 17301598;
    }

    private static int getDrawableId(String name) {
        return contextResources.getIdentifier(name, "drawable", packageName);
    }

    private static boolean isSoundEnabled(JSONObject fcmJson) {
        String sound = fcmJson.optString("sound", null);
        return !"null".equals(sound) && !"nil".equals(sound);
    }

    private static BigInteger getAccentColor(JSONObject fcmJson) {
        try {
            if (fcmJson.has("bgac")) {
                return new BigInteger(fcmJson.optString("bgac", null), 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String defaultColor = OSUtils.getManifestMeta(currentContext, "com.onesignal.NotificationAccentColor.DEFAULT");
            if (defaultColor != null) {
                return new BigInteger(defaultColor, 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void addNotificationActionButtons(JSONObject fcmJson, NotificationCompat.Builder mBuilder, int notificationId, String groupSummary) {
        try {
            JSONObject customJson = new JSONObject(fcmJson.optString("custom"));
            if (!customJson.has("a")) {
                return;
            }
            JSONObject additionalDataJSON = customJson.getJSONObject("a");
            if (!additionalDataJSON.has("actionButtons")) {
                return;
            }
            JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
            for (int i = 0; i < buttons.length(); ++i) {
                JSONObject button = buttons.optJSONObject(i);
                JSONObject bundle = new JSONObject(fcmJson.toString());
                Intent buttonIntent = GenerateNotification.getNewBaseIntent(notificationId);
                buttonIntent.setAction("" + i);
                buttonIntent.putExtra("action_button", true);
                bundle.put(BUNDLE_KEY_ACTION_ID, (Object)button.optString("id"));
                buttonIntent.putExtra(BUNDLE_KEY_ONESIGNAL_DATA, bundle.toString());
                if (groupSummary != null) {
                    buttonIntent.putExtra("summary", groupSummary);
                } else if (fcmJson.has("grp")) {
                    buttonIntent.putExtra("grp", fcmJson.optString("grp"));
                }
                PendingIntent buttonPIntent = GenerateNotification.getNewActionPendingIntent(notificationId, buttonIntent);
                int buttonIcon = 0;
                if (button.has("icon")) {
                    buttonIcon = GenerateNotification.getResourceIcon(button.optString("icon"));
                }
                mBuilder.addAction(buttonIcon, (CharSequence)button.optString("text"), buttonPIntent);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void addAlertButtons(Context context, JSONObject fcmJson, List<String> buttonsLabels, List<String> buttonsIds) {
        try {
            GenerateNotification.addCustomAlertButtons(fcmJson, buttonsLabels, buttonsIds);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed to parse JSON for custom buttons for alert dialog.", t);
        }
        if (buttonsLabels.size() == 0 || buttonsLabels.size() < 3) {
            buttonsLabels.add(OSUtils.getResourceString(context, "onesignal_in_app_alert_ok_button_text", "Ok"));
            buttonsIds.add("__DEFAULT__");
        }
    }

    private static void addCustomAlertButtons(JSONObject fcmJson, List<String> buttonsLabels, List<String> buttonsIds) throws JSONException {
        JSONObject customJson = new JSONObject(fcmJson.optString("custom"));
        if (!customJson.has("a")) {
            return;
        }
        JSONObject additionalDataJSON = customJson.getJSONObject("a");
        if (!additionalDataJSON.has("actionButtons")) {
            return;
        }
        JSONArray buttons = additionalDataJSON.optJSONArray("actionButtons");
        for (int i = 0; i < buttons.length(); ++i) {
            JSONObject button = buttons.getJSONObject(i);
            buttonsLabels.add(button.optString("text"));
            buttonsIds.add(button.optString("id"));
        }
    }

    private static int convertOSToAndroidPriority(int priority) {
        if (priority > 9) {
            return 2;
        }
        if (priority > 7) {
            return 1;
        }
        if (priority > 4) {
            return 0;
        }
        if (priority > 2) {
            return -1;
        }
        return -2;
    }

    private static class OneSignalNotificationBuilder {
        NotificationCompat.Builder compatBuilder;
        boolean hasLargeIcon;

        private OneSignalNotificationBuilder() {
        }
    }
}

