/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSObservable;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import org.json.JSONObject;

public class OSPermissionState
implements Cloneable {
    OSObservable<Object, OSPermissionState> observable = new OSObservable("changed", false);
    private boolean enabled;

    OSPermissionState(boolean asFrom) {
        if (asFrom) {
            this.enabled = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", false);
        } else {
            this.refreshAsTo();
        }
    }

    void refreshAsTo() {
        this.setEnabled(OSUtils.areNotificationsEnabled(OneSignal.appContext));
    }

    public boolean areNotificationsEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean set) {
        boolean changed = this.enabled != set;
        this.enabled = set;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    void persistAsFrom() {
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", this.enabled);
    }

    boolean compare(OSPermissionState from) {
        return this.enabled != from.enabled;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("areNotificationsEnabled", this.enabled);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

