/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.onesignal.GenerateNotification;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSNotificationRestoreWorkManager;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDb;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationSummaryManager {
    NotificationSummaryManager() {
    }

    static void updatePossibleDependentSummaryOnDismiss(Context context, OneSignalDb db, int androidNotificationId) {
        Cursor cursor = db.query("notification", new String[]{"group_id"}, "android_notification_id = " + androidNotificationId, null, null, null, null);
        if (cursor.moveToFirst()) {
            String group = cursor.getString(cursor.getColumnIndex("group_id"));
            cursor.close();
            if (group != null) {
                NotificationSummaryManager.updateSummaryNotificationAfterChildRemoved(context, db, group, true);
            }
        } else {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateSummaryNotificationAfterChildRemoved(Context context, OneSignalDb db, String group, boolean dismissed) {
        Cursor cursor = null;
        try {
            cursor = NotificationSummaryManager.internalUpdateSummaryNotificationAfterChildRemoved(context, db, group, dismissed);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error running updateSummaryNotificationAfterChildRemoved!", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    private static Cursor internalUpdateSummaryNotificationAfterChildRemoved(Context context, OneSignalDb db, String group, boolean dismissed) {
        Cursor cursor = db.query("notification", new String[]{"android_notification_id", "created_time"}, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", new String[]{group}, null, null, "_id DESC");
        int notificationsInGroup = cursor.getCount();
        if (notificationsInGroup == 0) {
            cursor.close();
            Integer androidNotifId = NotificationSummaryManager.getSummaryNotificationId(db, group);
            if (androidNotifId == null) {
                return cursor;
            }
            NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(context);
            notificationManager.cancel(androidNotifId.intValue());
            ContentValues values = new ContentValues();
            values.put(dismissed ? "dismissed" : "opened", Integer.valueOf(1));
            db.update("notification", values, "android_notification_id = " + androidNotifId, null);
            return cursor;
        }
        if (notificationsInGroup == 1) {
            cursor.close();
            Integer androidNotifId = NotificationSummaryManager.getSummaryNotificationId(db, group);
            if (androidNotifId == null) {
                return cursor;
            }
            NotificationSummaryManager.restoreSummary(context, group);
            return cursor;
        }
        try {
            cursor.moveToFirst();
            Long datetime = cursor.getLong(cursor.getColumnIndex("created_time"));
            cursor.close();
            Integer androidNotifId = NotificationSummaryManager.getSummaryNotificationId(db, group);
            if (androidNotifId == null) {
                return cursor;
            }
            OSNotificationGenerationJob notificationJob = new OSNotificationGenerationJob(context);
            notificationJob.setRestoring(true);
            notificationJob.setShownTimeStamp(datetime);
            JSONObject payload = new JSONObject();
            payload.put("grp", (Object)group);
            notificationJob.setJsonPayload(payload);
            GenerateNotification.updateSummaryNotification(notificationJob);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreSummary(Context context, String group) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        Cursor cursor = null;
        String[] whereArgs = new String[]{group};
        try {
            cursor = dbHelper.query("notification", OSNotificationRestoreWorkManager.COLUMNS_FOR_RESTORE, "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 0", whereArgs, null, null, null);
            OSNotificationRestoreWorkManager.showNotificationsFromCursor(context, cursor, 0);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer getSummaryNotificationId(OneSignalDb db, String group) {
        Integer androidNotifId = null;
        Cursor cursor = null;
        String whereStr = "group_id = ? AND dismissed = 0 AND opened = 0 AND is_summary = 1";
        String[] whereArgs = new String[]{group};
        try {
            cursor = db.query("notification", new String[]{"android_notification_id"}, whereStr, whereArgs, null, null, null);
            boolean hasRecord = cursor.moveToFirst();
            if (!hasRecord) {
                cursor.close();
                Integer n = null;
                return n;
            }
            androidNotifId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
            cursor.close();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error getting android notification id for summary notification group: " + group, t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return androidNotifId;
    }

    static void clearNotificationOnSummaryClick(Context context, OneSignalDbHelper dbHelper, String group) {
        Integer groupId = NotificationSummaryManager.getSummaryNotificationId(dbHelper, group);
        boolean isGroupless = group.equals(OneSignalNotificationManager.getGrouplessSummaryKey());
        NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(context);
        Integer mostRecentId = OneSignalNotificationManager.getMostRecentNotifIdFromGroup(dbHelper, group, isGroupless);
        if (mostRecentId != null) {
            boolean shouldDismissAll = OneSignal.getClearGroupSummaryClick();
            if (shouldDismissAll) {
                if (isGroupless) {
                    groupId = OneSignalNotificationManager.getGrouplessSummaryId();
                }
                if (groupId != null) {
                    notificationManager.cancel(groupId.intValue());
                }
            } else {
                OneSignal.cancelNotification(mostRecentId);
            }
        }
    }
}

