/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.OneSignal;
import java.util.HashMap;
import java.util.Set;

class OneSignalPrefs {
    public static final String PREFS_ONESIGNAL = OneSignal.class.getSimpleName();
    public static final String PREFS_PLAYER_PURCHASES = "GTPlayerPurchases";
    public static final String PREFS_TRIGGERS = "OneSignalTriggers";
    public static final String PREFS_OS_LAST_LOCATION_TIME = "OS_LAST_LOCATION_TIME";
    public static final String PREFS_GT_SOUND_ENABLED = "GT_SOUND_ENABLED";
    public static final String PREFS_OS_LAST_SESSION_TIME = "OS_LAST_SESSION_TIME";
    public static final String PREFS_GT_VIBRATE_ENABLED = "GT_VIBRATE_ENABLED";
    public static final String PREFS_OS_FILTER_OTHER_GCM_RECEIVERS = "OS_FILTER_OTHER_GCM_RECEIVERS";
    public static final String PREFS_GT_APP_ID = "GT_APP_ID";
    public static final String PREFS_GT_PLAYER_ID = "GT_PLAYER_ID";
    public static final String PREFS_GT_UNSENT_ACTIVE_TIME = "GT_UNSENT_ACTIVE_TIME";
    public static final String PREFS_OS_UNSENT_ATTRIBUTED_ACTIVE_TIME = "OS_UNSENT_ATTRIBUTED_ACTIVE_TIME";
    public static final String PREFS_ONESIGNAL_USERSTATE_DEPENDVALYES_ = "ONESIGNAL_USERSTATE_DEPENDVALYES_";
    public static final String PREFS_ONESIGNAL_USERSTATE_SYNCVALYES_ = "ONESIGNAL_USERSTATE_SYNCVALYES_";
    public static final String PREFS_ONESIGNAL_ACCEPTED_NOTIFICATION_LAST = "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST";
    public static final String PREFS_ONESIGNAL_SUBSCRIPTION_LAST = "ONESIGNAL_SUBSCRIPTION_LAST";
    public static final String PREFS_ONESIGNAL_PLAYER_ID_LAST = "ONESIGNAL_PLAYER_ID_LAST";
    public static final String PREFS_ONESIGNAL_PUSH_TOKEN_LAST = "ONESIGNAL_PUSH_TOKEN_LAST";
    public static final String PREFS_ONESIGNAL_PERMISSION_ACCEPTED_LAST = "ONESIGNAL_PERMISSION_ACCEPTED_LAST";
    public static final String PREFS_GT_DO_NOT_SHOW_MISSING_GPS = "GT_DO_NOT_SHOW_MISSING_GPS";
    public static final String PREFS_ONESIGNAL_SUBSCRIPTION = "ONESIGNAL_SUBSCRIPTION";
    public static final String PREFS_ONESIGNAL_SYNCED_SUBSCRIPTION = "ONESIGNAL_SYNCED_SUBSCRIPTION";
    public static final String PREFS_GT_REGISTRATION_ID = "GT_REGISTRATION_ID";
    public static final String PREFS_ONESIGNAL_USER_PROVIDED_CONSENT = "ONESIGNAL_USER_PROVIDED_CONSENT";
    public static final String PREFS_OS_ETAG_PREFIX = "PREFS_OS_ETAG_PREFIX_";
    public static final String PREFS_OS_HTTP_CACHE_PREFIX = "PREFS_OS_HTTP_CACHE_PREFIX_";
    public static final String PREFS_GT_FIREBASE_TRACKING_ENABLED = "GT_FIREBASE_TRACKING_ENABLED";
    public static final String PREFS_OS_RESTORE_TTL_FILTER = "OS_RESTORE_TTL_FILTER";
    public static final String PREFS_OS_CLEAR_GROUP_SUMMARY_CLICK = "OS_CLEAR_GROUP_SUMMARY_CLICK";
    public static final String PREFS_OS_UNSUBSCRIBE_WHEN_NOTIFICATIONS_DISABLED = "PREFS_OS_UNSUBSCRIBE_WHEN_NOTIFICATIONS_DISABLED";
    public static final String PREFS_OS_DISABLE_GMS_MISSING_PROMPT = "PREFS_OS_DISABLE_GMS_MISSING_PROMPT";
    public static final String PREFS_OS_REQUIRES_USER_PRIVACY_CONSENT = "PREFS_OS_REQUIRES_USER_PRIVACY_CONSENT";
    public static final String PREFS_OS_LOCATION_SHARED = "PREFS_OS_LOCATION_SHARED";
    public static final String PREFS_OS_RECEIVE_RECEIPTS_ENABLED = "PREFS_OS_RECEIVE_RECEIPTS_ENABLED";
    static final String PREFS_OS_OUTCOMES_V2 = "PREFS_OS_OUTCOMES_V2";
    public static final String PREFS_OS_ATTRIBUTED_INFLUENCES = "PREFS_OS_ATTRIBUTED_INFLUENCES";
    public static final String PREFS_OS_EMAIL_ID = "OS_EMAIL_ID";
    public static final String PREFS_ONESIGNAL_EMAIL_ID_LAST = "PREFS_ONESIGNAL_EMAIL_ID_LAST";
    public static final String PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST = "PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST";
    public static final String PREFS_OS_CACHED_IAMS = "PREFS_OS_CACHED_IAMS";
    public static final String PREFS_OS_DISMISSED_IAMS = "PREFS_OS_DISPLAYED_IAMS";
    public static final String PREFS_OS_IMPRESSIONED_IAMS = "PREFS_OS_IMPRESSIONED_IAMS";
    public static final String PREFS_OS_CLICKED_CLICK_IDS_IAMS = "PREFS_OS_CLICKED_CLICK_IDS_IAMS";
    static final String PREFS_PURCHASE_TOKENS = "purchaseTokens";
    static final String PREFS_EXISTING_PURCHASES = "ExistingPurchases";
    static HashMap<String, HashMap<String, Object>> prefsToApply;
    public static WritePrefHandlerThread prefsHandler;

    OneSignalPrefs() {
    }

    public static void initializePool() {
        prefsToApply = new HashMap();
        prefsToApply.put(PREFS_ONESIGNAL, new HashMap());
        prefsToApply.put(PREFS_PLAYER_PURCHASES, new HashMap());
        prefsToApply.put(PREFS_TRIGGERS, new HashMap());
        prefsHandler = new WritePrefHandlerThread("OSH_WritePrefs");
    }

    public static void startDelayedWrite() {
        OneSignalPrefs.prefsHandler.startDelayedWrite();
    }

    public static void saveString(String prefsName, String key, String value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    public static void saveStringSet(@NonNull String prefsName, @NonNull String key, @NonNull Set<String> value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    public static void saveBool(String prefsName, String key, boolean value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    public static void saveInt(String prefsName, String key, int value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    public static void saveLong(String prefsName, String key, long value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    public static void saveObject(String prefsName, String key, Object value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(String prefsName, String key, Object value) {
        HashMap<String, Object> pref;
        HashMap<String, Object> hashMap = pref = prefsToApply.get(prefsName);
        synchronized (hashMap) {
            pref.put(key, value);
        }
        OneSignalPrefs.startDelayedWrite();
    }

    static String getString(String prefsName, String key, String defValue) {
        return (String)OneSignalPrefs.get(prefsName, key, String.class, defValue);
    }

    static boolean getBool(String prefsName, String key, boolean defValue) {
        return (Boolean)OneSignalPrefs.get(prefsName, key, Boolean.class, defValue);
    }

    static int getInt(String prefsName, String key, int defValue) {
        return (Integer)OneSignalPrefs.get(prefsName, key, Integer.class, defValue);
    }

    static long getLong(String prefsName, String key, long defValue) {
        return (Long)OneSignalPrefs.get(prefsName, key, Long.class, defValue);
    }

    @Nullable
    public static Set<String> getStringSet(@NonNull String prefsName, @NonNull String key, @Nullable Set<String> defValue) {
        return (Set)OneSignalPrefs.get(prefsName, key, Set.class, defValue);
    }

    static Object getObject(String prefsName, String key, Object defValue) {
        return OneSignalPrefs.get(prefsName, key, Object.class, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Object get(String prefsName, String key, Class type, Object defValue) {
        HashMap<String, Object> pref;
        HashMap<String, Object> hashMap = pref = prefsToApply.get(prefsName);
        synchronized (hashMap) {
            if (type.equals(Object.class) && pref.containsKey(key)) {
                return true;
            }
            Object cachedValue = pref.get(key);
            if (cachedValue != null || pref.containsKey(key)) {
                return cachedValue;
            }
        }
        SharedPreferences prefs = OneSignalPrefs.getSharedPrefsByName(prefsName);
        if (prefs != null) {
            if (type.equals(String.class)) {
                return prefs.getString(key, (String)defValue);
            }
            if (type.equals(Boolean.class)) {
                return prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
            }
            if (type.equals(Integer.class)) {
                return prefs.getInt(key, ((Integer)defValue).intValue());
            }
            if (type.equals(Long.class)) {
                return prefs.getLong(key, ((Long)defValue).longValue());
            }
            if (type.equals(Set.class)) {
                return prefs.getStringSet(key, (Set)defValue);
            }
            if (type.equals(Object.class)) {
                return prefs.contains(key);
            }
            return null;
        }
        return defValue;
    }

    static synchronized SharedPreferences getSharedPrefsByName(String prefsName) {
        if (OneSignal.appContext == null) {
            String msg = "OneSignal.appContext null, could not read " + prefsName + " from getSharedPreferences.";
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, msg, new Throwable());
            return null;
        }
        return OneSignal.appContext.getSharedPreferences(prefsName, 0);
    }

    static {
        OneSignalPrefs.initializePool();
    }

    public static class WritePrefHandlerThread
    extends HandlerThread {
        @Nullable
        private Handler mHandler;
        private static final int WRITE_CALL_DELAY_TO_BUFFER_MS = 200;
        private long lastSyncTime = 0L;
        private boolean threadStartCalled;

        WritePrefHandlerThread(String name) {
            super(name);
        }

        protected void onLooperPrepared() {
            super.onLooperPrepared();
            this.mHandler = new Handler(this.getLooper());
            this.scheduleFlushToDisk();
        }

        private synchronized void startDelayedWrite() {
            if (OneSignal.appContext == null) {
                return;
            }
            this.startThread();
            this.scheduleFlushToDisk();
        }

        private void startThread() {
            if (this.threadStartCalled) {
                return;
            }
            this.start();
            this.threadStartCalled = true;
        }

        private synchronized void scheduleFlushToDisk() {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.lastSyncTime == 0L) {
                this.lastSyncTime = OneSignal.getTime().getCurrentTimeMillis();
            }
            long delay = this.lastSyncTime - OneSignal.getTime().getCurrentTimeMillis() + 200L;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WritePrefHandlerThread.this.flushBufferToDisk();
                }
            };
            this.mHandler.postDelayed(runnable, delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushBufferToDisk() {
            for (String pref : prefsToApply.keySet()) {
                HashMap<String, Object> prefHash;
                SharedPreferences prefsToWrite = OneSignalPrefs.getSharedPrefsByName(pref);
                SharedPreferences.Editor editor = prefsToWrite.edit();
                HashMap<String, Object> hashMap = prefHash = prefsToApply.get(pref);
                synchronized (hashMap) {
                    for (String key : prefHash.keySet()) {
                        Object value = prefHash.get(key);
                        if (value instanceof String) {
                            editor.putString(key, (String)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            editor.putBoolean(key, ((Boolean)value).booleanValue());
                            continue;
                        }
                        if (value instanceof Integer) {
                            editor.putInt(key, ((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            editor.putLong(key, ((Long)value).longValue());
                            continue;
                        }
                        if (!(value instanceof Set)) continue;
                        editor.putStringSet(key, (Set)value);
                    }
                    prefHash.clear();
                }
                editor.apply();
            }
            this.lastSyncTime = OneSignal.getTime().getCurrentTimeMillis();
        }
    }
}

