/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.OneSignalSyncUtils;

public class SyncService
extends Service {
    static final int TASK_APP_STARTUP = 0;
    static final int TASK_SYNC = 1;
    private static boolean startedFromActivity;

    private void doSync() {
        if (startedFromActivity) {
            this.doForegroundSync();
        } else {
            OneSignalSyncUtils.doBackgroundSync(this.getApplicationContext(), new OneSignalSyncUtils.LegacySyncRunnable(this));
        }
    }

    private void doForegroundSync() {
        LocationGMS.getLocation((Context)this, false, new LocationGMS.LocationHandler(){

            @Override
            public void complete(LocationGMS.LocationPoint point) {
                if (point != null) {
                    OneSignalStateSynchronizer.updateLocation(point);
                }
            }
        });
    }

    public void onCreate() {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int task = intent != null ? intent.getIntExtra("task", 0) : 1;
        if (task == 0) {
            startedFromActivity = true;
        } else if (task == 1) {
            this.doSync();
        }
        return startedFromActivity ? 1 : 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        SyncService.onTaskRemoved(this);
    }

    static void onTaskRemoved(Service service) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Starting SyncService:onTaskRemoved.");
        ActivityLifecycleHandler.focusHandlerThread.stopScheduledRunnable();
        boolean scheduleServerRestart = OneSignalStateSynchronizer.stopAndPersist();
        scheduleServerRestart = OneSignal.onAppLostFocus(true) || scheduleServerRestart;
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Completed SyncService:onTaskRemoved.");
        service.stopSelf();
        if (scheduleServerRestart) {
            OneSignalSyncUtils.scheduleSyncTask((Context)service, System.currentTimeMillis() + 10000L);
        } else {
            LocationGMS.scheduleUpdate((Context)service);
        }
    }
}

