/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.os.Bundle;
import com.onesignal.OSNotificationOpenResult;
import com.onesignal.OSNotificationPayload;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;

class TrackFirebaseAnalytics {
    private static boolean firebaseAnalyticsEnabled = false;
    private static Class<?> FirebaseAnalyticsClass;
    private Object mFirebaseAnalyticsInstance;
    private Context appContext;
    private static AtomicLong lastReceivedTime;
    private static OSNotificationPayload lastReceivedPayload;
    private static final String EVENT_NOTIFICATION_OPENED = "os_notification_opened";
    private static final String EVENT_NOTIFICATION_INFLUENCE_OPEN = "os_notification_influence_open";
    private static final String EVENT_NOTIFICATION_RECEIVED = "os_notification_received";

    TrackFirebaseAnalytics(Context activity) {
        this.appContext = activity;
    }

    static boolean CanTrack(Context context) {
        try {
            FirebaseAnalyticsClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            firebaseAnalyticsEnabled = true;
            return firebaseAnalyticsEnabled;
        }
        catch (Throwable t) {
            firebaseAnalyticsEnabled = false;
            return firebaseAnalyticsEnabled;
        }
        finally {
            return firebaseAnalyticsEnabled;
        }
    }

    void trackInfluenceOpenEvent() {
        try {
            long currentTime = System.currentTimeMillis();
            if (lastReceivedTime != null && currentTime - lastReceivedTime.get() < 120000L && lastReceivedPayload != null) {
                Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
                Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
                String event = EVENT_NOTIFICATION_INFLUENCE_OPEN;
                Bundle bundle = new Bundle();
                bundle.putString("source", "OneSignal");
                bundle.putString("medium", "notification");
                bundle.putString("notification_id", TrackFirebaseAnalytics.lastReceivedPayload.notificationID);
                bundle.putString("campaign", this.getCampaignNameFromPayload(lastReceivedPayload));
                trackMethod.invoke(firebaseAnalyticsInstance, event, bundle);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void trackOpenedEvent(OSNotificationOpenResult openResult) {
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
            Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", openResult.notification.payload.notificationID);
            bundle.putString("campaign", this.getCampaignNameFromPayload(openResult.notification.payload));
            trackMethod.invoke(firebaseAnalyticsInstance, EVENT_NOTIFICATION_OPENED, bundle);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void trackReceivedEvent(OSNotificationOpenResult receivedResult) {
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance(this.appContext);
            Method trackMethod = TrackFirebaseAnalytics.getTrackMethod(FirebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", receivedResult.notification.payload.notificationID);
            bundle.putString("campaign", this.getCampaignNameFromPayload(receivedResult.notification.payload));
            trackMethod.invoke(firebaseAnalyticsInstance, EVENT_NOTIFICATION_RECEIVED, bundle);
            if (lastReceivedTime == null) {
                lastReceivedTime = new AtomicLong();
            }
            lastReceivedTime.set(System.currentTimeMillis());
            lastReceivedPayload = receivedResult.notification.payload;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getCampaignNameFromPayload(OSNotificationPayload payload) {
        String campaign = !payload.templateName.isEmpty() && !payload.templateId.isEmpty() ? payload.templateName + " - " + payload.templateId : payload.title.substring(0, Math.min(10, payload.title.length()));
        return campaign;
    }

    private Object getFirebaseAnalyticsInstance(Context context) {
        if (this.mFirebaseAnalyticsInstance == null) {
            Method getInstanceMethod = TrackFirebaseAnalytics.getInstanceMethod(FirebaseAnalyticsClass);
            try {
                this.mFirebaseAnalyticsInstance = getInstanceMethod.invoke(null, context);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.mFirebaseAnalyticsInstance;
    }

    private static Method getTrackMethod(Class clazz) {
        try {
            return clazz.getMethod("logEvent", String.class, Bundle.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method getInstanceMethod(Class clazz) {
        try {
            return clazz.getMethod("getInstance", Context.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }
}

