/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.NotificationManagerCompat;
import android.telephony.TelephonyManager;
import com.onesignal.OneSignal;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSUtils {
    static final int UNINITIALIZABLE_STATUS = -999;

    OSUtils() {
    }

    int initializationChecker(Context context, int deviceType, String oneSignalAppId) {
        int subscribableStatus = 1;
        try {
            UUID.fromString(oneSignalAppId);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "OneSignal AppId format is invalid.\nExample: 'b2f7f966-d8cc-11e4-bed1-df8f05be55ba'\n", t);
            return -999;
        }
        if ("b2f7f966-d8cc-11e4-bed1-df8f05be55ba".equals(oneSignalAppId) || "5eb5a37e-b458-11e3-ac11-000c2940e62c".equals(oneSignalAppId)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OneSignal Example AppID detected, please update to your app's id found on OneSignal.com");
        }
        if (deviceType == 1) {
            try {
                Class.forName("com.google.android.gms.gcm.GoogleCloudMessaging");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The GCM Google Play services client library was not found. Please make sure to include it in your project.", e);
                subscribableStatus = -4;
            }
            try {
                Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The GooglePlayServicesUtil class part of Google Play services client library was not found. Include this in your project.", e);
                subscribableStatus = -4;
            }
        }
        try {
            Class.forName("android.support.v4.view.MenuCompat");
            try {
                Class.forName("android.support.v4.content.WakefulBroadcastReceiver");
                Class.forName("android.support.v4.app.NotificationManagerCompat");
                if (Build.VERSION.SDK_INT >= 26 && OSUtils.getTargetSdkVersion(context) >= 26) {
                    Class.forName("android.support.v4.app.JobIntentService");
                }
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The included Android Support Library is to old or incomplete. Please update to the 26.0.0 revision or newer.", e);
                subscribableStatus = -5;
            }
        }
        catch (ClassNotFoundException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Could not find the Android Support Library. Please make sure it has been correctly added to your project.", e);
            subscribableStatus = -3;
        }
        return subscribableStatus;
    }

    int getDeviceType() {
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            return 2;
        }
        catch (ClassNotFoundException e) {
            return 1;
        }
    }

    Integer getNetType() {
        ConnectivityManager cm = (ConnectivityManager)OneSignal.appContext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo != null) {
            int networkType = netInfo.getType();
            if (networkType == 1 || networkType == 9) {
                return 0;
            }
            return 1;
        }
        return null;
    }

    String getCarrierName() {
        TelephonyManager manager = (TelephonyManager)OneSignal.appContext.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        return "".equals(carrierName) ? null : carrierName;
    }

    static String getManifestMeta(Context context, String metaName) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString(metaName);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "", t);
            return null;
        }
    }

    static String getResourceString(Context context, String key, String defaultStr) {
        Resources resources = context.getResources();
        int bodyResId = resources.getIdentifier(key, "string", context.getPackageName());
        if (bodyResId != 0) {
            return resources.getString(bodyResId);
        }
        return defaultStr;
    }

    static String getCorrectedLanguage() {
        String lang = Locale.getDefault().getLanguage();
        if (lang.equals("iw")) {
            return "he";
        }
        if (lang.equals("in")) {
            return "id";
        }
        if (lang.equals("ji")) {
            return "yi";
        }
        if (lang.equals("zh")) {
            return lang + "-" + Locale.getDefault().getCountry();
        }
        return lang;
    }

    static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        String emRegex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern pattern = Pattern.compile(emRegex);
        return pattern.matcher(email).matches();
    }

    static boolean areNotificationsEnabled(Context context) {
        try {
            return NotificationManagerCompat.from((Context)OneSignal.appContext).areNotificationsEnabled();
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    static void runOnMainUIThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    static int getTargetSdkVersion(Context context) {
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            return applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 15;
        }
    }

    static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    static Uri getSoundUri(Context context, String sound) {
        int soundId;
        Resources resources = context.getResources();
        String packageName = context.getPackageName();
        if (OSUtils.isValidResourceName(sound) && (soundId = resources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = resources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    static long[] parseVibrationPattern(JSONObject gcmBundle) {
        try {
            Object patternObj = gcmBundle.opt("vib_pt");
            JSONArray jsonVibArray = patternObj instanceof String ? new JSONArray((String)patternObj) : (JSONArray)patternObj;
            long[] longArray = new long[jsonVibArray.length()];
            for (int i = 0; i < jsonVibArray.length(); ++i) {
                longArray[i] = jsonVibArray.optLong(i);
            }
            return longArray;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }
}

