/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationExtenderService;
import com.onesignal.NotificationRestoreService;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.io.Serializable;

class NotificationRestorer {
    static final String[] COLUMNS_FOR_RESTORE = new String[]{"android_notification_id", "full_data", "created_time"};
    public static boolean restored;

    NotificationRestorer() {
    }

    static void asyncRestore(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NotificationRestorer.restore(context);
            }
        }, "OS_RESTORE_NOTIFS").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(Context context) {
        if (restored) {
            return;
        }
        restored = true;
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase writableDb = null;
        try {
            writableDb = dbHelper.getWritableDbWithRetries();
            writableDb.beginTransaction();
            NotificationBundleProcessor.deleteOldNotifications(writableDb);
            writableDb.setTransactionSuccessful();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error deleting old notification records! ", t);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                }
            }
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("notification", COLUMNS_FOR_RESTORE, "created_time > " + (System.currentTimeMillis() / 1000L - 604800L) + " AND " + "dismissed" + " = 0 AND " + "opened" + " = 0 AND " + "is_summary" + " = 0", null, null, null, "_id ASC");
            NotificationRestorer.showNotifications(context, cursor);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    static void showNotifications(Context context, Cursor cursor) {
        if (cursor.moveToFirst()) {
            boolean useExtender = NotificationExtenderService.getIntent(context) != null;
            do {
                int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                String fullData = cursor.getString(cursor.getColumnIndex("full_data"));
                Long datetime = cursor.getLong(cursor.getColumnIndex("created_time"));
                Intent serviceIntent = useExtender ? NotificationExtenderService.getIntent(context) : new Intent().setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
                serviceIntent.putExtra("json_payload", fullData);
                serviceIntent.putExtra("android_notif_id", existingId);
                serviceIntent.putExtra("restoring", true);
                serviceIntent.putExtra("timestamp", (Serializable)datetime);
                NotificationRestorer.startService(context, serviceIntent);
            } while (cursor.moveToNext());
        }
    }

    private static void startService(Context context, Intent intent) {
        context.startService(intent);
    }

    static void startRestoreTaskFromReceiver(Context context) {
        if (Build.VERSION.SDK_INT < 26) {
            Intent intentForService = new Intent();
            intentForService.setComponent(new ComponentName(context.getPackageName(), NotificationRestoreService.class.getName()));
            WakefulBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
        }
    }
}

