/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.SharedPreferences;
import com.onesignal.OSObservable;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import org.json.JSONObject;

public class OSPermissionState
implements Cloneable {
    OSObservable<Object, OSPermissionState> observable = new OSObservable("changed", false);
    private boolean enabled;

    OSPermissionState(boolean asFrom) {
        if (asFrom) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(OneSignal.appContext);
            this.enabled = prefs.getBoolean("ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", false);
        } else {
            this.refreshAsTo();
        }
    }

    void refreshAsTo() {
        this.setEnabled(OSUtils.areNotificationsEnabled(OneSignal.appContext));
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean set) {
        boolean changed = this.enabled != set;
        this.enabled = set;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    void persistAsFrom() {
        SharedPreferences prefs = OneSignal.getGcmPreferences(OneSignal.appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", this.enabled);
        editor.apply();
    }

    boolean compare(OSPermissionState from) {
        return this.enabled != from.enabled;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("enabled", this.enabled);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

