/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.onesignal.OneSignal;
import java.util.Random;

class OneSignalChromeTab {
    private static boolean opened;

    OneSignalChromeTab() {
    }

    static void setup(Context context, String appId, String userId, String adId) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        if (opened) {
            return;
        }
        if (OneSignal.mEnterp) {
            return;
        }
        if (userId == null) {
            return;
        }
        try {
            Class.forName("android.support.customtabs.CustomTabsServiceConnection");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        String params = "?app_id=" + appId + "&user_id=" + userId;
        if (adId != null) {
            params = params + "&ad_id=" + adId;
        }
        params = params + "&cbs_id=" + new Random().nextInt(Integer.MAX_VALUE);
        OneSignalCustomTabsServiceConnection connection = new OneSignalCustomTabsServiceConnection(context, params);
        opened = CustomTabsClient.bindCustomTabsService((Context)context, (String)"com.android.chrome", (CustomTabsServiceConnection)connection);
    }

    private static class OneSignalCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private Context mContext;
        private String mParams;

        OneSignalCustomTabsServiceConnection(Context context, String params) {
            this.mContext = context;
            this.mParams = params;
        }

        public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient customTabsClient) {
            if (customTabsClient == null) {
                return;
            }
            customTabsClient.warmup(0L);
            CustomTabsSession session = customTabsClient.newSession(new CustomTabsCallback(){

                public void onNavigationEvent(int navigationEvent, Bundle extras) {
                    super.onNavigationEvent(navigationEvent, extras);
                }

                public void extraCallback(String callbackName, Bundle args) {
                    super.extraCallback(callbackName, args);
                }
            });
            if (session == null) {
                return;
            }
            Uri uri = Uri.parse((String)("https://onesignal.com/android_frame.html" + this.mParams));
            session.mayLaunchUrl(uri, null, null);
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }
}

