/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import com.onesignal.OneSignal;
import com.onesignal.shortcutbadger.ShortcutBadger;

class BadgeCountUpdater {
    private static int badgesEnabled = -1;

    BadgeCountUpdater() {
    }

    private static boolean isBadgesEnabled(Context context) {
        if (badgesEnabled != -1) {
            return badgesEnabled == 1;
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String defaultStr = bundle.getString("com.onesignal.BadgeCount");
            badgesEnabled = "DISABLE".equals(defaultStr) ? 0 : 1;
        }
        catch (Throwable t) {
            badgesEnabled = 1;
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "", t);
        }
        return badgesEnabled == 1;
    }

    static void update(SQLiteDatabase readableDb, Context context) {
        if (!BadgeCountUpdater.isBadgesEnabled(context)) {
            return;
        }
        Cursor cursor = readableDb.query("notification", null, "dismissed = 0 AND opened = 0 AND is_summary = 0 ", null, null, null, null);
        BadgeCountUpdater.updateCount(cursor.getCount(), context);
        cursor.close();
    }

    static void updateCount(int count, Context context) {
        if (!BadgeCountUpdater.isBadgesEnabled(context)) {
            return;
        }
        try {
            ShortcutBadger.applyCountOrThrow(context, count);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

