/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence;

import android.support.annotation.NonNull;
import com.onesignal.OSLogger;
import com.onesignal.influence.OSChannelTracker;
import com.onesignal.influence.OSInfluenceDataRepository;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.influence.model.OSInfluenceChannel;
import com.onesignal.influence.model.OSInfluenceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSNotificationTracker
extends OSChannelTracker {
    public static final String TAG = OSNotificationTracker.class.getCanonicalName();
    private static final String DIRECT_TAG = "direct";
    private static final String NOTIFICATIONS_IDS = "notification_ids";
    private static final String NOTIFICATION_ID = "notification_id";

    OSNotificationTracker(@NonNull OSInfluenceDataRepository dataRepository, OSLogger logger) {
        super(dataRepository, logger);
    }

    @Override
    public String getIdTag() {
        return NOTIFICATION_ID;
    }

    @Override
    JSONArray getLastChannelObjectsReceivedByNewId(String id2) {
        try {
            return this.getLastChannelObjects();
        }
        catch (JSONException exception) {
            this.logger.error("Generating Notification tracker getLastChannelObjects JSONObject ", exception);
            return new JSONArray();
        }
    }

    @Override
    JSONArray getLastChannelObjects() throws JSONException {
        return this.dataRepository.getLastNotificationsReceivedData();
    }

    @Override
    OSInfluenceChannel getChannelType() {
        return OSInfluenceChannel.NOTIFICATION;
    }

    @Override
    int getChannelLimit() {
        return this.dataRepository.getNotificationLimit();
    }

    @Override
    int getIndirectAttributionWindow() {
        return this.dataRepository.getNotificationIndirectAttributionWindow();
    }

    @Override
    void saveChannelObjects(JSONArray channelObjects) {
        this.dataRepository.saveNotifications(channelObjects);
    }

    @Override
    void initInfluencedTypeFromCache() {
        OSInfluenceType influenceType = this.dataRepository.getNotificationCachedInfluenceType();
        this.setInfluenceType(influenceType);
        if (influenceType.isIndirect()) {
            this.setIndirectIds(this.getLastReceivedIds());
        } else if (influenceType.isDirect()) {
            this.setDirectId(this.dataRepository.getCachedNotificationOpenId());
        }
        this.logger.debug("OneSignal NotificationTracker initInfluencedTypeFromCache: " + this.toString());
    }

    @Override
    void addSessionData(@NonNull JSONObject jsonObject, OSInfluence influence) {
        if (influence.getInfluenceType().isAttributed()) {
            try {
                jsonObject.put(DIRECT_TAG, influence.getInfluenceType().isDirect());
                jsonObject.put(NOTIFICATIONS_IDS, (Object)influence.getIds());
            }
            catch (JSONException exception) {
                this.logger.error("Generating notification tracker addSessionData JSONObject ", exception);
            }
        }
    }

    @Override
    public void cacheState() {
        this.dataRepository.cacheNotificationInfluenceType(this.influenceType == null ? OSInfluenceType.UNATTRIBUTED : this.influenceType);
        this.dataRepository.cacheNotificationOpenId(this.directId);
    }
}

