/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import com.onesignal.OSObservable;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalStateSynchronizer;
import org.json.JSONObject;

public class OSEmailSubscriptionState
implements Cloneable {
    OSObservable<Object, OSEmailSubscriptionState> observable = new OSObservable("changed", false);
    private String emailUserId;
    private String emailAddress;

    OSEmailSubscriptionState(boolean asFrom) {
        if (asFrom) {
            this.emailUserId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_ONESIGNAL_EMAIL_ID_LAST", null);
            this.emailAddress = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST", null);
        } else {
            this.emailUserId = OneSignal.getEmailId();
            this.emailAddress = OneSignalStateSynchronizer.getEmailStateSynchronizer().getRegistrationId();
        }
    }

    void clearEmailAndId() {
        boolean changed = this.emailUserId != null || this.emailAddress != null;
        this.emailUserId = null;
        this.emailAddress = null;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    void setEmailUserId(@NonNull String id2) {
        boolean changed = false;
        if (id2 == null) {
            changed = this.emailUserId != null;
        } else if (!id2.equals(this.emailUserId)) {
            changed = true;
        }
        this.emailUserId = id2;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getEmailUserId() {
        return this.emailUserId;
    }

    void setEmailAddress(@NonNull String email) {
        boolean changed = !email.equals(this.emailAddress);
        this.emailAddress = email;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public boolean getSubscribed() {
        return this.emailUserId != null && this.emailAddress != null;
    }

    void persistAsFrom() {
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_ONESIGNAL_EMAIL_ID_LAST", this.emailUserId);
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST", this.emailAddress);
    }

    boolean compare(OSEmailSubscriptionState from) {
        return !(this.emailUserId != null ? this.emailUserId : "").equals(from.emailUserId != null ? from.emailUserId : "") || !(this.emailAddress != null ? this.emailAddress : "").equals(from.emailAddress != null ? from.emailAddress : "");
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            if (this.emailUserId != null) {
                mainObj.put("emailUserId", (Object)this.emailUserId);
            } else {
                mainObj.put("emailUserId", JSONObject.NULL);
            }
            if (this.emailAddress != null) {
                mainObj.put("emailAddress", (Object)this.emailAddress);
            } else {
                mainObj.put("emailAddress", JSONObject.NULL);
            }
            mainObj.put("subscribed", this.getSubscribed());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

