/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.influence.model.OSInfluenceType;
import org.json.JSONArray;
import org.json.JSONException;

class OSInfluenceDataRepository {
    protected static final String PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN = "PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN";
    protected static final String PREFS_OS_LAST_NOTIFICATIONS_RECEIVED = "PREFS_OS_LAST_NOTIFICATIONS_RECEIVED";
    protected static final String PREFS_OS_LAST_IAMS_RECEIVED = "PREFS_OS_LAST_IAMS_RECEIVED";
    protected static final String PREFS_OS_NOTIFICATION_LIMIT = "PREFS_OS_NOTIFICATION_LIMIT";
    protected static final String PREFS_OS_IAM_LIMIT = "PREFS_OS_IAM_LIMIT";
    protected static final String PREFS_OS_NOTIFICATION_INDIRECT_ATTRIBUTION_WINDOW = "PREFS_OS_INDIRECT_ATTRIBUTION_WINDOW";
    protected static final String PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW = "PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW";
    protected static final String PREFS_OS_DIRECT_ENABLED = "PREFS_OS_DIRECT_ENABLED";
    protected static final String PREFS_OS_INDIRECT_ENABLED = "PREFS_OS_INDIRECT_ENABLED";
    protected static final String PREFS_OS_UNATTRIBUTED_ENABLED = "PREFS_OS_UNATTRIBUTED_ENABLED";
    protected static final String PREFS_OS_OUTCOMES_CURRENT_NOTIFICATION_INFLUENCE = "PREFS_OS_OUTCOMES_CURRENT_SESSION";
    protected static final String PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE = "PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE";
    private OSSharedPreferences preferences;

    public OSInfluenceDataRepository(OSSharedPreferences preferences) {
        this.preferences = preferences;
    }

    void cacheNotificationInfluenceType(@NonNull OSInfluenceType influenceType) {
        this.preferences.saveString(this.preferences.getPreferencesName(), PREFS_OS_OUTCOMES_CURRENT_NOTIFICATION_INFLUENCE, influenceType.toString());
    }

    @NonNull
    OSInfluenceType getNotificationCachedInfluenceType() {
        String influenceType = this.preferences.getString(this.preferences.getPreferencesName(), PREFS_OS_OUTCOMES_CURRENT_NOTIFICATION_INFLUENCE, OSInfluenceType.UNATTRIBUTED.toString());
        return OSInfluenceType.fromString(influenceType);
    }

    void cacheIAMInfluenceType(@NonNull OSInfluenceType influenceType) {
        this.preferences.saveString(this.preferences.getPreferencesName(), PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE, influenceType.toString());
    }

    @NonNull
    OSInfluenceType getIAMCachedInfluenceType() {
        String influenceType = this.preferences.getString(this.preferences.getPreferencesName(), PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE, OSInfluenceType.UNATTRIBUTED.toString());
        return OSInfluenceType.fromString(influenceType);
    }

    void cacheNotificationOpenId(@Nullable String id2) {
        this.preferences.saveString(this.preferences.getPreferencesName(), PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN, id2);
    }

    @Nullable
    String getCachedNotificationOpenId() {
        return this.preferences.getString(this.preferences.getPreferencesName(), PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN, null);
    }

    void saveNotifications(@NonNull JSONArray notifications) {
        this.preferences.saveString(this.preferences.getPreferencesName(), PREFS_OS_LAST_NOTIFICATIONS_RECEIVED, notifications.toString());
    }

    void saveIAMs(@NonNull JSONArray iams) {
        this.preferences.saveString(this.preferences.getPreferencesName(), PREFS_OS_LAST_IAMS_RECEIVED, iams.toString());
    }

    JSONArray getLastNotificationsReceivedData() throws JSONException {
        String notificationsReceived = this.preferences.getString(this.preferences.getPreferencesName(), PREFS_OS_LAST_NOTIFICATIONS_RECEIVED, "[]");
        return notificationsReceived != null ? new JSONArray(notificationsReceived) : new JSONArray();
    }

    JSONArray getLastIAMsReceivedData() throws JSONException {
        String iamReceived = this.preferences.getString(this.preferences.getPreferencesName(), PREFS_OS_LAST_IAMS_RECEIVED, "[]");
        return iamReceived != null ? new JSONArray(iamReceived) : new JSONArray();
    }

    int getNotificationLimit() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), PREFS_OS_NOTIFICATION_LIMIT, 10);
    }

    int getIAMLimit() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), PREFS_OS_IAM_LIMIT, 10);
    }

    int getNotificationIndirectAttributionWindow() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), PREFS_OS_NOTIFICATION_INDIRECT_ATTRIBUTION_WINDOW, 1440);
    }

    int getIAMIndirectAttributionWindow() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW, 1440);
    }

    boolean isDirectInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), PREFS_OS_DIRECT_ENABLED, false);
    }

    boolean isIndirectInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), PREFS_OS_INDIRECT_ENABLED, false);
    }

    boolean isUnattributedInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), PREFS_OS_UNATTRIBUTED_ENABLED, false);
    }

    void saveInfluenceParams(OneSignalRemoteParams.InfluenceParams influenceParams) {
        this.preferences.saveBool(this.preferences.getPreferencesName(), PREFS_OS_DIRECT_ENABLED, influenceParams.isDirectEnabled());
        this.preferences.saveBool(this.preferences.getPreferencesName(), PREFS_OS_INDIRECT_ENABLED, influenceParams.isIndirectEnabled());
        this.preferences.saveBool(this.preferences.getPreferencesName(), PREFS_OS_UNATTRIBUTED_ENABLED, influenceParams.isUnattributedEnabled());
        this.preferences.saveInt(this.preferences.getPreferencesName(), PREFS_OS_NOTIFICATION_LIMIT, influenceParams.getNotificationLimit());
        this.preferences.saveInt(this.preferences.getPreferencesName(), PREFS_OS_NOTIFICATION_INDIRECT_ATTRIBUTION_WINDOW, influenceParams.getIndirectNotificationAttributionWindow());
        this.preferences.saveInt(this.preferences.getPreferencesName(), PREFS_OS_IAM_LIMIT, influenceParams.getIamLimit());
        this.preferences.saveInt(this.preferences.getPreferencesName(), PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW, influenceParams.getIndirectIAMAttributionWindow());
    }
}

