/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.JobIntentService;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.telephony.TelephonyManager;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.location.LocationListener;
import com.google.firebase.messaging.FirebaseMessaging;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.location.LocationCallback;
import com.onesignal.OneSignal;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSUtils {
    public static final int UNINITIALIZABLE_STATUS = -999;
    public static int MAX_NETWORK_REQUEST_ATTEMPT_COUNT = 3;
    static final int[] NO_RETRY_NETWROK_REQUEST_STATUS_CODES = new int[]{401, 402, 403, 404, 410};
    private static final int HMS_AVAILABLE_SUCCESSFUL = 0;
    private static final String HMS_CORE_SERVICES_PACKAGE = "com.huawei.hwid";

    OSUtils() {
    }

    public static boolean shouldRetryNetworkRequest(int statusCode) {
        for (int code : NO_RETRY_NETWROK_REQUEST_STATUS_CODES) {
            if (statusCode != code) continue;
            return false;
        }
        return true;
    }

    int initializationChecker(Context context, String oneSignalAppId) {
        Integer supportErrorType;
        Integer pushErrorType;
        int subscribableStatus = 1;
        int deviceType = this.getDeviceType();
        try {
            UUID.fromString(oneSignalAppId);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "OneSignal AppId format is invalid.\nExample: 'b2f7f966-d8cc-11e4-bed1-df8f05be55ba'\n", t);
            return -999;
        }
        if ("b2f7f966-d8cc-11e4-bed1-df8f05be55ba".equals(oneSignalAppId) || "5eb5a37e-b458-11e3-ac11-000c2940e62c".equals(oneSignalAppId)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OneSignal Example AppID detected, please update to your app's id found on OneSignal.com");
        }
        if (deviceType == 1 && (pushErrorType = this.checkForGooglePushLibrary()) != null) {
            subscribableStatus = pushErrorType;
        }
        if ((supportErrorType = this.checkAndroidSupportLibrary(context)) != null) {
            subscribableStatus = supportErrorType;
        }
        return subscribableStatus;
    }

    static boolean hasFCMLibrary() {
        try {
            FirebaseMessaging.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasGCMLibrary() {
        try {
            GoogleCloudMessaging.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasGMSLocationLibrary() {
        try {
            LocationListener.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSAvailabilityLibrary() {
        try {
            HuaweiApiAvailability.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSPushKitLibrary() {
        try {
            HmsInstanceId.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSAGConnectLibrary() {
        try {
            AGConnectServicesConfig.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasHMSLocationLibrary() {
        try {
            LocationCallback.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasAllHMSLibrariesForPushKit() {
        return OSUtils.hasHMSAGConnectLibrary() && OSUtils.hasHMSPushKitLibrary();
    }

    Integer checkForGooglePushLibrary() {
        boolean hasFCMLibrary = OSUtils.hasFCMLibrary();
        boolean hasGCMLibrary = OSUtils.hasGCMLibrary();
        if (!hasFCMLibrary && !hasGCMLibrary) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The Firebase FCM library is missing! Please make sure to include it in your project.");
            return -4;
        }
        if (hasGCMLibrary && !hasFCMLibrary) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "GCM Library detected, please upgrade to Firebase FCM library as GCM is deprecated!");
        }
        if (hasGCMLibrary && hasFCMLibrary) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Both GCM & FCM Libraries detected! Please remove the deprecated GCM library.");
        }
        return null;
    }

    private static boolean hasWakefulBroadcastReceiver() {
        try {
            return WakefulBroadcastReceiver.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean hasNotificationManagerCompat() {
        try {
            return NotificationManagerCompat.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean hasJobIntentService() {
        try {
            return JobIntentService.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Integer checkAndroidSupportLibrary(Context context) {
        boolean hasWakefulBroadcastReceiver = OSUtils.hasWakefulBroadcastReceiver();
        boolean hasNotificationManagerCompat = OSUtils.hasNotificationManagerCompat();
        if (!hasWakefulBroadcastReceiver && !hasNotificationManagerCompat) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Could not find the Android Support Library. Please make sure it has been correctly added to your project.");
            return -3;
        }
        if (!hasWakefulBroadcastReceiver || !hasNotificationManagerCompat) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The included Android Support Library is to old or incomplete. Please update to the 26.0.0 revision or newer.");
            return -5;
        }
        if (Build.VERSION.SDK_INT >= 26 && OSUtils.getTargetSdkVersion(context) >= 26 && !OSUtils.hasJobIntentService()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The included Android Support Library is to old or incomplete. Please update to the 26.0.0 revision or newer.");
            return -5;
        }
        return null;
    }

    private static boolean packageInstalledAndEnabled(@NonNull String packageName) {
        try {
            PackageManager pm = OneSignal.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo(packageName, 128);
            return info.applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    static boolean isGMSInstalledAndEnabled() {
        return OSUtils.packageInstalledAndEnabled("com.google.android.gms");
    }

    private static boolean isHMSCoreInstalledAndEnabled() {
        HuaweiApiAvailability availability = HuaweiApiAvailability.getInstance();
        return availability.isHuaweiMobileServicesAvailable(OneSignal.appContext) == 0;
    }

    private static boolean isHMSCoreInstalledAndEnabledFallback() {
        return OSUtils.packageInstalledAndEnabled(HMS_CORE_SERVICES_PACKAGE);
    }

    private boolean supportsADM() {
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean supportsHMS() {
        if (!OSUtils.hasHMSAvailabilityLibrary() || !OSUtils.hasAllHMSLibrariesForPushKit()) {
            return false;
        }
        return OSUtils.isHMSCoreInstalledAndEnabled();
    }

    private boolean supportsGooglePush() {
        if (!OSUtils.hasFCMLibrary() && !OSUtils.hasGCMLibrary()) {
            return false;
        }
        return OSUtils.isGMSInstalledAndEnabled();
    }

    int getDeviceType() {
        if (this.supportsADM()) {
            return 2;
        }
        if (this.supportsGooglePush()) {
            return 1;
        }
        if (this.supportsHMS()) {
            return 13;
        }
        if (OSUtils.isGMSInstalledAndEnabled()) {
            return 1;
        }
        if (OSUtils.isHMSCoreInstalledAndEnabledFallback()) {
            return 13;
        }
        return 1;
    }

    static boolean isAndroidDeviceType() {
        return new OSUtils().getDeviceType() == 1;
    }

    static boolean isFireOSDeviceType() {
        return new OSUtils().getDeviceType() == 2;
    }

    static boolean isHuaweiDeviceType() {
        return new OSUtils().getDeviceType() == 13;
    }

    Integer getNetType() {
        ConnectivityManager cm = (ConnectivityManager)OneSignal.appContext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo != null) {
            int networkType = netInfo.getType();
            if (networkType == 1 || networkType == 9) {
                return 0;
            }
            return 1;
        }
        return null;
    }

    String getCarrierName() {
        try {
            TelephonyManager manager = (TelephonyManager)OneSignal.appContext.getSystemService("phone");
            String carrierName = manager.getNetworkOperatorName();
            return "".equals(carrierName) ? null : carrierName;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static String getManifestMeta(Context context, String metaName) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString(metaName);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "", t);
            return null;
        }
    }

    static String getResourceString(Context context, String key, String defaultStr) {
        Resources resources = context.getResources();
        int bodyResId = resources.getIdentifier(key, "string", context.getPackageName());
        if (bodyResId != 0) {
            return resources.getString(bodyResId);
        }
        return defaultStr;
    }

    static String getCorrectedLanguage() {
        String lang = Locale.getDefault().getLanguage();
        if (lang.equals("iw")) {
            return "he";
        }
        if (lang.equals("in")) {
            return "id";
        }
        if (lang.equals("ji")) {
            return "yi";
        }
        if (lang.equals("zh")) {
            return lang + "-" + Locale.getDefault().getCountry();
        }
        return lang;
    }

    static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        String emRegex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern pattern = Pattern.compile(emRegex);
        return pattern.matcher(email).matches();
    }

    static boolean areNotificationsEnabled(Context context) {
        try {
            return NotificationManagerCompat.from((Context)OneSignal.appContext).areNotificationsEnabled();
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    static boolean isRunningOnMainThread() {
        return Thread.currentThread().equals(Looper.getMainLooper().getThread());
    }

    static void runOnMainUIThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    static void runOnMainThreadDelayed(Runnable runnable, int delay) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(runnable, (long)delay);
    }

    static int getTargetSdkVersion(Context context) {
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            return applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 15;
        }
    }

    static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    static Uri getSoundUri(Context context, String sound) {
        int soundId;
        Resources resources = context.getResources();
        String packageName = context.getPackageName();
        if (OSUtils.isValidResourceName(sound) && (soundId = resources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = resources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    static long[] parseVibrationPattern(JSONObject gcmBundle) {
        try {
            Object patternObj = gcmBundle.opt("vib_pt");
            JSONArray jsonVibArray = patternObj instanceof String ? new JSONArray((String)patternObj) : (JSONArray)patternObj;
            long[] longArray = new long[jsonVibArray.length()];
            for (int i = 0; i < jsonVibArray.length(); ++i) {
                longArray[i] = jsonVibArray.optLong(i);
            }
            return longArray;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static String hexDigest(String str, String digestInstance) throws Throwable {
        MessageDigest digest = MessageDigest.getInstance(digestInstance);
        digest.update(str.getBytes("UTF-8"));
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            String h = Integer.toHexString(0xFF & aMessageDigest);
            while (h.length() < 2) {
                h = "0" + h;
            }
            hexString.append(h);
        }
        return hexString.toString();
    }

    static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static void openURLInBrowser(@NonNull String url) {
        OSUtils.openURLInBrowser(Uri.parse((String)url.trim()));
    }

    private static void openURLInBrowser(@NonNull Uri uri) {
        Intent intent;
        SchemaType type;
        SchemaType schemaType = type = uri.getScheme() != null ? SchemaType.fromString(uri.getScheme()) : null;
        if (type == null) {
            type = SchemaType.HTTP;
            if (!uri.toString().contains("://")) {
                uri = Uri.parse((String)("http://" + uri.toString()));
            }
        }
        switch (type) {
            case DATA: {
                intent = Intent.makeMainSelectorActivity((String)"android.intent.action.MAIN", (String)"android.intent.category.APP_BROWSER");
                intent.setData(uri);
                break;
            }
            default: {
                intent = new Intent("android.intent.action.VIEW", uri);
            }
        }
        intent.addFlags(0x58080000);
        OneSignal.appContext.startActivity(intent);
    }

    static <T> Set<T> newConcurrentSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    static Set<String> newStringSetFromJSONArray(JSONArray jsonArray) throws JSONException {
        HashSet<String> stringSet = new HashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringSet.add(jsonArray.getString(i));
        }
        return stringSet;
    }

    static boolean hasConfigChangeFlag(Activity activity, int configChangeFlag) {
        boolean hasFlag = false;
        try {
            int configChanges = activity.getPackageManager().getActivityInfo((ComponentName)activity.getComponentName(), (int)0).configChanges;
            int flagInt = configChanges & configChangeFlag;
            hasFlag = flagInt != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return hasFlag;
    }

    @NonNull
    static Collection<String> extractStringsFromCollection(@Nullable Collection<Object> collection) {
        ArrayList<String> result = new ArrayList<String>();
        if (collection == null) {
            return result;
        }
        for (Object value : collection) {
            if (!(value instanceof String)) continue;
            result.add((String)value);
        }
        return result;
    }

    @Nullable
    static Bundle jsonStringToBundle(@NonNull String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            Bundle bundle = new Bundle();
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = jsonObject.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean shouldLogMissingAppIdError(@Nullable String appId) {
        if (appId != null) {
            return false;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignal was not initialized, ensure to always initialize OneSignal from the onCreate of your Application class.");
        return true;
    }

    public static enum SchemaType {
        DATA("data"),
        HTTPS("https"),
        HTTP("http");

        private final String text;

        private SchemaType(String text) {
            this.text = text;
        }

        public static SchemaType fromString(String text) {
            for (SchemaType type : SchemaType.values()) {
                if (!type.text.equalsIgnoreCase(text)) continue;
                return type;
            }
            return null;
        }
    }
}

