/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.influence.OSChannelTracker;
import com.onesignal.influence.OSInAppMessageTracker;
import com.onesignal.influence.OSInfluenceDataRepository;
import com.onesignal.influence.OSNotificationTracker;
import com.onesignal.influence.model.OSInfluence;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class OSTrackerFactory {
    private ConcurrentHashMap<String, OSChannelTracker> trackers = new ConcurrentHashMap();
    private OSInfluenceDataRepository dataRepository;

    public OSTrackerFactory(OSSharedPreferences preferences, OSLogger logger) {
        this.dataRepository = new OSInfluenceDataRepository(preferences);
        this.trackers.put(OSInAppMessageTracker.TAG, new OSInAppMessageTracker(this.dataRepository, logger));
        this.trackers.put(OSNotificationTracker.TAG, new OSNotificationTracker(this.dataRepository, logger));
    }

    public void saveInfluenceParams(OneSignalRemoteParams.InfluenceParams influenceParams) {
        this.dataRepository.saveInfluenceParams(influenceParams);
    }

    public void addSessionData(@NonNull JSONObject jsonObject, List<OSInfluence> influences) {
        for (OSInfluence influence : influences) {
            switch (influence.getInfluenceChannel()) {
                case NOTIFICATION: {
                    this.getNotificationChannelTracker().addSessionData(jsonObject, influence);
                }
            }
        }
    }

    public void initFromCache() {
        for (OSChannelTracker tracker : this.trackers.values()) {
            tracker.initInfluencedTypeFromCache();
        }
    }

    public List<OSInfluence> getInfluences() {
        ArrayList<OSInfluence> influences = new ArrayList<OSInfluence>();
        for (OSChannelTracker tracker : this.trackers.values()) {
            influences.add(tracker.getCurrentSessionInfluence());
        }
        return influences;
    }

    public OSChannelTracker getIAMChannelTracker() {
        return this.trackers.get(OSInAppMessageTracker.TAG);
    }

    public OSChannelTracker getNotificationChannelTracker() {
        return this.trackers.get(OSNotificationTracker.TAG);
    }

    @Nullable
    public OSChannelTracker getChannelByEntryAction(OneSignal.AppEntryAction entryAction) {
        if (entryAction.isNotificationClick()) {
            return this.getNotificationChannelTracker();
        }
        return null;
    }

    public List<OSChannelTracker> getChannels() {
        OSChannelTracker iamChannel;
        ArrayList<OSChannelTracker> channels = new ArrayList<OSChannelTracker>();
        OSChannelTracker notificationChannel = this.getNotificationChannelTracker();
        if (notificationChannel != null) {
            channels.add(notificationChannel);
        }
        if ((iamChannel = this.getIAMChannelTracker()) != null) {
            channels.add(iamChannel);
        }
        return channels;
    }

    public List<OSChannelTracker> getChannelsToResetByEntryAction(OneSignal.AppEntryAction entryAction) {
        OSChannelTracker iamChannel;
        OSChannelTracker notificationChannel;
        ArrayList<OSChannelTracker> channels = new ArrayList<OSChannelTracker>();
        if (entryAction.isAppClose()) {
            return channels;
        }
        if (entryAction.isAppOpen() && (notificationChannel = this.getNotificationChannelTracker()) != null) {
            channels.add(notificationChannel);
        }
        if ((iamChannel = this.getIAMChannelTracker()) != null) {
            channels.add(iamChannel);
        }
        return channels;
    }
}

