/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.location.Location;
import com.huawei.hmf.tasks.OnFailureListener;
import com.huawei.hmf.tasks.OnSuccessListener;
import com.huawei.hms.location.FusedLocationProviderClient;
import com.huawei.hms.location.LocationCallback;
import com.huawei.hms.location.LocationRequest;
import com.huawei.hms.location.LocationResult;
import com.huawei.hms.location.LocationServices;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;

class HMSLocationController
extends LocationController {
    private static FusedLocationProviderClient hmsFusedLocationClient;
    static LocationUpdateListener locationUpdateListener;

    HMSLocationController() {
    }

    static void startGetLocation() {
        HMSLocationController.initHuaweiLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initHuaweiLocation() {
        Object object = syncLock;
        synchronized (object) {
            if (hmsFusedLocationClient == null) {
                try {
                    hmsFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)classContext);
                }
                catch (Exception e) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Huawei LocationServices getFusedLocationProviderClient failed! " + e);
                    HMSLocationController.fireFailedComplete();
                    return;
                }
            }
            if (lastLocation != null) {
                HMSLocationController.fireCompleteForLocation(lastLocation);
            } else {
                hmsFusedLocationClient.getLastLocation().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Location>(){

                    public void onSuccess(Location location) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Huawei LocationServices getLastLocation returned location: " + location);
                        if (location == null) {
                            HMSLocationController.fireFailedComplete();
                            return;
                        }
                        LocationController.lastLocation = location;
                        LocationController.fireCompleteForLocation(LocationController.lastLocation);
                        locationUpdateListener = new LocationUpdateListener(hmsFusedLocationClient);
                    }
                }).addOnFailureListener(new OnFailureListener(){

                    public void onFailure(Exception e) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Huawei LocationServices getLastLocation failed!", e);
                        HMSLocationController.fireFailedComplete();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireFailedComplete() {
        Object object = syncLock;
        synchronized (object) {
            hmsFusedLocationClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onFocusChange() {
        Object object = syncLock;
        synchronized (object) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "HMSLocationController onFocusChange!");
            if (HMSLocationController.isHMSAvailable() && hmsFusedLocationClient == null) {
                return;
            }
            if (hmsFusedLocationClient != null) {
                if (locationUpdateListener != null) {
                    hmsFusedLocationClient.removeLocationUpdates((LocationCallback)locationUpdateListener);
                }
                locationUpdateListener = new LocationUpdateListener(hmsFusedLocationClient);
            }
        }
    }

    static class LocationUpdateListener
    extends LocationCallback {
        private FusedLocationProviderClient huaweiFusedLocationProviderClient;

        LocationUpdateListener(FusedLocationProviderClient huaweiFusedLocationProviderClient) {
            this.huaweiFusedLocationProviderClient = huaweiFusedLocationProviderClient;
            this.init();
        }

        private void init() {
            long updateInterval = 570000L;
            if (OneSignal.isForeground()) {
                updateInterval = 270000L;
            }
            LocationRequest locationRequest = LocationRequest.create().setFastestInterval(updateInterval).setInterval(updateInterval).setMaxWaitTime((long)((double)updateInterval * 1.5)).setPriority(102);
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "HMSLocationController Huawei LocationServices requestLocationUpdates!");
            this.huaweiFusedLocationProviderClient.requestLocationUpdates(locationRequest, (LocationCallback)this, LocationController.locationHandlerThread.getLooper());
        }

        public void onLocationResult(LocationResult locationResult) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "HMSLocationController onLocationResult: " + locationResult);
            if (locationResult != null) {
                LocationController.lastLocation = locationResult.getLastLocation();
            }
        }
    }
}

