/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import com.onesignal.OSLogger;
import com.onesignal.OneSignalApiResponseHandler;
import com.onesignal.OutcomeEvent;
import com.onesignal.outcomes.OSOutcomeEventsCache;
import com.onesignal.outcomes.OSOutcomeEventsRepository;
import com.onesignal.outcomes.domain.OutcomeEventsService;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import org.json.JSONException;
import org.json.JSONObject;

class OSOutcomeEventsV1Repository
extends OSOutcomeEventsRepository {
    private static final String DIRECT = "direct";

    OSOutcomeEventsV1Repository(OSLogger logger, OSOutcomeEventsCache outcomeEventsCache, OutcomeEventsService outcomeEventsService) {
        super(logger, outcomeEventsCache, outcomeEventsService);
    }

    @Override
    public void requestMeasureOutcomeEvent(String appId, int deviceType, OSOutcomeEventParams eventParams, OneSignalApiResponseHandler responseHandler) {
        OutcomeEvent event = OutcomeEvent.fromOutcomeEventParamsV2toOutcomeEventV1(eventParams);
        switch (event.getSession()) {
            case DIRECT: {
                this.requestMeasureDirectOutcomeEvent(appId, deviceType, event, responseHandler);
                break;
            }
            case INDIRECT: {
                this.requestMeasureIndirectOutcomeEvent(appId, deviceType, event, responseHandler);
                break;
            }
            case UNATTRIBUTED: {
                this.requestMeasureUnattributedOutcomeEvent(appId, deviceType, event, responseHandler);
                break;
            }
        }
    }

    private void requestMeasureDirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalApiResponseHandler responseHandler) {
        try {
            JSONObject jsonObject = event.toJSONObjectForMeasure();
            jsonObject.put("app_id", (Object)appId);
            jsonObject.put("device_type", deviceType);
            jsonObject.put(DIRECT, true);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            this.logger.error("Generating direct outcome:JSON Failed.", e);
        }
    }

    private void requestMeasureIndirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalApiResponseHandler responseHandler) {
        try {
            JSONObject jsonObject = event.toJSONObjectForMeasure();
            jsonObject.put("app_id", (Object)appId);
            jsonObject.put("device_type", deviceType);
            jsonObject.put(DIRECT, false);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            this.logger.error("Generating indirect outcome:JSON Failed.", e);
        }
    }

    private void requestMeasureUnattributedOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalApiResponseHandler responseHandler) {
        try {
            JSONObject jsonObject = event.toJSONObjectForMeasure();
            jsonObject.put("app_id", (Object)appId);
            jsonObject.put("device_type", deviceType);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            this.logger.error("Generating unattributed outcome:JSON Failed.", e);
        }
    }
}

