/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalDb;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.influence.model.OSInfluenceChannel;
import com.onesignal.influence.model.OSInfluenceType;
import com.onesignal.outcomes.model.OSCachedUniqueOutcome;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import com.onesignal.outcomes.model.OSOutcomeSource;
import com.onesignal.outcomes.model.OSOutcomeSourceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class OSOutcomeEventsCache {
    private static final String PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT = "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT";
    private OSLogger logger;
    private OneSignalDb dbHelper;
    private OSSharedPreferences preferences;

    OSOutcomeEventsCache(OSLogger logger, OneSignalDb dbHelper, OSSharedPreferences preferences) {
        this.logger = logger;
        this.dbHelper = dbHelper;
        this.preferences = preferences;
    }

    boolean isOutcomesV2ServiceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), this.preferences.getOutcomesV2KeyName(), false);
    }

    Set<String> getUnattributedUniqueOutcomeEventsSentByChannel() {
        return this.preferences.getStringSet(this.preferences.getPreferencesName(), PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT, null);
    }

    void saveUnattributedUniqueOutcomeEventsSentByChannel(Set<String> unattributedUniqueOutcomeEvents) {
        this.preferences.saveStringSet(this.preferences.getPreferencesName(), PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT, unattributedUniqueOutcomeEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized void deleteOldOutcomeEvent(OSOutcomeEventParams event) {
        SQLiteDatabase writableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
        try {
            writableDb.beginTransaction();
            writableDb.delete("outcome", "timestamp = ?", new String[]{String.valueOf(event.getTimestamp())});
            writableDb.setTransactionSuccessful();
        }
        catch (SQLiteException e) {
            this.logger.error("Error deleting old outcome event records! ", e);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (SQLiteException e) {
                    this.logger.error("Error closing transaction! ", e);
                }
            }
        }
    }

    @WorkerThread
    synchronized void saveOutcomeEvent(OSOutcomeEventParams eventParams) {
        SQLiteDatabase writableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
        JSONArray notificationIds = new JSONArray();
        JSONArray iamIds = new JSONArray();
        OSInfluenceType notificationInfluenceType = OSInfluenceType.UNATTRIBUTED;
        OSInfluenceType iamInfluenceType = OSInfluenceType.UNATTRIBUTED;
        if (eventParams.getOutcomeSource() != null) {
            OSOutcomeSource source = eventParams.getOutcomeSource();
            if (source.getDirectBody() != null) {
                OSOutcomeSourceBody directBody = source.getDirectBody();
                if (directBody.getNotificationIds() != null && directBody.getNotificationIds().length() > 0) {
                    notificationInfluenceType = OSInfluenceType.DIRECT;
                    notificationIds = source.getDirectBody().getNotificationIds();
                }
                if (directBody.getInAppMessagesIds() != null && directBody.getInAppMessagesIds().length() > 0) {
                    iamInfluenceType = OSInfluenceType.DIRECT;
                    iamIds = source.getDirectBody().getInAppMessagesIds();
                }
            }
            if (source.getIndirectBody() != null) {
                OSOutcomeSourceBody indirectBody = source.getIndirectBody();
                if (indirectBody.getNotificationIds() != null && indirectBody.getNotificationIds().length() > 0) {
                    notificationInfluenceType = OSInfluenceType.INDIRECT;
                    notificationIds = source.getIndirectBody().getNotificationIds();
                }
                if (indirectBody.getInAppMessagesIds() != null && indirectBody.getInAppMessagesIds().length() > 0) {
                    iamInfluenceType = OSInfluenceType.INDIRECT;
                    iamIds = source.getIndirectBody().getInAppMessagesIds();
                }
            }
        }
        ContentValues values = new ContentValues();
        values.put("notification_ids", notificationIds.toString());
        values.put("iam_ids", iamIds.toString());
        values.put("notification_influence_type", notificationInfluenceType.toString().toLowerCase());
        values.put("iam_influence_type", iamInfluenceType.toString().toLowerCase());
        values.put("name", eventParams.getOutcomeId());
        values.put("weight", eventParams.getWeight());
        values.put("timestamp", Long.valueOf(eventParams.getTimestamp()));
        writableDb.insert("outcome", null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSOutcomeEventParams> getAllEventsToSend() {
        ArrayList<OSOutcomeEventParams> events = new ArrayList<OSOutcomeEventParams>();
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
            cursor = readableDb.query("outcome", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String notificationInfluenceTypeString = cursor.getString(cursor.getColumnIndex("notification_influence_type"));
                    OSInfluenceType notificationInfluenceType = OSInfluenceType.fromString(notificationInfluenceTypeString);
                    String iamInfluenceTypeString = cursor.getString(cursor.getColumnIndex("iam_influence_type"));
                    OSInfluenceType iamInfluenceType = OSInfluenceType.fromString(iamInfluenceTypeString);
                    String notificationIds = cursor.getString(cursor.getColumnIndex("notification_ids"));
                    notificationIds = notificationIds != null ? notificationIds : "[]";
                    String iamIds = cursor.getString(cursor.getColumnIndex("iam_ids"));
                    iamIds = iamIds != null ? iamIds : "[]";
                    String name = cursor.getString(cursor.getColumnIndex("name"));
                    float weight = cursor.getFloat(cursor.getColumnIndex("weight"));
                    long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                    try {
                        OSOutcomeSourceBody directSourceBody = new OSOutcomeSourceBody();
                        OSOutcomeSourceBody indirectSourceBody = new OSOutcomeSourceBody();
                        OSOutcomeSource source = null;
                        switch (notificationInfluenceType) {
                            case DIRECT: {
                                directSourceBody.setNotificationIds(new JSONArray(notificationIds));
                                source = new OSOutcomeSource(directSourceBody, null);
                                break;
                            }
                            case INDIRECT: {
                                indirectSourceBody.setNotificationIds(new JSONArray(notificationIds));
                                source = new OSOutcomeSource(null, indirectSourceBody);
                                break;
                            }
                            case UNATTRIBUTED: {
                                break;
                            }
                        }
                        switch (iamInfluenceType) {
                            case DIRECT: {
                                directSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                                source = source == null ? new OSOutcomeSource(directSourceBody, null) : source.setDirectBody(directSourceBody);
                                break;
                            }
                            case INDIRECT: {
                                indirectSourceBody.setInAppMessagesIds(new JSONArray(iamIds));
                                source = source == null ? new OSOutcomeSource(null, indirectSourceBody) : source.setIndirectBody(indirectSourceBody);
                                break;
                            }
                            case UNATTRIBUTED: {
                                break;
                            }
                        }
                        OSOutcomeEventParams eventParams = new OSOutcomeEventParams(name, source, weight, timestamp);
                        events.add(eventParams);
                    }
                    catch (JSONException e) {
                        this.logger.error("Generating JSONArray from notifications ids outcome:JSON Failed.", e);
                    }
                } while (cursor.moveToNext());
            }
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return events;
    }

    private void addIdToListFromChannel(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, JSONArray channelIds, OSInfluenceChannel channel) {
        if (channelIds != null) {
            for (int i = 0; i < channelIds.length(); ++i) {
                try {
                    String influenceId = channelIds.getString(i);
                    cachedUniqueOutcomes.add(new OSCachedUniqueOutcome(influenceId, channel));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addIdsToListFromSource(List<OSCachedUniqueOutcome> cachedUniqueOutcomes, OSOutcomeSourceBody sourceBody) {
        if (sourceBody != null) {
            JSONArray iamIds = sourceBody.getInAppMessagesIds();
            JSONArray notificationIds = sourceBody.getNotificationIds();
            this.addIdToListFromChannel(cachedUniqueOutcomes, iamIds, OSInfluenceChannel.IAM);
            this.addIdToListFromChannel(cachedUniqueOutcomes, notificationIds, OSInfluenceChannel.NOTIFICATION);
        }
    }

    @WorkerThread
    synchronized void saveUniqueOutcomeEventParams(@NonNull OSOutcomeEventParams eventParams) {
        this.logger.debug("OneSignal saveUniqueOutcomeEventParams: " + eventParams.toString());
        if (eventParams.getOutcomeSource() == null) {
            return;
        }
        String outcomeName = eventParams.getOutcomeId();
        ArrayList<OSCachedUniqueOutcome> cachedUniqueOutcomes = new ArrayList<OSCachedUniqueOutcome>();
        OSOutcomeSourceBody directBody = eventParams.getOutcomeSource().getDirectBody();
        OSOutcomeSourceBody indirectBody = eventParams.getOutcomeSource().getIndirectBody();
        this.addIdsToListFromSource(cachedUniqueOutcomes, directBody);
        this.addIdsToListFromSource(cachedUniqueOutcomes, indirectBody);
        SQLiteDatabase writableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
        for (OSCachedUniqueOutcome uniqueOutcome : cachedUniqueOutcomes) {
            ContentValues values = new ContentValues();
            values.put("channel_influence_id", uniqueOutcome.getInfluenceId());
            values.put("channel_type", String.valueOf((Object)uniqueOutcome.getChannel()));
            values.put("name", outcomeName);
            writableDb.insert("cached_unique_outcome", null, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSInfluence> getNotCachedUniqueInfluencesForOutcome(String name, List<OSInfluence> influences) {
        ArrayList<OSInfluence> uniqueInfluences = new ArrayList<OSInfluence>();
        SQLiteDatabase readableDb = this.dbHelper.getSQLiteDatabaseWithRetries();
        Cursor cursor = null;
        try {
            for (OSInfluence influence : influences) {
                JSONArray availableInfluenceIds = new JSONArray();
                JSONArray influenceIds = influence.getIds();
                if (influenceIds == null) continue;
                for (int i = 0; i < influenceIds.length(); ++i) {
                    OSInfluenceChannel channel;
                    String[] columns = new String[]{};
                    String where = "channel_influence_id = ? AND channel_type = ? AND name = ?";
                    String channelInfluenceId = influenceIds.getString(i);
                    String[] args = new String[]{channelInfluenceId, String.valueOf((Object)(channel = influence.getInfluenceChannel())), name};
                    cursor = readableDb.query("cached_unique_outcome", columns, where, args, null, null, null, "1");
                    if (cursor.getCount() != 0) continue;
                    availableInfluenceIds.put((Object)channelInfluenceId);
                }
                if (availableInfluenceIds.length() <= 0) continue;
                OSInfluence newInfluence = influence.copy();
                newInfluence.setIds(availableInfluenceIds);
                uniqueInfluences.add(newInfluence);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return uniqueInfluences;
    }
}

