/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.influence.model.OSInfluenceChannel;
import com.onesignal.influence.model.OSInfluenceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OSInfluence {
    private static final String INFLUENCE_CHANNEL = "influence_channel";
    private static final String INFLUENCE_TYPE = "influence_type";
    private static final String INFLUENCE_IDS = "influence_ids";
    private OSInfluenceChannel influenceChannel;
    private OSInfluenceType influenceType;
    @Nullable
    private JSONArray ids;

    private OSInfluence() {
    }

    public OSInfluence(@NonNull String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        String channel = jsonObject.getString(INFLUENCE_CHANNEL);
        String type = jsonObject.getString(INFLUENCE_TYPE);
        String ids = jsonObject.getString(INFLUENCE_IDS);
        this.influenceChannel = OSInfluenceChannel.fromString(channel);
        this.influenceType = OSInfluenceType.fromString(type);
        this.ids = ids != null ? new JSONArray(ids) : null;
    }

    OSInfluence(@NonNull Builder builder) {
        this.ids = builder.ids;
        this.influenceType = builder.influenceType;
        this.influenceChannel = builder.influenceChannel;
    }

    public OSInfluenceChannel getInfluenceChannel() {
        return this.influenceChannel;
    }

    @NonNull
    public OSInfluenceType getInfluenceType() {
        return this.influenceType;
    }

    @Nullable
    public JSONArray getIds() {
        return this.ids;
    }

    @Nullable
    public String getDirectId() throws JSONException {
        return this.ids != null && this.ids.length() > 0 ? this.ids.getString(0) : null;
    }

    public void setIds(@NonNull JSONArray ids) {
        this.ids = ids;
    }

    public OSInfluence copy() {
        OSInfluence influence = new OSInfluence();
        influence.ids = this.ids;
        influence.influenceType = this.influenceType;
        influence.influenceChannel = this.influenceChannel;
        return influence;
    }

    public String toJSONString() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(INFLUENCE_CHANNEL, (Object)this.influenceChannel.toString());
        jsonObject.put(INFLUENCE_TYPE, (Object)this.influenceType.toString());
        jsonObject.put(INFLUENCE_IDS, this.ids != null ? this.ids.toString() : null);
        return jsonObject.toString();
    }

    public String toString() {
        return "SessionInfluence{influenceChannel=" + (Object)((Object)this.influenceChannel) + ", influenceType=" + (Object)((Object)this.influenceType) + ", ids=" + this.ids + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSInfluence that = (OSInfluence)o;
        return this.influenceChannel == that.influenceChannel && this.influenceType == that.influenceType;
    }

    public int hashCode() {
        int result = this.influenceChannel.hashCode();
        result = 31 * result + this.influenceType.hashCode();
        return result;
    }

    public static class Builder {
        private JSONArray ids;
        private OSInfluenceType influenceType;
        private OSInfluenceChannel influenceChannel;

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setIds(@Nullable JSONArray ids) {
            this.ids = ids;
            return this;
        }

        public Builder setInfluenceType(@NonNull OSInfluenceType influenceType) {
            this.influenceType = influenceType;
            return this;
        }

        public Builder setInfluenceChannel(OSInfluenceChannel influenceChannel) {
            this.influenceChannel = influenceChannel;
            return this;
        }

        public OSInfluence build() {
            return new OSInfluence(this);
        }
    }
}

