/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalSyncServiceUtils;
import com.onesignal.influence.model.OSInfluence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class FocusTimeController {
    @Nullable
    private Long timeFocusedAtMs;
    private static FocusTimeController sInstance;
    private List<FocusTimeProcessorBase> focusTimeProcessors = Arrays.asList(new FocusTimeProcessorUnattributed(), new FocusTimeProcessorAttributed());

    private FocusTimeController() {
    }

    public static synchronized FocusTimeController getInstance() {
        if (sInstance == null) {
            sInstance = new FocusTimeController();
        }
        return sInstance;
    }

    void appForegrounded() {
        this.timeFocusedAtMs = SystemClock.elapsedRealtime();
    }

    void appBackgrounded() {
        this.giveProcessorsValidFocusTime(OneSignal.getSessionManager().getInfluences(), FocusEventType.BACKGROUND);
        this.timeFocusedAtMs = null;
    }

    void onSessionEnded(@NonNull List<OSInfluence> lastInfluences) {
        FocusEventType focusEventType = FocusEventType.END_SESSION;
        boolean hadValidTime = this.giveProcessorsValidFocusTime(lastInfluences, focusEventType);
        if (!hadValidTime) {
            for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
                focusTimeProcessor.sendUnsentTimeNow(focusEventType);
            }
        }
    }

    void doBlockingBackgroundSyncOfUnsentTime() {
        if (OneSignal.isForeground()) {
            return;
        }
        for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
            focusTimeProcessor.syncUnsentTimeFromSyncJob();
        }
    }

    private boolean giveProcessorsValidFocusTime(@NonNull List<OSInfluence> influences, @NonNull FocusEventType focusType) {
        Long timeElapsed = this.getTimeFocusedElapsed();
        if (timeElapsed == null) {
            return false;
        }
        for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
            focusTimeProcessor.addTime(timeElapsed, influences, focusType);
        }
        return true;
    }

    @Nullable
    private Long getTimeFocusedElapsed() {
        if (this.timeFocusedAtMs == null) {
            return null;
        }
        long timeElapsed = (long)((double)(SystemClock.elapsedRealtime() - this.timeFocusedAtMs) / 1000.0 + 0.5);
        if (timeElapsed < 1L || timeElapsed > 86400L) {
            return null;
        }
        return timeElapsed;
    }

    private static abstract class FocusTimeProcessorBase {
        protected long MIN_ON_FOCUS_TIME_SEC;
        @NonNull
        protected String PREF_KEY_FOR_UNSENT_TIME;
        @Nullable
        private Long unsentActiveTime = null;
        @NonNull
        private final AtomicBoolean runningOnFocusTime = new AtomicBoolean();

        private FocusTimeProcessorBase() {
        }

        protected abstract boolean timeTypeApplies(@NonNull List<OSInfluence> var1);

        protected abstract void sendTime(@NonNull FocusEventType var1);

        protected abstract void saveInfluences(List<OSInfluence> var1);

        private long getUnsentActiveTime() {
            if (this.unsentActiveTime == null) {
                this.unsentActiveTime = OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, 0L);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":getUnsentActiveTime: " + this.unsentActiveTime);
            return this.unsentActiveTime;
        }

        private void saveUnsentActiveTime(long time) {
            this.unsentActiveTime = time;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":saveUnsentActiveTime: " + this.unsentActiveTime);
            OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, time);
        }

        private void addTime(long time, @NonNull List<OSInfluence> influences, @NonNull FocusEventType focusType) {
            if (!this.timeTypeApplies(influences)) {
                return;
            }
            this.saveInfluences(influences);
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":addTime with lastFocusTimeInfluences: " + influences.toString());
            long totalTime = this.getUnsentActiveTime() + time;
            this.saveUnsentActiveTime(totalTime);
            this.sendUnsentTimeNow(focusType);
        }

        private void sendUnsentTimeNow(FocusEventType focusType) {
            if (!OneSignal.hasUserId()) {
                return;
            }
            this.sendTime(focusType);
        }

        private boolean hasMinSyncTime() {
            return this.getUnsentActiveTime() >= this.MIN_ON_FOCUS_TIME_SEC;
        }

        protected void syncUnsentTimeOnBackgroundEvent() {
            if (!this.hasMinSyncTime()) {
                return;
            }
            OneSignalSyncServiceUtils.scheduleSyncTask(OneSignal.appContext);
            this.syncOnFocusTime();
        }

        private void syncUnsentTimeFromSyncJob() {
            if (this.hasMinSyncTime()) {
                this.syncOnFocusTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        protected void syncOnFocusTime() {
            if (this.runningOnFocusTime.get()) {
                return;
            }
            AtomicBoolean atomicBoolean = this.runningOnFocusTime;
            synchronized (atomicBoolean) {
                this.runningOnFocusTime.set(true);
                if (this.hasMinSyncTime()) {
                    this.sendOnFocus(this.getUnsentActiveTime());
                }
                this.runningOnFocusTime.set(false);
            }
        }

        private void sendOnFocusToPlayer(@NonNull String userId, @NonNull JSONObject jsonBody) {
            OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
                }

                @Override
                void onSuccess(String response) {
                    FocusTimeProcessorBase.this.saveUnsentActiveTime(0L);
                }
            };
            String url = "players/" + userId + "/on_focus";
            OneSignalRestClient.postSync(url, jsonBody, responseHandler);
        }

        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
        }

        @NonNull
        private JSONObject generateOnFocusPayload(long totalTimeActive) throws JSONException {
            JSONObject jsonBody = new JSONObject().put("app_id", (Object)OneSignal.getSavedAppId()).put("type", 1).put("state", (Object)"ping").put("active_time", totalTimeActive).put("device_type", new OSUtils().getDeviceType());
            OneSignal.addNetType(jsonBody);
            return jsonBody;
        }

        private void sendOnFocus(long totalTimeActive) {
            try {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":sendOnFocus with totalTimeActive: " + totalTimeActive);
                JSONObject jsonBody = this.generateOnFocusPayload(totalTimeActive);
                this.additionalFieldsToAddToOnFocusPayload(jsonBody);
                this.sendOnFocusToPlayer(OneSignal.getUserId(), jsonBody);
                if (OneSignal.hasEmailId()) {
                    this.sendOnFocusToPlayer(OneSignal.getEmailId(), this.generateOnFocusPayload(totalTimeActive));
                }
            }
            catch (JSONException t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
            }
        }
    }

    private static class FocusTimeProcessorAttributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorAttributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 1L;
            this.PREF_KEY_FOR_UNSENT_TIME = "OS_UNSENT_ATTRIBUTED_ACTIVE_TIME";
        }

        private List<OSInfluence> getInfluences() {
            ArrayList<OSInfluence> influences = new ArrayList<OSInfluence>();
            Set<String> influenceJSONs = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ATTRIBUTED_INFLUENCES", new HashSet<String>());
            for (String influenceJSON : influenceJSONs) {
                try {
                    influences.add(new OSInfluence(influenceJSON));
                }
                catch (JSONException exception) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, this.getClass().getSimpleName() + ": error generation OSInfluence from json object: " + (Object)((Object)exception));
                }
            }
            return influences;
        }

        @Override
        protected void saveInfluences(List<OSInfluence> influences) {
            HashSet<String> setInfluences = new HashSet<String>();
            for (OSInfluence influence : influences) {
                try {
                    setInfluences.add(influence.toJSONString());
                }
                catch (JSONException exception) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, this.getClass().getSimpleName() + ": error generation json object OSInfluence: " + (Object)((Object)exception));
                }
            }
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ATTRIBUTED_INFLUENCES", setInfluences);
        }

        @Override
        protected boolean timeTypeApplies(@NonNull List<OSInfluence> influences) {
            for (OSInfluence influence : influences) {
                if (!influence.getInfluenceType().isAttributed()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
            OneSignal.getSessionManager().addSessionIds(jsonBody, this.getInfluences());
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                this.syncOnFocusTime();
            } else {
                OneSignalSyncServiceUtils.scheduleSyncTask(OneSignal.appContext);
            }
        }
    }

    private static class FocusTimeProcessorUnattributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorUnattributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 60L;
            this.PREF_KEY_FOR_UNSENT_TIME = "GT_UNSENT_ACTIVE_TIME";
        }

        @Override
        protected boolean timeTypeApplies(@NonNull List<OSInfluence> influences) {
            for (OSInfluence influence : influences) {
                if (!influence.getInfluenceType().isAttributed()) continue;
                return false;
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":timeTypeApplies for influences: " + influences.toString() + " true");
            return true;
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                return;
            }
            this.syncUnsentTimeOnBackgroundEvent();
        }

        @Override
        protected void saveInfluences(List<OSInfluence> influences) {
        }
    }

    private static enum FocusEventType {
        BACKGROUND,
        END_SESSION;

    }
}

