/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.R;

public class PermissionsActivity
extends Activity {
    private static final String TAG = PermissionsActivity.class.getCanonicalName();
    private static final int DELAY_TIME_CALLBACK_CALL = 500;
    private static final int REQUEST_LOCATION = 2;
    static boolean waiting;
    static boolean answered;
    private static ActivityLifecycleHandler.ActivityAvailableListener activityAvailableListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        OneSignal.setAppContext((Context)this);
        if (savedInstanceState != null && savedInstanceState.getBoolean("android:hasCurrentPermissionsRequest", false)) {
            waiting = true;
        } else {
            this.requestPermission();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (OneSignal.isInitDone()) {
            this.requestPermission();
        }
    }

    private void requestPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            this.finish();
            this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
            return;
        }
        if (!waiting) {
            waiting = true;
            AndroidSupportV4Compat.ActivityCompat.requestPermissions(this, new String[]{LocationGMS.requestPermission}, 2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, final @NonNull int[] grantResults) {
        answered = true;
        waiting = false;
        if (requestCode == 2) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    boolean granted = grantResults.length > 0 && grantResults[0] == 0;
                    LocationGMS.sendAndClearPromptHandlers(true, granted);
                    if (granted) {
                        LocationGMS.startGetLocation();
                    } else {
                        LocationGMS.fireFailedComplete();
                    }
                }
            }, 500L);
        }
        ActivityLifecycleHandler.removeActivityAvailableListener(TAG);
        this.finish();
        this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
    }

    static void startPrompt() {
        if (waiting || answered) {
            return;
        }
        activityAvailableListener = new ActivityLifecycleHandler.ActivityAvailableListener(){

            @Override
            public void available(@NonNull Activity activity) {
                if (!activity.getClass().equals(PermissionsActivity.class)) {
                    Intent intent = new Intent((Context)activity, PermissionsActivity.class);
                    intent.setFlags(131072);
                    activity.startActivity(intent);
                    activity.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
                }
            }
        };
        ActivityLifecycleHandler.setActivityAvailableListener(TAG, activityAvailableListener);
    }
}

