/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.view.ViewTreeObserver;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ActivityLifecycleHandler {
    static boolean nextResumeIsFirstActivity;
    private static Map<String, ActivityAvailableListener> sActivityAvailableListeners;
    private static Map<String, OSSystemConditionController.OSSystemConditionObserver> sSystemConditionObservers;
    private static Map<String, KeyboardListener> sKeyboardListeners;
    static FocusHandlerThread focusHandlerThread;
    @SuppressLint(value={"StaticFieldLeak"})
    static Activity curActivity;

    ActivityLifecycleHandler() {
    }

    static void setSystemConditionObserver(String key, OSSystemConditionController.OSSystemConditionObserver systemConditionObserver) {
        if (curActivity != null) {
            ViewTreeObserver treeObserver = curActivity.getWindow().getDecorView().getViewTreeObserver();
            KeyboardListener keyboardListener = new KeyboardListener(systemConditionObserver, key);
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(key, keyboardListener);
        }
        sSystemConditionObservers.put(key, systemConditionObserver);
    }

    static void setActivityAvailableListener(String key, ActivityAvailableListener activityAvailableListener) {
        sActivityAvailableListeners.put(key, activityAvailableListener);
        if (curActivity != null) {
            activityAvailableListener.available(curActivity);
        }
    }

    static void removeSystemConditionObserver(String key) {
        sKeyboardListeners.remove(key);
        sSystemConditionObservers.remove(key);
    }

    static void removeActivityAvailableListener(String key) {
        sActivityAvailableListeners.remove(key);
    }

    private static void setCurActivity(Activity activity) {
        curActivity = activity;
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(curActivity);
        }
        try {
            ViewTreeObserver treeObserver = curActivity.getWindow().getDecorView().getViewTreeObserver();
            for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
                KeyboardListener keyboardListener = new KeyboardListener(entry.getValue(), entry.getKey());
                treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
                sKeyboardListeners.put(entry.getKey(), keyboardListener);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    static void onConfigurationChanged(Configuration newConfig) {
        if (curActivity != null && OSUtils.hasConfigChangeFlag(curActivity, 128)) {
            ActivityLifecycleHandler.logOrientationChange(newConfig.orientation);
            ActivityLifecycleHandler.onOrientationChanged();
        }
    }

    static void onActivityCreated(Activity activity) {
    }

    static void onActivityStarted(Activity activity) {
    }

    static void onActivityResumed(Activity activity) {
        ActivityLifecycleHandler.setCurActivity(activity);
        ActivityLifecycleHandler.logCurActivity();
        ActivityLifecycleHandler.handleFocus();
    }

    static void onActivityPaused(Activity activity) {
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    static void onActivityStopped(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityStopped: " + activity);
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(new WeakReference<Activity>(activity));
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    static void onActivityDestroyed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityDestroyed: " + activity);
        sKeyboardListeners.clear();
        if (activity == curActivity) {
            curActivity = null;
            ActivityLifecycleHandler.handleLostFocus();
        }
        ActivityLifecycleHandler.logCurActivity();
    }

    private static void logCurActivity() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "curActivity is NOW: " + (curActivity != null ? "" + curActivity.getClass().getName() + ":" + curActivity : "null"));
    }

    private static void logOrientationChange(int orientation) {
        if (orientation == 2) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: LANDSCAPE (" + orientation + ")");
        } else if (orientation == 1) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: PORTRAIT (" + orientation + ")");
        }
    }

    private static void onOrientationChanged() {
        ActivityLifecycleHandler.handleLostFocus();
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(new WeakReference<Activity>(curActivity));
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(curActivity);
        }
        ViewTreeObserver treeObserver = curActivity.getWindow().getDecorView().getViewTreeObserver();
        for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
            KeyboardListener keyboardListener = new KeyboardListener(entry.getValue(), entry.getKey());
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(entry.getKey(), keyboardListener);
        }
        ActivityLifecycleHandler.handleFocus();
    }

    private static void handleLostFocus() {
        focusHandlerThread.runRunnable(new AppFocusRunnable());
    }

    private static void handleFocus() {
        if (focusHandlerThread.hasBackgrounded() || nextResumeIsFirstActivity) {
            nextResumeIsFirstActivity = false;
            focusHandlerThread.resetBackgroundState();
            OneSignal.onAppFocus();
        } else {
            focusHandlerThread.stopScheduledRunnable();
        }
    }

    static {
        sActivityAvailableListeners = new ConcurrentHashMap<String, ActivityAvailableListener>();
        sSystemConditionObservers = new ConcurrentHashMap<String, OSSystemConditionController.OSSystemConditionObserver>();
        sKeyboardListeners = new ConcurrentHashMap<String, KeyboardListener>();
        focusHandlerThread = new FocusHandlerThread();
    }

    private static class KeyboardListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final OSSystemConditionController.OSSystemConditionObserver observer;
        private final String key;

        private KeyboardListener(OSSystemConditionController.OSSystemConditionObserver observer, String key) {
            this.observer = observer;
            this.key = key;
        }

        public void onGlobalLayout() {
            boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(curActivity));
            if (!keyboardUp) {
                if (curActivity != null) {
                    ViewTreeObserver treeObserver = curActivity.getWindow().getDecorView().getViewTreeObserver();
                    if (Build.VERSION.SDK_INT < 16) {
                        treeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        treeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
                ActivityLifecycleHandler.removeSystemConditionObserver(this.key);
                this.observer.messageTriggerConditionChanged();
            }
        }
    }

    private static class AppFocusRunnable
    implements Runnable {
        private boolean backgrounded;
        private boolean completed;

        private AppFocusRunnable() {
        }

        @Override
        public void run() {
            if (curActivity != null) {
                return;
            }
            this.backgrounded = true;
            OneSignal.onAppLostFocus();
            this.completed = true;
        }
    }

    static class FocusHandlerThread
    extends HandlerThread {
        private Handler mHandler;
        private AppFocusRunnable appFocusRunnable;

        FocusHandlerThread() {
            super("FocusHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        Looper getHandlerLooper() {
            return this.mHandler.getLooper();
        }

        void resetBackgroundState() {
            if (this.appFocusRunnable != null) {
                this.appFocusRunnable.backgrounded = false;
            }
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        void runRunnable(AppFocusRunnable runnable) {
            if (this.appFocusRunnable != null && this.appFocusRunnable.backgrounded && !this.appFocusRunnable.completed) {
                return;
            }
            this.appFocusRunnable = runnable;
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed((Runnable)runnable, 2000L);
        }

        boolean hasBackgrounded() {
            return this.appFocusRunnable != null && this.appFocusRunnable.backgrounded;
        }
    }

    static abstract class ActivityAvailableListener {
        ActivityAvailableListener() {
        }

        void available(@NonNull Activity activity) {
        }

        void stopped(WeakReference<Activity> reference) {
        }
    }
}

